/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.content;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.i18n.I18n;
import design.aem.components.ComponentProperties;
import design.aem.models.ModelProxy;
import design.aem.utils.components.CommonUtil;
import design.aem.utils.components.ComponentsUtil;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageDate
extends ModelProxy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(PageDate.class);
    protected ComponentProperties componentProperties = null;
    private static String PUBLISH_DATE_FORMAT = "yyyy-MM-dd";
    private static final String FIELD_PUBLISH_DATE = "publishDate";
    private static String PUBLISH_DATE_DISPLAY_FORMAT = "EEEE dd MMMM YYYY";

    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    @Override
    protected void ready() {
        I18n i18n = new I18n((HttpServletRequest)this.getRequest());
        String DEFAULT_I18N_CATEGORY = "pagedate";
        this.setComponentFields(new Object[][]{{"variant", "default"}, {FIELD_PUBLISH_DATE, CommonUtil.getPageCreated(this.getPageProperties())}, {"jcr:created", ""}});
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY, ComponentsUtil.DEFAULT_FIELDS_DETAILS_OPTIONS});
        long publishDateLong = (Long)this.componentProperties.get(FIELD_PUBLISH_DATE, 0L);
        Calendar publishDate = Calendar.getInstance();
        publishDate.setTimeInMillis(publishDateLong);
        String dateFormatString = i18n.get("publishDateFormat", "pagedate");
        String dateDisplayFormatString = i18n.get("publishDateDisplayFormat", "pagedate");
        if (dateFormatString.equals("publishDateFormat")) {
            dateFormatString = PUBLISH_DATE_FORMAT;
        }
        if (dateDisplayFormatString.equals("publishDateDisplayFormat")) {
            dateDisplayFormatString = PUBLISH_DATE_DISPLAY_FORMAT;
        }
        try {
            FastDateFormat dateFormat = FastDateFormat.getInstance((String)dateFormatString);
            String publishDateText = dateFormat.format(publishDate.getTime());
            dateFormat = FastDateFormat.getInstance((String)dateDisplayFormatString);
            String publishDisplayDateText = dateFormat.format(publishDate.getTime());
            this.componentProperties.put("publishDateText", publishDateText);
            this.componentProperties.put("publishDisplayDateText", publishDisplayDateText);
            this.componentProperties.attr.add("datetime", publishDateText);
        }
        catch (Exception ex) {
            LOGGER.error("PageDate: dateFormatString={},dateDisplayFormatString={},publishDate={},path={},ex.message={},ex={}", new Object[]{dateFormatString, dateDisplayFormatString, publishDate, this.getResource().getPath(), ex.getMessage(), ex});
        }
        this.componentProperties.put("componentAttributes", ComponentsUtil.buildAttributesString(this.componentProperties.attr.getData(), null));
    }
}

