/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.details;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.i18n.I18n;
import com.day.cq.tagging.Tag;
import design.aem.components.ComponentProperties;
import design.aem.models.v2.details.GenericDetails;
import design.aem.utils.components.CommonUtil;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.I18nUtil;
import design.aem.utils.components.TagUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactDetails
extends GenericDetails {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ContactDetails.class);
    static final String COMPONENT_DETAILS_NAME = "contact-details";
    static final String DEFAULT_FORMAT_TITLE = "${honorificPrefix} ${givenName} ${familyName}";
    static final String DEFAULT_FORMAT_DESCRIPTION = "${jobTitle}";
    static final String FIELD_FORMAT_TITLE = "titleFormat";
    static final String FIELD_FORMAT_DESCRIPTION = "descriptionFormat";
    static final String FIELD_FORMATTED_TITLE = "titleFormatted";
    static final String FIELD_FORMATTED_TITLE_TEXT = "titleFormattedText";
    static final String FIELD_FORMATTED_DESCRIPTION = "descriptionFormatted";
    static final String I18N_CATEGORY = "contact-detail";

    @Override
    protected void ready() {
        I18n i18n = new I18n((HttpServletRequest)this.getRequest());
        String DEFAULT_TITLE_TAG_TYPE = "div";
        Boolean DEFAULT_HIDE_DESCRIPTION = false;
        Boolean DEFAULT_SHOW_BREADCRUMB = true;
        Boolean DEFAULT_SHOW_TOOLBAR = true;
        String DEFAULT_I18N_CATEGORY = I18N_CATEGORY;
        String DEFAULT_I18N_LABEL = "variantHiddenLabel";
        String FIELD_HONOTIFIC_PREFIX = "honorificPrefix";
        String FIELD_TITLE = "title";
        String DEFAULT_TITLE = CommonUtil.getPageTitle(this.getResourcePage(), this.getResource());
        this.setComponentFields(new Object[][]{{"variant", "default"}, {"titleType", "div"}, {"title", this.getResourcePage().getProperties().get("jcr:title", (Object)this.getResourcePage().getName())}, {FIELD_FORMAT_TITLE, ""}, {"honorificPrefix", ""}, {"givenName", ""}, {"familyName", ""}, {FIELD_FORMAT_TITLE, ""}, {"jobTitle", ""}, {"employee", ""}, {"email", ""}, {"contactNumber", ""}, {FIELD_FORMAT_DESCRIPTION, ""}, {"hideDescription", DEFAULT_HIDE_DESCRIPTION}, {"cq:tags", new String[0], "data-tags", Tag.class.getCanonicalName()}, {"showBreadcrumb", DEFAULT_SHOW_BREADCRUMB}, {"showToolbar", DEFAULT_SHOW_TOOLBAR}, {"pageUrl", CommonUtil.getPageUrl(this.getResourcePage())}, {"pageTitle", DEFAULT_TITLE}, {"pageNavTitle", CommonUtil.getPageNavTitle(this.getResourcePage())}, {"variantHiddenLabel", I18nUtil.getDefaultLabelIfEmpty("", I18N_CATEGORY, "variantHiddenLabel", I18N_CATEGORY, i18n, new String[0])}});
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY, ComponentsUtil.DEFAULT_FIELDS_ANALYTICS, ComponentsUtil.DEFAULT_FIELDS_DETAILS_OPTIONS});
        String[] tags = (String[])this.componentProperties.get("cq:tags", new String[0]);
        this.componentProperties.put("category", TagUtil.getTagsAsAdmin(this.getSlingScriptHelper(), tags, this.getRequest().getLocale()));
        this.componentProperties.put("honorificPrefix", TagUtil.getTagValueAsAdmin((String)this.componentProperties.get("honorificPrefix", ""), this.getSlingScriptHelper()));
        this.componentProperties.putAll(this.processComponentFields(this.componentProperties, i18n, this.getSlingScriptHelper()), false);
        this.componentProperties.put("description", this.componentProperties.get(FIELD_FORMATTED_DESCRIPTION, ""));
        this.processCommonFields();
        if (StringUtils.isEmpty((CharSequence)((CharSequence)this.componentProperties.get(FIELD_FORMATTED_TITLE, "")))) {
            this.componentProperties.put(FIELD_FORMATTED_TITLE, this.componentProperties.get("title", ""));
            this.componentProperties.put(FIELD_FORMATTED_TITLE_TEXT, this.componentProperties.get("title", ""));
        }
    }

    @Override
    public Map<String, Object> processComponentFields(ComponentProperties componentProperties, I18n i18n, SlingScriptHelper sling) {
        HashMap<String, Object> newFields = new HashMap<String, Object>();
        try {
            String formattedTitle = ComponentsUtil.compileComponentMessage(FIELD_FORMAT_TITLE, DEFAULT_FORMAT_TITLE, componentProperties, sling);
            Document fragment = Jsoup.parse(formattedTitle);
            String formattedTitleText = fragment.text();
            newFields.put(FIELD_FORMATTED_TITLE, formattedTitle.trim());
            newFields.put(FIELD_FORMATTED_TITLE_TEXT, formattedTitleText.trim());
            newFields.put(FIELD_FORMATTED_DESCRIPTION, ComponentsUtil.compileComponentMessage(FIELD_FORMAT_DESCRIPTION, DEFAULT_FORMAT_DESCRIPTION, componentProperties, sling).trim());
        }
        catch (Exception ex) {
            LOGGER.error("Could not process component fields in {}", (Object)COMPONENT_DETAILS_NAME);
        }
        return newFields;
    }
}

