/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.layout;

import com.adobe.cq.sightly.WCMUsePojo;
import design.aem.components.ComponentProperties;
import design.aem.models.ModelProxy;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.ImagesUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;

public class ContentBlockMenu
extends ModelProxy {
    protected ComponentProperties componentProperties = null;

    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    @Override
    protected void ready() throws Exception {
        Resource menuSourcePagePathRes;
        String menuSourcePagePath;
        String DEFAULT_MENUSOURCE_PARENT = "parent";
        String DEFAULT_MENUSOURCE_PAGEPATH = "pagepath";
        String FIELD_MENUSOURCE = "menuSource";
        String FIELD_MENUSOURCEPAGEPATH = "menuSourcePagePath";
        this.setComponentFields(new Object[][]{{"variant", "default"}, {"menuSource", "parent"}, {"menuSourcePagePath", ""}});
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY});
        Map<Object, Object> contentBlockList = new LinkedHashMap();
        Resource menuSource = this.getResource().getParent();
        if (((String)this.componentProperties.get("menuSource", "parent")).equals("pagepath") && StringUtils.isNotEmpty((CharSequence)(menuSourcePagePath = (String)this.componentProperties.get("menuSourcePagePath", ""))) && (menuSourcePagePathRes = this.getResourceResolver().getResource(menuSourcePagePath)) != null) {
            menuSource = menuSourcePagePathRes;
        }
        if (menuSource != null) {
            contentBlockList = ContentBlockMenu.getContentBlockMenu(menuSource);
        }
        this.componentProperties.put("contentBlockList", contentBlockList);
        this.componentProperties.put("bgimage", (Object)ImagesUtil.getBackgroundImageRenditions(this));
    }

    private static boolean isContentBlockComponent(Node childNode) throws RepositoryException {
        return childNode.hasProperty("sling:resourceType") && childNode.getProperty("sling:resourceType").getString().endsWith("contentblock") || childNode.hasProperty("sling:resourceType") && childNode.getProperty("sling:resourceType").getString().endsWith("contentblocklock");
    }

    private static boolean isVisibleInMenu(Node childNode) throws RepositoryException {
        return !childNode.hasProperty("hideInMenu") || "true".equals(childNode.getProperty("hideInMenu").getString());
    }

    private static Map<String, String> getContentBlockMenu(Resource parSys) throws RepositoryException {
        NodeIterator nodeIterator;
        Node contentResourceNode;
        LinkedHashMap<String, String> contentMenu = new LinkedHashMap<String, String>();
        if (parSys != null && (contentResourceNode = (Node)parSys.adaptTo(Node.class)) != null && (nodeIterator = contentResourceNode.getNodes()) != null) {
            while (nodeIterator.hasNext()) {
                String componentId;
                Node childNode = nodeIterator.nextNode();
                if (childNode == null || !ContentBlockMenu.isContentBlockComponent(childNode) || !ContentBlockMenu.isVisibleInMenu(childNode)) continue;
                String childTitle = childNode.getName();
                String childName = childNode.getName();
                if (childNode.hasProperty("componentId") && StringUtils.isNotEmpty((CharSequence)(componentId = childNode.getProperty("componentId").getString()))) {
                    childName = componentId;
                }
                if (childNode.hasProperty("title") && StringUtils.isEmpty((CharSequence)(childTitle = childNode.getProperty("title").getString()))) {
                    childTitle = childName;
                }
                contentMenu.put(childName, childTitle);
            }
            return contentMenu;
        }
        return contentMenu;
    }
}

