/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.lists;

import com.adobe.cq.sightly.WCMUsePojo;
import com.adobe.granite.asset.api.AssetManager;
import com.day.cq.dam.api.Asset;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import design.aem.components.ComponentProperties;
import design.aem.models.ModelProxy;
import design.aem.models.v2.lists.List;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.ImagesUtil;
import design.aem.utils.components.TagUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetList
extends ModelProxy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AssetList.class);
    protected ComponentProperties componentProperties = null;
    private List<Map<String, Object>> listItems;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(intValues={100})
    private int limit;
    private static final String PN_SOURCE = "listFrom";
    private static final String PN_SOURCE_DEFAULT = Source.STATIC.getValue();
    private static final String PARENT_PATH = "parentPath";
    private static final String STATIC_ITEMS = "assets";
    private static final String DESCENDANT_PATH = "ancestorPath";
    private static final String PARENT_PATH_DEFAULT = "/content/dam";
    private static final String LIMIT_PROPERTY_NAME = "limit";
    private static final int LIMIT_DEFAULT = 100;
    private static final String PN_SORT_ORDER = "sortOrder";
    private static final String PN_ORDER_BY = "orderBy";
    private static final String PN_ORDER_BY_DEFAULT = "path";
    private static final String LIST_ISEMPTY = "isEmpty";
    private static final String FIELD_IMAGEURL = "imageURL";
    private static final String FIELD_RENDITIONS = "renditions";
    private static final String FIELD_TITLE_TAG_TYPE_DEFAULT = "div";
    private static final String FIELD_IMAGE_OPTION_DEFAULT = "responsive";
    private static final String ASSET_TYPE = "assetType";
    private static final String ASSET_LICENSEINFO = "\u00a9 {4} {0} {1} {2} {3}";
    private long totalMatches;
    private List.SortOrder sortOrder;

    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    @Override
    protected void ready() {
        this.setComponentFields(new Object[][]{{"variant", "default"}, {STATIC_ITEMS, new String[0]}, {DESCENDANT_PATH, PARENT_PATH_DEFAULT}, {PN_SOURCE, PN_SOURCE_DEFAULT}, {PARENT_PATH, PARENT_PATH_DEFAULT}, {PN_ORDER_BY, ""}, {LIMIT_PROPERTY_NAME, 100}, {PN_SORT_ORDER, List.SortOrder.ASC.getValue()}, {"imageOption", FIELD_IMAGE_OPTION_DEFAULT}, {"titleType", FIELD_TITLE_TAG_TYPE_DEFAULT}});
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ImagesUtil.DEFAULT_FIELDS_IMAGE_OPTIONS, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY, ComponentsUtil.DEFAULT_FIELDS_ANALYTICS});
        this.sortOrder = List.SortOrder.fromString((String)this.componentProperties.get(PN_SORT_ORDER, List.SortOrder.ASC.getValue()));
        this.limit = (Integer)this.componentProperties.get(LIMIT_PROPERTY_NAME, 100);
    }

    protected Source getListType() {
        if (this.componentProperties != null) {
            String listFromValue = (String)this.componentProperties.get(PN_SOURCE, this.getCurrentStyle().get(PN_SOURCE, (Object)""));
            return Source.fromString(listFromValue);
        }
        return Source.STATIC;
    }

    public Collection<Map<String, Object>> getListItems() {
        if (this.listItems == null) {
            Source listType = this.getListType();
            this.populateListItems(listType);
        }
        return this.listItems;
    }

    protected void populateListItems(Source listType) {
        switch (listType) {
            case STATIC: {
                this.populateStaticListItems();
                break;
            }
            case CHILDREN: {
                this.populateChildListItems();
                break;
            }
            case DESCENDANTS: {
                this.populateDescendantsListItems();
                break;
            }
            default: {
                this.listItems = new ArrayList<Map<String, Object>>();
            }
        }
        this.componentProperties.put(LIST_ISEMPTY, this.totalMatches == 0L);
    }

    private void populateChildListItems() {
        String path = (String)this.componentProperties.get(PARENT_PATH, PARENT_PATH_DEFAULT);
        this.populateChildListItems(path, true);
    }

    private void populateDescendantsListItems() {
        String path = (String)this.componentProperties.get(DESCENDANT_PATH, PARENT_PATH_DEFAULT);
        this.populateChildListItems(path, false);
    }

    private void populateChildListItems(String path, Boolean flat) {
        this.listItems = new ArrayList<Map<String, Object>>();
        HashMap<String, String> childMap = new HashMap<String, String>();
        childMap.put(PN_ORDER_BY_DEFAULT, path);
        if (flat.booleanValue()) {
            childMap.put("path.flat", "true");
        } else {
            childMap.put("path.flat", "false");
        }
        childMap.put("type", "dam:Asset");
        this.populateListItemsFromMap(childMap);
    }

    private void populateListItemsFromMap(Map<String, String> map) {
        try {
            QueryBuilder builder = (QueryBuilder)this.getResourceResolver().adaptTo(QueryBuilder.class);
            if (builder != null) {
                Session session = (Session)this.getResourceResolver().adaptTo(Session.class);
                Query query = null;
                map.put("p.limit", String.valueOf(this.limit));
                String orderBy = (String)this.componentProperties.get(PN_ORDER_BY, PN_ORDER_BY_DEFAULT);
                if (StringUtils.isNotEmpty((CharSequence)orderBy)) {
                    map.put("orderby", orderBy);
                } else {
                    map.put("orderby", PN_ORDER_BY_DEFAULT);
                }
                map.put("orderby.sort", this.sortOrder.getValue());
                PredicateGroup root = PredicateGroup.create(map);
                if (!root.isEmpty()) {
                    query = builder.createQuery(root, session);
                }
                if (query != null) {
                    this.collectSearchResults(query.getResult());
                }
            } else {
                LOGGER.error("populateListItemsFromMap: could not get query builder object, map=[{}]", map);
            }
        }
        catch (Exception ex) {
            LOGGER.error("populateListItemsFromMap: could not execute query map=[{}], ex={}", map, (Object)ex);
        }
    }

    private void populateStaticListItems() {
        this.listItems = new ArrayList<Map<String, Object>>();
        String[] items = (String[])this.componentProperties.get(STATIC_ITEMS, new String[0]);
        AssetManager assetManager = (AssetManager)this.getResourceResolver().adaptTo(AssetManager.class);
        if (assetManager != null) {
            for (String item : items) {
                ComponentProperties assetInfo;
                com.adobe.granite.asset.api.Asset asset;
                Resource assetResource = this.getResourceResolver().resolve(item);
                if (ResourceUtil.isNonExistingResource((Resource)assetResource) || (asset = assetManager.getAsset(item)) == null || (assetInfo = this.getAssetInfo(asset, assetResource, this.componentProperties, this.getSlingScriptHelper())) == null) continue;
                this.listItems.add((Map<String, Object>)((Object)assetInfo));
            }
        } else {
            LOGGER.error("ImageImpl: could not get AssetManager object");
        }
    }

    private ComponentProperties getAssetInfo(com.adobe.granite.asset.api.Asset asset, Resource assetResource, ComponentProperties componentProperties, SlingScriptHelper sling) {
        String PROPERTY_METADATA = "jcr:content/metadata";
        String PROPERTY_METADATA_DURATION = "jcr:content/metadata/xmpDM:duration";
        try {
            if (asset != null && sling != null) {
                if (!ResourceUtil.isNonExistingResource((Resource)assetResource)) {
                    Resource assetMetadataResource;
                    Resource assetMetadataDurationResource;
                    Asset assetBasic = (Asset)assetResource.adaptTo(Asset.class);
                    if (assetBasic == null) {
                        return ComponentsUtil.getNewComponentProperties(this);
                    }
                    String assetPath = assetResource.getPath();
                    String imageOption = (String)componentProperties.get("imageOption", FIELD_IMAGE_OPTION_DEFAULT);
                    String titleType = (String)componentProperties.get("titleType", FIELD_TITLE_TAG_TYPE_DEFAULT);
                    Object[][] assetField = new Object[][]{{"name", assetBasic.getName()}, {"id", assetBasic.getID(), "asset-id"}, {PN_ORDER_BY_DEFAULT, assetBasic.getPath()}, {"originalPath", assetBasic.getOriginal()}, {"mimeType", assetBasic.getMimeType(), "data-mimetype"}, {"lastModified", assetBasic.getLastModified()}, {"isSubAsset", assetBasic.isSubAsset()}, {FIELD_RENDITIONS, assetBasic.listRenditions()}, {"linkURL", ""}, {"imageOption", imageOption}, {"titleType", titleType}, {"href", assetPath, "data-href"}};
                    ComponentProperties assetProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object)asset, (Boolean)false, (Object[][][])new Object[][][]{assetField, ComponentsUtil.DEFAULT_FIELDS_ASSET});
                    String assetType = (String)assetProperties.get("dc:format", "");
                    boolean checkDuration = false;
                    boolean getRenditions = false;
                    if (assetType.startsWith("video/")) {
                        assetProperties.put(ASSET_TYPE, "video");
                        checkDuration = true;
                        getRenditions = true;
                    } else if (assetType.startsWith("audio/") || assetType.startsWith("application/")) {
                        assetProperties.put(ASSET_TYPE, "audio");
                        checkDuration = true;
                    } else if (assetType.startsWith("image/")) {
                        assetProperties.put(ASSET_TYPE, "image");
                        getRenditions = true;
                    } else {
                        assetProperties.put(ASSET_TYPE, "other");
                        getRenditions = true;
                    }
                    if (checkDuration && (assetMetadataDurationResource = assetResource.getChild("jcr:content/metadata/xmpDM:duration")) != null) {
                        ValueMap assetMetadataDurationValueMap = assetMetadataDurationResource.getValueMap();
                        assetProperties.put("duration", ImagesUtil.getAssetDuration(assetMetadataDurationValueMap).toString());
                    }
                    if ((assetMetadataResource = assetResource.getChild("jcr:content/metadata")) != null) {
                        ValueMap assetMetadata = assetMetadataResource.getValueMap();
                        assetProperties.put("assetTags", TagUtil.getTagsAsAdmin(sling, (String[])assetMetadata.get("cq:tags", (Object)new String[0]), this.getRequest().getLocale()));
                        String assetUsageTerms = (String)assetMetadata.get("xmpRights:UsageTerms", (Object)"");
                        assetProperties.put("assetUsageTerms", assetUsageTerms);
                    }
                    String licenseInfo = ImagesUtil.getAssetCopyrightInfo(assetBasic, ASSET_LICENSEINFO);
                    assetProperties.put("licenseInfo", licenseInfo);
                    assetProperties.attr.add("data-license", licenseInfo);
                    Map<Object, Object> responsiveImageSet = new LinkedHashMap();
                    if (getRenditions) {
                        if (assetPath.endsWith(".svg") || assetPath.endsWith(".gif")) {
                            assetProperties.put(FIELD_IMAGEURL, assetPath);
                            assetProperties.put("imageOption", "simple");
                        } else {
                            responsiveImageSet = ImagesUtil.getImageSetForImageOptions(imageOption, asset, componentProperties, assetResource, this.getResourceResolver(), sling);
                        }
                    }
                    assetProperties.put(FIELD_RENDITIONS, responsiveImageSet);
                    if (!responsiveImageSet.values().isEmpty()) {
                        assetProperties.put(FIELD_IMAGEURL, responsiveImageSet.values().toArray()[responsiveImageSet.values().size() - 1]);
                    }
                    assetProperties.put("componentAttributes", ComponentsUtil.buildAttributesString(assetProperties.attr.getData(), null));
                    return assetProperties;
                }
            } else {
                LOGGER.error("getAssetInfo: could not get asset info {}", (Object)asset);
            }
        }
        catch (Exception ex) {
            LOGGER.error("getAssetInfo: error processing asset asset={}, ex={}", (Object)asset, (Object)ex);
        }
        return null;
    }

    private void collectSearchResults(SearchResult result) throws RepositoryException {
        HashMap<String, Object> resultInfo = new HashMap<String, Object>();
        resultInfo.put("executionTime", result.getExecutionTime());
        resultInfo.put("result", result);
        this.totalMatches = result.getTotalMatches();
        List resultPages = result.getResultPages();
        long hitsPerPage = result.getHitsPerPage();
        long totalPages = result.getResultPages().size();
        long pageStart = result.getStartIndex();
        long currentPage = pageStart / hitsPerPage + 1L;
        resultInfo.put("hitsPerPage", hitsPerPage);
        resultInfo.put("currentPage", currentPage);
        resultInfo.put("totalMatches", this.totalMatches);
        resultInfo.put("resultPages", resultPages);
        resultInfo.put("totalPages", totalPages);
        this.componentProperties.put("resultInfo", resultInfo);
        AssetManager assetManager = (AssetManager)this.getResourceResolver().adaptTo(AssetManager.class);
        if (assetManager != null) {
            for (Hit hit : result.getHits()) {
                HashMap<String, Hit> item = new HashMap<String, Hit>();
                item.put("hit", hit);
                Resource itemResource = hit.getResource();
                com.adobe.granite.asset.api.Asset asset = assetManager.getAsset(itemResource.getPath());
                if (asset != null) {
                    ComponentProperties assetInfo = this.getAssetInfo(asset, itemResource, this.componentProperties, this.getSlingScriptHelper());
                    if (assetInfo == null) continue;
                    this.listItems.add((Map<String, Object>)((Object)assetInfo));
                    continue;
                }
                LOGGER.error("populateStaticListItems: could not find asset {}", item);
            }
        } else {
            LOGGER.error("ImageImpl: could not get AssetManager object");
        }
    }

    protected static enum Source {
        CHILDREN("children"),
        STATIC("static"),
        DESCENDANTS("descendants"),
        EMPTY("");

        private String value;

        public String getValue() {
            return this.value;
        }

        private Source(String value) {
            this.value = value;
        }

        public static Source fromString(String value) {
            for (Source s : Source.values()) {
                if (!StringUtils.equals((CharSequence)value, (CharSequence)s.value)) continue;
                return s;
            }
            return null;
        }
    }
}

