/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.lists;

import com.adobe.granite.asset.api.Asset;
import com.adobe.granite.asset.api.AssetManager;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.i18n.I18n;
import design.aem.components.ComponentProperties;
import design.aem.models.v2.lists.List;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.I18nUtil;
import design.aem.utils.components.ImagesUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationList
extends List {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LocationList.class);
    private final String DEFAULT_I18N_CATEGORY = "newslist";

    @Override
    protected void ready() {
        I18n i18n = new I18n((HttpServletRequest)this.getRequest());
        this.detailsNameSuffix = new String[]{"location-details", "generic-details"};
        this.loadConfig();
        ComponentProperties componentProperties = this.getComponentProperties();
        if (componentProperties != null) {
            componentProperties.put("listItemLinkText", I18nUtil.getDefaultLabelIfEmpty("", "newslist", "listItemLinkText", "newslist", i18n, new String[0]));
            componentProperties.put("listItemLinkTitle", I18nUtil.getDefaultLabelIfEmpty("", "newslist", "listItemLinkTitle", "newslist", i18n, new String[0]));
            String thumbnailType = (String)this.getProperties().get("mapRenderingOption", (Object)"");
            String mapImagePath = ImagesUtil.getResourceImagePath(this.getResource(), "map");
            if (StringUtils.isNotEmpty((CharSequence)mapImagePath)) {
                componentProperties.put("mapPath", mapImagePath);
                componentProperties.attr.add("data-map-path", mapImagePath);
                AssetManager assetManager = (AssetManager)this.getResourceResolver().adaptTo(AssetManager.class);
                if (assetManager != null) {
                    Asset asset = assetManager.getAsset(mapImagePath);
                    String imageLength = ImagesUtil.getMetadataStringForKey(asset, "tiff:ImageLength");
                    String imageWidth = ImagesUtil.getMetadataStringForKey(asset, "tiff:ImageWidth");
                    componentProperties.attr.add("data-map-image-y", imageLength);
                    componentProperties.attr.add("data-map-image-x", imageWidth);
                    componentProperties.attr.add("style", "height:" + imageLength + "px;");
                    componentProperties.attr.add("style", "width:" + imageWidth + "px;");
                } else {
                    LOGGER.error("ImageImpl: could not get AssetManager object");
                }
            }
            componentProperties.attr.add("wcmmode", this.getWcmMode().toString().toLowerCase());
            String googleApiKey = ComponentsUtil.getCloudConfigProperty((InheritanceValueMap)this.getPageProperties(), "googlemap", "googleApiKey", this.getSlingScriptHelper());
            componentProperties.attr.add("data-map-apikey", googleApiKey);
            componentProperties.put("componentAttributes", ComponentsUtil.buildAttributesString(componentProperties.attr.getData(), null));
        }
    }
}

