/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.lists;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Page;
import design.aem.components.ComponentProperties;
import design.aem.models.ModelProxy;
import design.aem.utils.components.CommonUtil;
import design.aem.utils.components.ComponentDetailsUtil;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.I18nUtil;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NavList
extends ModelProxy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(NavList.class);
    protected ComponentProperties componentProperties = null;

    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    @Override
    protected void ready() {
        I18n i18n = new I18n((HttpServletRequest)this.getRequest());
        String DEFAULT_LISTFROM = "children";
        String LISTFROM_CHILDREN = "children";
        String DEFAULT_VARIANT = "default";
        int DEFAULT_DEPTH_FROM_ROOT = 2;
        this.setComponentFields(new Object[][]{{"pages", new String[0]}, {"variant", "default"}, {"depthFromRoot", 2}, {"listFrom", "children"}, {"currentPage", this.getCurrentPage()}, {"menuTitle", i18n.get("menuTitle", "navlist")}, {"parentPage", this.getPrimaryPath(this.getRequest())}, {"linkTitlePrefix", i18n.get("linkTitlePrefix", "navlist")}, {"cancelInheritParent", false}});
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY, ComponentsUtil.DEFAULT_FIELDS_ANALYTICS});
        String[] supportedDetails = CommonUtil.DEFAULT_LIST_DETAILS_SUFFIX;
        String[] supportedRoots = CommonUtil.DEFAULT_LIST_PAGE_CONTENT;
        int depthFromRoot = (Integer)this.componentProperties.get("depthFromRoot", 2);
        if (depthFromRoot > 5) {
            depthFromRoot = 5;
        } else if (depthFromRoot < 0) {
            depthFromRoot = 0;
        }
        List<ComponentProperties> pagesInfo = null;
        if (((String)this.componentProperties.get("listFrom", "children")).equals("children")) {
            Page parentPage = this.getPageManager().getPage((String)this.componentProperties.get("parentPage", ""));
            if (parentPage != null) {
                pagesInfo = ComponentDetailsUtil.getPageListInfo(ComponentsUtil.getContextObjects(this), this.getPageManager(), this.getResourceResolver(), (Iterator<Page>)parentPage.listChildren(), supportedDetails, supportedRoots, (Integer)depthFromRoot, (Boolean)true);
            }
        } else {
            String[] paths = (String[])this.componentProperties.get("pages", new String[0]);
            if (paths.length != 0) {
                pagesInfo = ComponentDetailsUtil.getPageListInfo(ComponentsUtil.getContextObjects(this), this.getPageManager(), this.getResourceResolver(), paths, supportedDetails, supportedRoots, (Integer)depthFromRoot, (Boolean)true);
            }
        }
        this.componentProperties.put("menuItems", pagesInfo);
        this.componentProperties.put("inheritedResource", ComponentsUtil.findInheritedResource(this.getResourcePage(), this.getComponentContext()));
        this.componentProperties.put("parentnotfound", I18nUtil.getDefaultLabelIfEmpty("", "inherit", "parentnotfound", "inherit", i18n, new String[0]));
    }

    private String getPrimaryPath(SlingHttpServletRequest slingRequest) {
        String requestPath = slingRequest.getRequestPathInfo().getResourcePath();
        if (requestPath.contains("jcr:content")) {
            return requestPath.substring(0, requestPath.indexOf("jcr:content") - 1);
        }
        return "";
    }
}

