/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.lists;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.dam.api.Asset;
import com.day.cq.i18n.I18n;
import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateConverter;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.facets.Bucket;
import com.day.cq.search.facets.Facet;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import design.aem.CustomSearchResult;
import design.aem.components.ComponentProperties;
import design.aem.models.ModelProxy;
import design.aem.utils.components.CommonUtil;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.I18nUtil;
import design.aem.utils.components.ImagesUtil;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchList
extends ModelProxy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SearchList.class);
    protected ComponentProperties componentProperties = null;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(intValues={0})
    protected int listSplitEvery;
    private static final String ASSET_LICENSEINFO = "\u00a9 {4} {0} {1} {2} {3}";
    private static final String RESULT_STATIC_TEXT = "statisticsText";

    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    @Override
    protected void ready() {
        I18n i18n = new I18n((HttpServletRequest)this.getRequest());
        String DEFAULT_I18N_CATEGORY = "searchlist";
        String DEFAULT_ARIA_ROLE = "search";
        ArrayList<CustomSearchResult> results = new ArrayList<CustomSearchResult>();
        Query query = this.composeQueryBuilder(this.getRequest(), this.getResourceResolver());
        SearchResult result = null;
        String queryText = "";
        if (query != null) {
            result = query.getResult();
            Predicate fulltextPredicate = query.getPredicates().getByName("fulltext");
            if (fulltextPredicate != null) {
                queryText = fulltextPredicate.get("fulltext", "");
            }
        }
        String escapedQuery = this.getXSSAPI().encodeForHTML(queryText);
        String escapedQueryForAttr = this.getXSSAPI().encodeForHTMLAttr(queryText);
        String escapedQueryForHref = this.getXSSAPI().getValidHref(queryText);
        this.setComponentFields(new Object[][]{{"variant", "default"}, {"emptyQueryText", I18nUtil.getDefaultLabelIfEmpty("emptyQueryText", "searchlist", "Invalid query given!", i18n, new String[0])}, {"searchButtonText", I18nUtil.getDefaultLabelIfEmpty("searchButtonText", "searchlist", "Search", i18n, new String[0])}, {"searchQueryInformation", I18nUtil.getDefaultLabelIfEmpty("searchQueryInformation", "searchlist", "Search query information", i18n, new String[0])}, {RESULT_STATIC_TEXT, I18nUtil.getDefaultLabelIfEmpty(RESULT_STATIC_TEXT, "searchlist", "<div class='content'> <h2>Results {0} for <b>{1}</b></h2></div>", i18n, new String[0])}, {"noResultsText", I18nUtil.getDefaultLabelIfEmpty("noResultsText", "searchlist", "Your search - <b>{0}</b> - did not match any documents.", i18n, new String[0])}, {"spellcheckText", I18nUtil.getDefaultLabelIfEmpty("spellcheckText", "searchlist", "Did you mean:", i18n, new String[0])}, {"similarPagesText", I18nUtil.getDefaultLabelIfEmpty("similarPagesText", "searchlist", "Similar Pages", i18n, new String[0])}, {"relatedSearchesText", I18nUtil.getDefaultLabelIfEmpty("relatedSearchesText", "searchlist", "Related searches:", i18n, new String[0])}, {"searchTrendsText", I18nUtil.getDefaultLabelIfEmpty("searchTrendsText", "searchlist", "Search Trends", i18n, new String[0])}, {"resultPagesText", I18nUtil.getDefaultLabelIfEmpty("resultPagesText", "searchlist", "Results", i18n, new String[0])}, {"previousText", I18nUtil.getDefaultLabelIfEmpty("previousText", "searchlist", "Previous", i18n, new String[0])}, {"nextText", I18nUtil.getDefaultLabelIfEmpty("nextText", "searchlist", "Next", i18n, new String[0])}, {"assetActionText", I18nUtil.getDefaultLabelIfEmpty("assetActionText", "searchlist", "Download", i18n, new String[0])}, {"pageActionText", I18nUtil.getDefaultLabelIfEmpty("pageActionText", "searchlist", "Read More", i18n, new String[0])}, {"otherActionText", I18nUtil.getDefaultLabelIfEmpty("otherActionText", "searchlist", "Find Out More", i18n, new String[0])}, {"componentPath", this.getResource().getResourceType()}, {"escapedQuery", escapedQuery}, {"escapedQueryForAttr", escapedQueryForAttr}, {"escapedQueryForHref", escapedQueryForHref}, {"printStructure", true}, {"listTag", "ul"}, {"ariaRole", "search", "role"}});
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY, ComponentsUtil.DEFAULT_FIELDS_DETAILS_OPTIONS});
        String pageUrl = this.getCurrentPage().getPath().concat(".html");
        this.componentProperties.putAll(ImagesUtil.getAssetInfo(this.getResourceResolver(), ImagesUtil.getResourceImagePath(this.getResource(), "bgimage"), "pageBackgroundImage"));
        this.componentProperties.attr.add("data-component-id", (String)this.componentProperties.get("componentId", this.getResource().getName()));
        if (result != null) {
            if (!StringUtils.isEmpty((CharSequence)((CharSequence)this.componentProperties.get(RESULT_STATIC_TEXT, "")))) {
                this.componentProperties.put(RESULT_STATIC_TEXT, MessageFormat.format((String)this.componentProperties.get(RESULT_STATIC_TEXT, ""), result.getTotalMatches(), escapedQuery));
            }
            this.normaliseContentTree(results, this.getSlingScriptHelper(), this.getRequest(), result);
            if (result.getResultPages().size() > 0 && result.getNextPage() != null) {
                boolean hasPages = false;
                if (result.getNextPage() != null) {
                    hasPages = true;
                    this.componentProperties.attr.add("data-total-pages", String.valueOf(result.getResultPages().size() - 1));
                    this.componentProperties.attr.add("data-content-target", "#".concat((String)this.componentProperties.get("componentId", "")));
                    this.componentProperties.attr.add("data-page-offset", String.valueOf(result.getHits().size()));
                    this.componentProperties.attr.add("data-showing-text", (String)this.componentProperties.get(RESULT_STATIC_TEXT, ""));
                }
                this.componentProperties.attr.add("data-content-url", pageUrl.concat("?q=").concat(queryText));
                this.componentProperties.attr.add("data-content-start", "start");
                this.componentProperties.attr.add("data-has-pages", String.valueOf(hasPages));
            }
            this.componentProperties.put("facetsTitle", i18n.get("Tags"));
            try {
                if (result.getFacets() != null && result.getFacets().get("tags") != null && ((Facet)result.getFacets().get("tags")).getContainsHit()) {
                    TagManager tagManager = (TagManager)this.getResourceResolver().adaptTo(TagManager.class);
                    if (tagManager != null) {
                        ArrayList bucketsInfo = new ArrayList();
                        for (Bucket bucket : ((Facet)result.getFacets().get("tags")).getBuckets()) {
                            HashMap<String, Serializable> bucketInfo = new HashMap<String, Serializable>();
                            bucketInfo.put("bucket", bucketInfo);
                            Tag tag = tagManager.resolve(bucket.getValue());
                            if (tag != null) {
                                bucketInfo.put("tag", bucketInfo);
                            }
                            if (Arrays.asList(this.getRequest().getParameterValues("tag")).contains(bucket.getValue())) {
                                bucketInfo.put("filter", Boolean.valueOf(true));
                            }
                            bucketsInfo.add(bucketInfo);
                        }
                        this.componentProperties.put("bucketsInfo", bucketsInfo);
                    } else {
                        LOGGER.error("SearchList: could not get TagManager object");
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("SearchList: error as a result of trying to access result set!");
                LOGGER.error(ex.getMessage());
            }
            this.listSplitEvery = 0;
            if (this.listSplitEvery > 0) {
                ArrayList<Integer> listSplitAtItem = new ArrayList<Integer>();
                for (int i = 0; i < results.size(); ++i) {
                    if ((i + 1) % this.listSplitEvery != 0) continue;
                    listSplitAtItem.add(i);
                }
                this.componentProperties.put("listSplitAtItem", listSplitAtItem);
            }
        } else {
            this.componentProperties.put("isEmpty", true);
        }
        this.componentProperties.put("results", results);
        this.componentProperties.put("includePagination", false);
        this.componentProperties.put("currentPageUrl", this.getCurrentPage().getPath().concat(".html"));
        this.componentProperties.put("listItemLinkText", I18nUtil.getDefaultLabelIfEmpty("", "searchlist", "listItemLinkText", "searchlist", i18n, new String[0]));
        this.componentProperties.put("listItemLinkTitle", I18nUtil.getDefaultLabelIfEmpty("", "searchlist", "listItemLinkTitle", "searchlist", i18n, new String[0]));
        this.componentProperties.put("componentAttributes", ComponentsUtil.buildAttributesString(this.componentProperties.attr.getData(), null));
    }

    public Query composeQueryBuilder(SlingHttpServletRequest slingRequest, ResourceResolver resourceResolver) {
        Query query;
        block6: {
            query = null;
            String queryFormat = "UTF-8";
            if (slingRequest.getRequestParameter("q") != null) {
                RequestParameter queryParam = slingRequest.getRequestParameter("q");
                if (queryParam != null) {
                    String escapedQuery = queryParam.toString();
                    try {
                        String unescapedQuery = URLDecoder.decode(escapedQuery, "UTF-8");
                        QueryBuilder queryBuilder = (QueryBuilder)resourceResolver.adaptTo(QueryBuilder.class);
                        if (queryBuilder != null) {
                            Properties props = new Properties();
                            props.load(new ByteArrayInputStream(unescapedQuery.getBytes()));
                            PredicateGroup predicateGroup = PredicateConverter.createPredicates((Map)props);
                            Session jcrSession = (Session)slingRequest.getResourceResolver().adaptTo(Session.class);
                            query = queryBuilder.createQuery(predicateGroup, jcrSession);
                            break block6;
                        }
                        LOGGER.error("composeQueryBuilder: could not get QueryBuilder object");
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error using QueryBuilder with query [{}]. {}", (Object)escapedQuery, (Object)ex);
                    }
                } else {
                    LOGGER.error("composeQueryBuilder: param q is not passed");
                }
            }
        }
        return query;
    }

    public void normaliseContentTree(List<CustomSearchResult> searchResults, SlingScriptHelper sling, SlingHttpServletRequest slingRequest, SearchResult result) {
        try {
            if (!result.getHits().isEmpty()) {
                for (Hit h : result.getHits()) {
                    CustomSearchResult newResult = new CustomSearchResult(h.getPath());
                    String jcrPrimaryType = h.getProperties().get((Object)"jcr:primaryType").toString();
                    newResult.setTitle(h.getTitle());
                    if (h.getProperties().get((Object)"subtitle") != null) {
                        newResult.setSubTitle(h.getProperties().get((Object)"subtitle").toString());
                    }
                    if (jcrPrimaryType.equals("cq:PageContent")) {
                        newResult.setPathUrl(h.getPath().concat(".html"));
                        newResult.setExcerpt(h.getExcerpt());
                        Resource hitResource = h.getResource();
                        if (hitResource != null) {
                            ResourceResolver resourceResolver = slingRequest.getResourceResolver();
                            if (hitResource != null && !ResourceUtil.isNonExistingResource((Resource)hitResource)) {
                                Page hitPage = (Page)hitResource.adaptTo(Page.class);
                                String detailsNodePath = CommonUtil.findComponentInPage(hitPage, CommonUtil.DEFAULT_LIST_DETAILS_SUFFIX);
                                Resource detailsResource = this.getResourceResolver().resolve(detailsNodePath);
                                if (!ResourceUtil.isNonExistingResource((Resource)detailsResource)) {
                                    String detailsPath = detailsResource.getPath();
                                    newResult.setDetailsPath(detailsPath);
                                    newResult.setIsPage(true);
                                    String thumbnailImagePath = ImagesUtil.getResourceImagePath(detailsResource, "thumbnail");
                                    String backgroundImagePath = ImagesUtil.getResourceImagePath(detailsResource, "bgimage");
                                    if (thumbnailImagePath != null) {
                                        newResult.setThumbnailUrl(thumbnailImagePath);
                                    } else if (backgroundImagePath != null) {
                                        newResult.setThumbnailUrl(backgroundImagePath);
                                    } else {
                                        newResult.setThumbnailUrl("/etc.clientlibs/settings/wcm/designs/aemdesign/clientlibs-theme/resources/blank.png");
                                    }
                                }
                            }
                            newResult.setExcerpt((String)h.getProperties().get("jcr:description", (Object)h.getExcerpt()));
                        }
                    }
                    if (jcrPrimaryType.equals("dam:AssetContent")) {
                        newResult.setExcerpt(h.getExcerpt());
                        newResult.setPathUrl(h.getPath());
                        newResult.setIsAsset(true);
                        Resource assetResource = h.getResource();
                        Asset assetBasic = (Asset)assetResource.adaptTo(Asset.class);
                        if (assetBasic != null) {
                            String excerpt;
                            newResult.setThumbnailUrl(assetBasic.getPath());
                            String licenseInfo = ImagesUtil.getAssetCopyrightInfo(assetBasic, ASSET_LICENSEINFO);
                            if (StringUtils.isNotEmpty((CharSequence)licenseInfo)) {
                                newResult.setSubTitle(licenseInfo);
                            }
                            if (assetBasic != null) {
                                newResult.setTitle(assetBasic.getMetadataValue("dc:title"));
                            }
                            if ((excerpt = h.getExcerpt()).equals(h.getPath()) && assetBasic != null) {
                                newResult.setExcerpt(assetBasic.getMetadataValue("dc:description"));
                            }
                        } else {
                            LOGGER.error("normaliseContentTree: could not get asset from assetResource={}", (Object)assetResource);
                        }
                    }
                    searchResults.add(newResult);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Repository exception thrown: ex={}", (Throwable)ex);
        }
    }

    private String getPathFromImageResource(ResourceResolver resourceResolver, String path) {
        ValueMap valueMap;
        Resource image;
        String imagePath = null;
        if (resourceResolver != null && (image = resourceResolver.resolve(path)) != null && !ResourceUtil.isNonExistingResource((Resource)image) && (valueMap = (ValueMap)image.adaptTo(ValueMap.class)) != null && valueMap.containsKey((Object)"fileReference")) {
            imagePath = (String)valueMap.get("fileReference", String.class);
        }
        return imagePath;
    }
}

