/*
 * Decompiled with CFR 0.152.
 */
package design.aem.utils;

import com.adobe.granite.security.user.util.AuthorizableUtil;
import com.day.cq.replication.ReplicationActionType;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.ResourceResolver;

public final class UserManagementUtil {
    public static final String PATH_PROFILE = "./profile";
    public static final String PROPERTY_PROFILE_EMAIL = "./profile/email";
    public static final String PROPERTY_PROFILE_GROUP_NAME = "./profile/givenName";
    public static final String PROPERTY_PROFILE_USER_GIVEN_NAME = "./profile/givenName";
    public static final String PROPERTY_PROFILE_USER_FAMILY_NAME = "./profile/familyName";
    public static final String PROPERTY_PROFILE_ABOUT = "./profile/aboutMe";

    private UserManagementUtil() {
    }

    public static UserManager getUserManager(Session session) throws RepositoryException {
        if (session == null) {
            throw new NullPointerException("session == null");
        }
        return ((JackrabbitSession)session).getUserManager();
    }

    public static User getCurrentUser(Session session) throws RepositoryException {
        return UserManagementUtil.getUser(session, session.getUserID());
    }

    public static User getCurrentUser(ResourceResolver resourceResolver) throws RepositoryException {
        return UserManagementUtil.getUser((Session)resourceResolver.adaptTo(Session.class), resourceResolver.getUserID());
    }

    public static Authorizable getAuthorizable(Session session, String authorizableId) throws RepositoryException {
        return UserManagementUtil.getUserManager(session).getAuthorizable(authorizableId);
    }

    public static User getUser(Session session, String userId) throws RepositoryException {
        Authorizable authorizable = UserManagementUtil.getAuthorizable(session, userId);
        if (authorizable != null && !(authorizable instanceof User)) {
            throw new RepositoryException("Expected User: " + userId);
        }
        return (User)authorizable;
    }

    public static Group getGroup(Session session, String groupId) throws RepositoryException {
        Authorizable authorizable = UserManagementUtil.getAuthorizable(session, groupId);
        if (authorizable != null && !(authorizable instanceof Group)) {
            throw new RepositoryException("Expected Group: " + groupId);
        }
        return (Group)authorizable;
    }

    public static String getDisplayName(ResourceResolver resourceResolver, String authorizableId) {
        return AuthorizableUtil.getFormattedName((ResourceResolver)resourceResolver, (String)authorizableId);
    }

    public static boolean isActive(Session session, Authorizable authorizable) throws RepositoryException {
        String lastReplicationActionValue;
        User user;
        if (session == null) {
            throw new NullPointerException("session == null");
        }
        if (authorizable == null) {
            return false;
        }
        if (authorizable instanceof User && (user = (User)authorizable).isDisabled()) {
            return false;
        }
        Node userNode = session.getNode(authorizable.getPath());
        if (userNode.hasProperty("cq:lastReplicationAction") && (lastReplicationActionValue = userNode.getProperty("cq:lastReplicationAction").getString()) != null) {
            return !ReplicationActionType.DEACTIVATE.getName().equals(lastReplicationActionValue);
        }
        return true;
    }

    public static String getEmail(Authorizable authorizable) throws RepositoryException {
        if (authorizable == null) {
            throw new NullPointerException("authorizable == null");
        }
        String email = null;
        Value value = UserManagementUtil.getSingleValuedProperty(authorizable, PROPERTY_PROFILE_EMAIL);
        if (value != null) {
            email = value.getString();
        }
        if (email == null) {
            email = "";
        }
        return email;
    }

    public static String getNameAndEmail(ResourceResolver resourceResolver, Authorizable authorizable) throws RepositoryException {
        String email = UserManagementUtil.getEmail(authorizable);
        if (StringUtils.isNotEmpty((CharSequence)email)) {
            return "\"" + UserManagementUtil.getDisplayName(resourceResolver, authorizable.getID()) + "\" <" + email + ">";
        }
        return null;
    }

    public static void disableUser(User user) throws RepositoryException {
        UserManagementUtil.disableUser(user, "");
    }

    public static void disableUser(User user, String reason) throws RepositoryException {
        if (user == null || reason == null) {
            throw new NullPointerException("user == null or reason == null");
        }
        user.disable(reason);
    }

    public static void enableUser(User user) throws RepositoryException {
        if (user == null) {
            throw new NullPointerException("user == null");
        }
        user.disable(null);
    }

    public static Value getSingleValuedProperty(Authorizable authorizable, String property) throws RepositoryException {
        if (authorizable == null || property == null) {
            throw new NullPointerException("user == null or property == null");
        }
        Value[] values = authorizable.getProperty(property);
        if (values != null && values.length == 1) {
            return values[0];
        }
        return null;
    }

    public static String getSingleValuedPropertyString(Authorizable authorizable, String property) throws RepositoryException {
        Value value = UserManagementUtil.getSingleValuedProperty(authorizable, property);
        if (value != null) {
            return value.getString();
        }
        return null;
    }

    public static Collection<Authorizable> provideAuthorizablesHavingEmail(Authorizable rootAuthorizable) throws RepositoryException {
        LinkedHashSet<Authorizable> authorizables = new LinkedHashSet<Authorizable>();
        if (StringUtils.isNotEmpty((CharSequence)UserManagementUtil.getEmail(rootAuthorizable))) {
            authorizables.add(rootAuthorizable);
        }
        if (rootAuthorizable.isGroup()) {
            Iterator membersIterator = ((Group)rootAuthorizable).getMembers();
            while (membersIterator.hasNext()) {
                Authorizable member = (Authorizable)membersIterator.next();
                if (!(member instanceof User) || !StringUtils.isNotEmpty((CharSequence)UserManagementUtil.getEmail(member))) continue;
                authorizables.add(member);
            }
        }
        return authorizables;
    }
}

