/*
 * Decompiled with CFR 0.152.
 */
package design.aem.utils.components;

import com.adobe.cq.sightly.WCMUsePojo;
import com.adobe.granite.asset.api.Asset;
import com.adobe.granite.ui.components.AttrBuilder;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.ComponentManager;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import com.google.common.base.Throwables;
import design.aem.components.ComponentField;
import design.aem.components.ComponentProperties;
import design.aem.models.GenericModel;
import design.aem.services.ContentAccess;
import design.aem.utils.components.CommonUtil;
import design.aem.utils.components.ResolverUtil;
import design.aem.utils.components.TagUtil;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.jcr.Node;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentsUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger(ComponentsUtil.class);
    public static final String DEFAULT_PATH_TAGS = "/content/cq:tags";
    public static final String FIELD_VARIANT = "variant";
    public static final String FIELD_VARIANT_LEGACY = "legacyVariant";
    public static final String DEFAULT_VARIANT = "default";
    public static final String DEFAULT_VARIANT_TEMPLATE = "variant.default.html";
    public static final String DEFAULT_BADGE = "default";
    public static final String DEFAULT_ARIA_ROLE_ATTRIBUTE = "role";
    public static final String FIELD_REDIRECT_TARGET = "redirectTarget";
    public static final String DETAILS_MENU_COLOR = "menuColor";
    public static final String DETAILS_MENU_ICONSHOW = "menuIconShow";
    public static final String DETAILS_MENU_ICON = "menuIcon";
    public static final String DETAILS_MENU_ACCESS_KEY = "menuAccesskey";
    public static final String DETAILS_TAB_ICONSHOW = "tabIconShow";
    public static final String DETAILS_TAB_ICON = "tabIcon";
    public static final String DETAILS_TITLE_ICONSHOW = "titleIconShow";
    public static final String DETAILS_TITLE_ICON = "titleIcon";
    public static final String DETAILS_OVERLAY_ICONSHOW = "badgeOverlayIconShow";
    public static final String DETAILS_OVERLAY_ICON = "badgeOverlayIcon";
    public static final String DETAILS_CARD_STYLE = "cardStyle";
    public static final String DETAILS_CARD_ICONSHOW = "cardIconShow";
    public static final String DETAILS_CARD_ICON = "cardIcon";
    public static final String DETAILS_CARD_ADDITIONAL = "cardAdditional";
    public static final String DETAILS_LINK_TARGET = "badgeLinkTarget";
    public static final String DETAILS_LINK_TEXT = "badgeLinkText";
    public static final String DETAILS_LINK_TITLE = "badgeLinkTitle";
    public static final String DETAILS_LINK_STYLE = "badgeLinkStyle";
    public static final String DETAILS_LINK_FORMATTED = "badgeLinkFormatted";
    public static final String DETAILS_TITLE_TRIM = "badgeTitleTrim";
    public static final String DETAILS_TITLE_TRIM_LENGTH_MAX = "badgeTitleTrimLengthMax";
    public static final int DETAILS_TITLE_TRIM_LENGTH_MAX_DEFAULT = 20;
    public static final String DETAILS_TITLE_TRIM_LENGTH_MAX_SUFFIX = "badgeTitleTrimLengthMaxSuffix";
    public static final String DETAILS_TITLE_TRIM_LENGTH_MAX_SUFFIX_DEFAULT = "...";
    public static final String DETAILS_SUMMARY_TRIM = "badgeSummaryTrim";
    public static final String DETAILS_SUMMARY_TRIM_LENGTH_MAX = "badgeSummaryLengthMax";
    public static final int DETAILS_SUMMARY_TRIM_LENGTH_MAX_DEFAULT = 20;
    public static final String DETAILS_SUMMARY_TRIM_LENGTH_MAX_SUFFIX = "badgeSummaryLengthMaxSuffix";
    public static final String DETAILS_SUMMARY_TRIM_LENGTH_MAX_SUFFIX_DEFAULT = "...";
    public static final String DETAILS_THUMBNAIL_WIDTH = "badgeThumbnailWidth";
    public static final String DETAILS_THUMBNAIL_HEIGHT = "badgeThumbnailHeight";
    public static final String DETAILS_THUMBNAIL_TYPE = "badgeThumbnailType";
    public static final String DETAILS_TITLE_TAG_TYPE = "badgeTitleType";
    public static final String DETAILS_THUMBNAIL_ID = "badgeThumbnailId";
    public static final String DETAILS_THUMBNAIL_LICENSE_INFO = "badgeThumbnailLicenseInfo";
    public static final String DETAILS_THUMBNAIL = "badgeThumbnail";
    public static final String DETAILS_BADGE_DESCRIPTION = "badgeDescription";
    public static final String DETAILS_BADGE_TITLE = "badgeTitle";
    public static final String DETAILS_BADGE_CLASS_ICON = "badgeClassIconAttr";
    public static final String DETAILS_BADGE_CLASS = "badgeClassAttr";
    public static final String DETAILS_BADGE_IMAGE_ATTR = "badgeImageAttr";
    public static final String DETAILS_BADGE_LINK_ATTR = "badgeLinkAttr";
    public static final String DETAILS_BADGE_FIELDS_TEMPLATE = "badgeFieldsTemplate";
    public static final String DETAILS_BADGE_FIELDS = "badgeFields";
    public static final String DETAILS_BADGE_TEMPLATE = "badgeTemplate";
    public static final String DETAILS_BADGE_CUSTOM = "badgeCustom";
    public static final String FIELD_VARIANT_FIELDS = "variantFields";
    public static final String FIELD_VARIANT_FIELDS_TEMPLATE = "variantFieldsTemplate";
    public static final String FIELD_TAG_TEMPLATE_CONFIG_TEMPLATES = "templates";
    public static final String FIELD_TAG_TEMPLATE_CONFIG_FIELDS = "fields";
    public static final String FIELD_TAG_TEMPLATE_CONFIG_VALUE = "value";
    public static final String FIELD_TAG_TEMPLATE_CONFIG_VALUEALT = "valuealt";
    public static final String DETAILS_BADGE_ANALYTICS_EVENT_TYPE = "badgeAnalyticsEventType";
    public static final String DETAILS_BADGE_ANALYTICS_TRACK = "badgeAnalyticsTrack";
    public static final String DETAILS_BADGE_ANALYTICS_LOCATION = "badgeAnalyticsLocation";
    public static final String DETAILS_BADGE_ANALYTICS_LABEL = "badgeAnalyticsLabel";
    public static final String DETAILS_PAGE_METADATA_PROPERTY = "pageMetaProperty";
    public static final String DETAILS_PAGE_METADATA_PROPERTY_CONTENT = "pageMetaPropertyContent";
    public static final String DETAILS_ANALYTICS_TRACK = "analyticsTrack";
    public static final String DETAILS_ANALYTICS_LOCATION = "analyticsLocation";
    public static final String DETAILS_ANALYTICS_LABEL = "analyticsLabel";
    public static final String DETAILS_ANALYTICS_PAGENAME = "analyticsPageName";
    public static final String DETAILS_ANALYTICS_PAGETYPE = "analyticsPageType";
    public static final String DETAILS_ANALYTICS_PLATFORM = "analyticsPlatform";
    public static final String DETAILS_ANALYTICS_ABORT = "analyticsAbort";
    public static final String DETAILS_ANALYTICS_VARIANT = "analyticsVariant";
    public static final String DETAILS_DATA_ANALYTICS_TRACK = "data-layer-track";
    public static final String DETAILS_DATA_ANALYTICS_LOCATION = "data-layer-location";
    public static final String DETAILS_DATA_ANALYTICS_LABEL = "data-layer-label";
    public static final String FIELD_HIDEINMENU = "hideInMenu";
    public static final Pattern DEFAULT_RENDTION_PATTERN_OOTB = Pattern.compile("cq5dam\\.(.*)?\\.(\\d+)\\.(\\d+)\\.(.*)");
    public static final String DEFAULT_ASSET_RENDITION_PREFIX1 = "cq5dam.thumbnail.";
    public static final String DEFAULT_ASSET_RENDITION_PREFIX2 = "cq5dam.web.";
    public static final String DEFAULT_IMAGE_GENERATED_FORMAT = "{0}.img.jpeg/{1}.jpeg";
    public static final String DEFAULT_IMAGE_RESOURCETYPE = "aemdesign/components/media/image";
    public static final String DEFAULT_IMAGE_RESOURCETYPE_SUFFIX = "/components/media/image";
    public static final String COMPONENT_ATTRIBUTES = "componentAttributes";
    public static final String COMPONENT_INSTANCE_NAME = "instanceName";
    public static final String COMPONENT_TARGET_RESOURCE = "targetResource";
    public static final String COMPONENT_ATTRIBUTE_CLASS = "class";
    public static final String COMPONENT_INPAGEPATH = "componentInPagePath";
    public static final String COMPONENT_ATTRIBUTE_INPAGEPATH = "data-layer-componentpath";
    public static final String COMPONENT_BACKGROUND_ASSETS = "componentBackgroundAssets";
    public static final String COMPONENT_VARIANT_TEMPLATE = "variantTemplate";
    public static final String COMPONENT_VARIANT_TEMPLATE_FORMAT = "variant.{0}.html";
    public static final String COMPONENT_BADGE = "componentBadge";
    public static final String COMPONENT_BADGE_SELECTED = "componentBadgeSelected";
    public static final String COMPONENT_BADGE_CONFIG_SET = "badgeConfigSet";
    public static final String COMPONENT_BADGE_TEMPLATE = "componentBadgeTemplate";
    public static final String COMPONENT_BADGE_TEMPLATE_FORMAT = "{0}.html";
    public static final String COMPONENT_BADGE_DEFAULT_TEMPLATE_FORMAT = "badge.{0}.html";
    public static final String COMPONENT_CANCEL_INHERIT_PARENT = "cancelInheritParent";
    public static final String FIELD_STYLE_COMPONENT_ID = "componentId";
    public static final String FIELD_STYLE_COMPONENT_THEME = "componentTheme";
    public static final String FIELD_STYLE_COMPONENT_MODIFIERS = "componentModifiers";
    public static final String FIELD_STYLE_COMPONENT_MODULES = "componentModules";
    public static final String FIELD_STYLE_COMPONENT_CHEVRON = "componentChevron";
    public static final String FIELD_STYLE_COMPONENT_ICON = "componentIcon";
    public static final String FIELD_STYLE_COMPONENT_BOOLEANATTR = "componentBooleanAttrs";
    public static final String FIELD_STYLE_COMPONENT_POSITIONX = "componentPositionX";
    public static final String FIELD_STYLE_COMPONENT_POSITIONY = "componentPositionY";
    public static final String FIELD_STYLE_COMPONENT_WIDTH = "componentWidth";
    public static final String FIELD_STYLE_COMPONENT_HEIGHT = "componentHeight";
    public static final String FIELD_STYLE_COMPONENT_SITETHEMECATEGORY = "siteThemeCategory";
    public static final String FIELD_STYLE_COMPONENT_SITETHEMECOLOR = "siteThemeColor";
    public static final String FIELD_STYLE_COMPONENT_SITETITLECOLOR = "siteTileColor";
    public static final String FIELD_ARIA_ROLE = "ariaRole";
    public static final String FIELD_ARIA_LABEL = "ariaLabel";
    public static final String FIELD_ARIA_DESCRIBEDBY = "ariaDescribedBy";
    public static final String FIELD_ARIA_LABELLEDBY = "ariaLabelledBy";
    public static final String FIELD_ARIA_CONTROLS = "ariaControls";
    public static final String FIELD_ARIA_LIVE = "ariaLive";
    public static final String FIELD_ARIA_HIDDEN = "ariaHidden";
    public static final String FIELD_ARIA_HASPOPUP = "ariaHaspopup";
    public static final String FIELD_ARIA_ACCESSKEY = "ariaAccessKey";
    public static final String FIELD_ARIA_DATA_ATTRIBUTE_ROLE = "role";
    public static final String FIELD_DATA_ANALYTICS_TYPE = "data-analytics-type";
    public static final String FIELD_DATA_ANALYTICS_HIT_TYPE = "data-analytics-hit-type";
    public static final String FIELD_DATA_ANALYTICS_METATYPE = "data-analytics-metatype";
    public static final String FIELD_DATA_ANALYTICS_FILENAME = "data-analytics-filename";
    public static final String FIELD_DATA_ANALYTICS_EVENT_CATEGORY = "data-analytics-event-category";
    public static final String FIELD_DATA_ANALYTICS_EVENT_ACTION = "data-analytics-event-action";
    public static final String FIELD_DATA_ANALYTICS_EVENT_LABEL = "data-analytics-event-label";
    public static final String FIELD_DATA_ANALYTICS_TRANSPORT = "data-analytics-transport";
    public static final String FIELD_DATA_ANALYTICS_NONINTERACTIVE = "data-analytics-noninteraction";
    public static final String FIELD_DATA_ARRAY_SEPARATOR = ",";
    public static final String FIELD_DATA_TAG_SEPARATOR = " ";
    public static final String FIELD_HREF = "href";
    public static final String FIELD_TITLE_TAG_TYPE = "titleType";
    public static final String FIELD_HIDE_TITLE = "hideTitle";
    public static final String FIELD_HIDE_DESCRIPTION = "hideDescription";
    public static final String FIELD_SHOW_BREADCRUMB = "showBreadcrumb";
    public static final String FIELD_SHOW_TOOLBAR = "showToolbar";
    public static final String FIELD_SHOW_PAGEDATE = "showPageDate";
    public static final String FIELD_SHOW_PARSYS = "showParsys";
    public static final String FIELD_BADGE_PAGE = "badgePage";
    public static final String JCR_NAME_SEPARATOR = "_";
    public static final String FIELD_LICENSE_INFO = "licenseInfo";
    public static final String FIELD_ASSETID = "asset-id";
    public static final String FIELD_ASSET_LICENSED = "asset-licensed";
    public static final String FIELD_ASSET_TRACKABLE = "asset-trackable";
    public static final String FIELD_DATA_ASSET_PRIMARY_ID = "data-asset-primary-id";
    public static final String FIELD_DATA_ASSET_PRIMARY_LICENSE = "data-asset-primary-license";
    public static final String FIELD_DATA_ASSET_SECONDARY_ID = "data-asset-secondary-id";
    public static final String FIELD_DATA_ASSET_SECONDARY_LICENSE = "data-asset-secondary-license";
    public static final String FIELD_DATA_ASSET_SECONDARY_SRC = "data-asset-secondary-src";
    public static final String FIELD_DATA_ASSET_SECONDARY_CLASS = "secondary";
    public static final String FIELD_WIDTH = "width";
    public static final String FIELD_HEIGHT = "height";
    public static final String FIELD_CLASS = "class";
    public static final String FIELD_EXTERNAL = "external";
    public static final String FIELD_TARGET = "target";
    public static final String FIELD_LINK_TARGET = "linkTarget";
    public static final String FIELD_CANONICAL_URL = "canonicalUrl";
    public static final String FIELD_OG_URL = "og:url";
    public static final String FIELD_OG_IMAGE = "og:image";
    public static final String FIELD_OG_TITLE = "og:title";
    public static final String FIELD_OG_DESCRIPTION = "og:description";
    public static final String DETAILS_TITLE = "title";
    public static final String DETAILS_DESCRIPTION = "description";
    public static final String DETAILS_COLUMNS_LAYOUT_CLASS_SMALL = "layoutColumnClassSmall";
    public static final String DETAILS_COLUMNS_LAYOUT_CLASS_MEDIUM = "layoutColumnClassMedium";
    public static final String DETAILS_COLUMNS_LAYOUT_CLASS_LARGE = "layoutColumnClassLarge";
    public static final String DETAILS_COLUMNS_LAYOUT_CLASS_XLARGE = "layoutColumnClassExtraLarge";
    public static final String DETAILS_COLUMNS_LAYOUT_ROW_CLASS = "layoutRowClass";
    public static final String PAGECONTEXTMAP_SOURCE = "object";
    public static final String PAGECONTEXTMAP_SOURCE_TYPE = "objecttype";
    public static final String PAGECONTEXTMAP_SOURCE_TYPE_WCMUSEPOJO = "wcmusepojo";
    public static final String PAGECONTEXTMAP_SOURCE_TYPE_PAGECONTEXT = "pagecontext";
    public static final String PAGECONTEXTMAP_SOURCE_TYPE_SLINGMODEL = "slingmodel";
    public static final String PAGECONTEXTMAP_OBJECT_SLINGREQUEST = "slingRequest";
    public static final String PAGECONTEXTMAP_OBJECT_RESOURCERESOLVER = "resourceResolver";
    public static final String PAGECONTEXTMAP_OBJECT_SLING = "sling";
    public static final String PAGECONTEXTMAP_OBJECT_COMPONENTCONTEXT = "componentContext";
    public static final String PAGECONTEXTMAP_OBJECT_RESOURCE = "resource";
    public static final String PAGECONTEXTMAP_OBJECT_CURRENTNODE = "currentNode";
    public static final String PAGECONTEXTMAP_OBJECT_PROPERTIES = "properties";
    public static final String PAGECONTEXTMAP_OBJECT_CURRENTSTYLE = "currentStyle";
    public static final String PAGECONTEXTMAP_OBJECT_CURRENTPAGE = "currentPage";
    public static final String PAGECONTEXTMAP_OBJECT_RESOURCEPAGE = "resourcePage";
    public static final String PAGECONTEXTMAP_OBJECT_RESOURCEDESIGN = "resourceDesign";
    public static final String DETAILS_SELECTOR_BADGE = "badge";
    private static final String STRING_EXPRESSION_CHECK = ".*(\\$\\{.*?\\}).*";
    public static final Object[][] DEFAULT_FIELDS_STYLE = new Object[][]{{"componentId", "", "id"}, {"componentTheme", new String[0], "class", Tag.class.getCanonicalName()}, {"componentModifiers", new String[0], "class", Tag.class.getCanonicalName()}, {"componentModules", new String[0], "data-modules", Tag.class.getCanonicalName()}, {"componentChevron", new String[0], "class", Tag.class.getCanonicalName()}, {"componentIcon", new String[0], "class", Tag.class.getCanonicalName()}, {"componentPositionX", "", "x"}, {"componentPositionY", "", "y"}, {"componentWidth", "${value ? 'width:' + value + 'px;' : ''}", "style"}, {"componentHeight", "${value ? 'height:' + value + 'px;' : ''}", "style"}, {"siteThemeCategory", ""}, {"siteThemeColor", ""}, {"siteTileColor", ""}, {"componentBooleanAttrs", new String[0], " ", Tag.class.getCanonicalName()}};
    public static final Object[][] DEFAULT_FIELDS_ACCESSIBILITY = new Object[][]{{"ariaRole", "", "role"}, {"ariaLabel", "", "aria-label"}, {"ariaDescribedBy", "", "aria-describedby"}, {"ariaLabelledBy", "", "aria-labelledby"}, {"ariaControls", "", "aria-controls"}, {"ariaLive", "", "aria-live"}, {"ariaHidden", "", "aria-hidden"}, {"ariaHaspopup", "", "aria-haspopup"}, {"ariaAccessKey", "", "accesskey"}};
    public static final Object[][] DEFAULT_FIELDS_METADATA = new Object[][]{{"metadataContentType", ""}, {"cq:lastModified", ""}, {"jcr:lastModified", ""}, {"jcr:created", ""}, {"cq:lastReplicated", ""}};
    public static final Object[][] DEFAULT_FIELDS_DETAILS_OPTIONS = new Object[][]{{"menuColor", ""}, {"menuIconShow", false}, {"menuIcon", new String[0], "", Tag.class.getCanonicalName()}, {"menuAccesskey", ""}, {"cardStyle", new String[0], "", Tag.class.getCanonicalName()}, {"cardIconShow", false}, {"cardIcon", new String[0], "", Tag.class.getCanonicalName()}, {"badgeLinkTarget", "_blank"}, {"badgeLinkText", "${value ? value : (pageNavTitle ? pageNavTitle : '')}"}, {"badgeLinkTitle", "${value ? value : (pageTitle ? pageTitle : '')}"}, {"badgeLinkStyle", new String[0], "", Tag.class.getCanonicalName()}, {"badgeLinkFormatted", "${value ? value : pageUrl}", "", Tag.class.getCanonicalName()}, {"badgeTitleTrim", false}, {"badgeTitleTrimLengthMax", 50}, {"badgeTitleTrimLengthMaxSuffix", "..."}, {"badgeSummaryTrim", false}, {"badgeSummaryLengthMax", 50}, {"badgeSummaryLengthMaxSuffix", "..."}, {"tabIconShow", false}, {"tabIcon", new String[0], "", Tag.class.getCanonicalName()}, {"titleIconShow", false}, {"titleIcon", new String[0], "", Tag.class.getCanonicalName()}, {"badgeOverlayIconShow", false}, {"badgeOverlayIcon", new String[0], "", Tag.class.getCanonicalName()}, {"badgeThumbnailWidth", 319}, {"badgeThumbnailHeight", ""}, {"badgeThumbnailType", "rendition"}, {"badgeTitleType", "h3"}, {"badgeThumbnailId", ""}, {"badgeThumbnailLicenseInfo", ""}, {"badgeThumbnail", ""}, {"badgeAnalyticsTrack", "", "data-layer-track"}, {"badgeAnalyticsLocation", "", "data-layer-location"}, {"badgeAnalyticsLabel", "${value ?  value : badgeLinkText}", "data-layer-label"}, {"pageMetaProperty", new String[0]}, {"pageMetaPropertyContent", new String[0]}, {"badgeCustom", false}, {"badgeFieldsTemplate", new String[0]}, {"badgeFields", new String[0]}, {"badgeTemplate", ""}};
    public static final Object[][] DEFAULT_FIELDS_DETAILS_OPTIONS_OVERRIDE = new Object[][]{{"menuColor", ""}, {"menuIconShow", ""}, {"menuIcon", new String[0], "", Tag.class.getCanonicalName()}, {"menuAccesskey", ""}, {"cardStyle", new String[0], "", Tag.class.getCanonicalName()}, {"cardIconShow", ""}, {"cardIcon", new String[0], "", Tag.class.getCanonicalName()}, {"badgeLinkTarget", ""}, {"badgeLinkText", ""}, {"badgeLinkTitle", ""}, {"badgeLinkStyle", new String[0], "", Tag.class.getCanonicalName()}, {"badgeLinkFormatted", new String[0], "", Tag.class.getCanonicalName()}, {"badgeTitleTrim", ""}, {"badgeTitleTrimLengthMax", 20}, {"badgeTitleTrimLengthMaxSuffix", "..."}, {"badgeSummaryTrim", ""}, {"badgeSummaryLengthMax", 20}, {"badgeSummaryLengthMaxSuffix", "..."}, {"tabIconShow", ""}, {"tabIcon", new String[0], "", Tag.class.getCanonicalName()}, {"titleIconShow", ""}, {"titleIcon", new String[0], "", Tag.class.getCanonicalName()}, {"badgeOverlayIconShow", ""}, {"badgeOverlayIcon", new String[0], "", Tag.class.getCanonicalName()}, {"badgeThumbnailWidth", ""}, {"badgeThumbnailHeight", ""}, {"badgeThumbnailType", ""}, {"badgeTitleType", ""}, {"badgeThumbnailId", ""}, {"badgeThumbnailLicenseInfo", ""}, {"badgeThumbnail", ""}, {"badgeAnalyticsTrack", "", "data-layer-track"}, {"badgeAnalyticsLocation", "", "data-layer-location"}, {"badgeAnalyticsLabel", "", "data-layer-label"}, {"badgeCustom", false}, {"badgeFieldsTemplate", new String[0]}, {"badgeFields", new String[0]}, {"badgeTemplate", ""}};
    public static final Object[][] DEFAULT_FIELDS_ANALYTICS = new Object[][]{{"analyticsTrack", false, "data-layer-track"}, {"analyticsLocation", "", "data-layer-location"}, {"analyticsLabel", "${ value ? value : label }", "data-layer-label"}, {"analyticsEventType", "", "data-analytics-event"}, {"analyticsHitType", "", "data-analytics-hit-type"}, {"analyticsEventCategory", "", "data-analytics-event-category"}, {"analyticsEventAction", "", "data-analytics-event-action"}, {"analyticsEventLabel", "", "data-analytics-event-label"}, {"analyticsTransport", "", "data-analytics-transport"}, {"analyticsNonInteraction", "", "data-analytics-noninteraction"}};
    public static final Object[][] DEFAULT_FIELDS_ATTRIBUTES = new Object[][]{{"dataType", "", "type"}, {"dataTarget", "", "data-target"}, {"dataToggle", "", "data-toggle"}};
    public static final Object[][] DEFAULT_FIELDS_ASSET = new Object[][]{{"dc:title", "${ value ? value : name }", "data-title"}, {"dc:description", "", "data-description"}, {"photoshop:Credit", "", "data-credit"}, {"photoshop:Headline", "", "data-headline"}, {"photoshop:Source", "", "data-source"}, {"sourceAsset", "", "data-sourceurl"}, {"sourceVideo", "", "data-videourl"}, {"tiff:ImageWidth", "", "data-width"}, {"tiff:ImageLength", "", "data-height"}, {"dc:rights", "", "data-rights"}, {"dc:creator", "", "data-creator"}, {"dc:format", ""}};
    public static final Object[][] DEFAULT_FIELDS_ASSET_IMAGE = new Object[][]{{"dc:title", ""}, {"dc:description", ""}, {"photoshop:Credit", ""}, {"photoshop:Headline", ""}, {"photoshop:Source", ""}, {"sourceAsset", ""}};
    public static final Object[][] DEFAULT_FIELDS_ASSET_VIDEO = new Object[][]{{"dc:title", ""}, {"dc:description", ""}, {"photoshop:Headline", ""}, {"photoshop:Credit", ""}, {"photoshop:Source", ""}, {"sourceAsset", ""}, {"sourceVideo", ""}};
    public static final Object[][] DEFAULT_FIELDS_PAGE_THEME = new Object[][]{{"themeStyle", ""}, {"faviconsPath", ""}, {"favicon", ""}, {"siteThemeColor", ""}, {"siteTileColor", ""}};
    public static final Object[][] DEFAULT_COMMON_COMPONENT_LAYOUT_FIELDS = new Object[][]{{"variant", "default"}, {"titleType", ""}, {"hideTitle", false}, {"hideDescription", false}, {"showBreadcrumb", true}, {"showToolbar", true}, {"showPageDate", true}, {"showParsys", true}};

    public static String getResourceContent(ResourceResolver resourceResolver, String[] paths, String separator) {
        String returnValue = "";
        for (String path : paths) {
            Resource resource = resourceResolver.getResource(path);
            returnValue = returnValue.concat(ComponentsUtil.getResourceContent(resource));
            if (!StringUtils.isNotEmpty((CharSequence)separator) || separator == null) continue;
            returnValue = returnValue.concat(separator);
        }
        return returnValue;
    }

    public static String getResourceContent(Resource resource) {
        String returnValue = "";
        if (resource != null) {
            try {
                Node resourceNode = (Node)resource.adaptTo(Node.class);
                if (resourceNode != null) {
                    Node contentNode = null;
                    if (resourceNode.getPrimaryNodeType().getName().equals("cq:Page") && resourceNode.hasNode("jcr:content")) {
                        contentNode = resourceNode.getNode("jcr:content");
                    }
                    String originalPath = "jcr:content".concat("/").concat("renditions").concat("/original/").concat("jcr:content");
                    if (resourceNode.getPrimaryNodeType().getName().equals("dam:Asset") && resourceNode.hasNode(originalPath)) {
                        contentNode = resourceNode.getNode(originalPath);
                    }
                    if (contentNode != null && contentNode.hasProperty("jcr:data")) {
                        InputStream contentsStream = contentNode.getProperty("jcr:data").getBinary().getStream();
                        byte[] result = null;
                        BufferedInputStream bin = new BufferedInputStream(contentsStream);
                        result = IOUtils.toByteArray((InputStream)bin);
                        bin.close();
                        contentsStream.close();
                        if (result != null) {
                            returnValue = new String(result);
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("Could not load file to be included {}", (Object)resource.getPath());
            }
        }
        return returnValue;
    }

    public static Object getComponentProperty(ValueMap componentProperties, ValueMap contentPolicy, String name, Object defaultValue, Boolean useStyle) {
        if (componentProperties == null) {
            LOGGER.warn("getComponentProperty, componentProperties is ({0})", (Object)componentProperties);
            return "";
        }
        if (useStyle.booleanValue() && (contentPolicy == null || contentPolicy.isEmpty())) {
            useStyle = false;
        }
        if (useStyle.booleanValue()) {
            return componentProperties.get(name, contentPolicy.get(name, defaultValue));
        }
        return componentProperties.get(name, defaultValue);
    }

    public static Object getComponentProperty(ValueMap componentProperties, Style pageStyle, String name, Object defaultValue, Boolean useStyle) {
        if (componentProperties == null) {
            LOGGER.warn("getComponentProperty, componentProperties is ({0})", (Object)componentProperties);
            return "";
        }
        if (useStyle.booleanValue() && pageStyle == null) {
            LOGGER.warn("getComponentProperty, useStyle is ({0}) but pageStyle is {1}", (Object)useStyle, (Object)pageStyle);
            return "";
        }
        if (useStyle.booleanValue()) {
            return componentProperties.get(name, pageStyle.get(name, defaultValue));
        }
        return componentProperties.get(name, defaultValue);
    }

    public static ComponentProperties getComponentProperties(PageContext pageContext, Page componentPage, String componentPath, Object[][] ... fieldLists) {
        try {
            Resource componentResource = componentPage.getContentResource(componentPath);
            return ComponentsUtil.getComponentProperties(pageContext, (Object)componentResource, fieldLists);
        }
        catch (Exception ex) {
            LOGGER.error("getComponentProperties: {}, error: {}", (Object)componentPath, (Object)ex);
            return ComponentsUtil.getNewComponentProperties(pageContext);
        }
    }

    public static ComponentProperties getNewComponentProperties(PageContext pageContext) {
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)pageContext.getAttribute(PAGECONTEXTMAP_OBJECT_SLINGREQUEST);
        HashMap<String, Object> pageContextMap = new HashMap<String, Object>();
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_SLINGREQUEST, slingRequest);
        return ComponentsUtil.getNewComponentProperties(pageContextMap);
    }

    public static ComponentProperties getNewComponentProperties(WCMUsePojo wcmUsePojoModel) {
        SlingHttpServletRequest slingRequest = wcmUsePojoModel.getRequest();
        HashMap<String, Object> pageContextMap = new HashMap<String, Object>();
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_SLINGREQUEST, slingRequest);
        return ComponentsUtil.getNewComponentProperties(pageContextMap);
    }

    public static ComponentProperties getNewComponentProperties(Map<String, Object> pageContext) {
        ComponentProperties componentProperties = new ComponentProperties();
        try {
            SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)pageContext.get(PAGECONTEXTMAP_OBJECT_SLINGREQUEST);
            XSSAPI oldXssAPI = (XSSAPI)slingRequest.adaptTo(XSSAPI.class);
            componentProperties.attr = new AttrBuilder((HttpServletRequest)slingRequest, oldXssAPI);
        }
        catch (Exception ex) {
            LOGGER.error("getNewComponentProperties: could not configure componentProperties with attributeBuilder");
        }
        return componentProperties;
    }

    public static ComponentProperties getComponentProperties(WCMUsePojo wcmUsePojoModel, Boolean includeComponentAttributes, Object[][] ... fieldLists) {
        return ComponentsUtil.getComponentProperties(wcmUsePojoModel, null, includeComponentAttributes, fieldLists);
    }

    public static ComponentProperties getComponentProperties(WCMUsePojo wcmUsePojoModel, Object[][] ... fieldLists) {
        return ComponentsUtil.getComponentProperties(wcmUsePojoModel, null, (Boolean)true, fieldLists);
    }

    public static ComponentProperties getComponentProperties(GenericModel genericModel, Object[][] ... fieldLists) {
        return ComponentsUtil.getComponentProperties(genericModel, null, (Boolean)true, fieldLists);
    }

    public static ComponentProperties getComponentProperties(WCMUsePojo wcmUsePojoModel, Object targetResource, Object[][] ... fieldLists) {
        try {
            return ComponentsUtil.getComponentProperties(ComponentsUtil.getContextObjects(wcmUsePojoModel), targetResource, (Boolean)true, fieldLists);
        }
        catch (Exception ex) {
            LOGGER.error("getComponentProperties(wcmUsePojoModel,targetResource,fieldLists) could not read required objects: {}, error: {}", (Object)wcmUsePojoModel, (Object)ex);
            return ComponentsUtil.getNewComponentProperties(wcmUsePojoModel);
        }
    }

    public static ComponentProperties getComponentProperties(GenericModel genericModel, Resource targetResource, Object[][] ... fieldLists) {
        try {
            return ComponentsUtil.getComponentProperties(genericModel.getPageContextMap(), (Object)targetResource, (Boolean)true, fieldLists);
        }
        catch (Exception ex) {
            LOGGER.error("getComponentProperties(genericModel,targetResource,fieldLists) could not read required objects: {}, error: {}", (Object)genericModel, (Object)ex);
            return ComponentsUtil.getNewComponentProperties(genericModel.getPageContextMap());
        }
    }

    public static ComponentProperties getComponentProperties(PageContext pageContext, Object targetResource, Object[][] ... fieldLists) {
        return ComponentsUtil.getComponentProperties(pageContext, targetResource, (Boolean)true, fieldLists);
    }

    public static Map<String, Object> getContextObjects(WCMUsePojo wcmUsePojoModel) {
        SlingHttpServletRequest slingRequest = wcmUsePojoModel.getRequest();
        ResourceResolver resourceResolver = wcmUsePojoModel.getResourceResolver();
        SlingScriptHelper sling = wcmUsePojoModel.getSlingScriptHelper();
        ComponentContext componentContext = wcmUsePojoModel.getComponentContext();
        Resource resource = wcmUsePojoModel.getResource();
        Node currentNode = (Node)resource.adaptTo(Node.class);
        ValueMap properties = wcmUsePojoModel.getProperties();
        Style currentStyle = wcmUsePojoModel.getCurrentStyle();
        Page currentPage = wcmUsePojoModel.getCurrentPage();
        Page resourcePage = wcmUsePojoModel.getResourcePage();
        Design resourceDesign = wcmUsePojoModel.getResourceDesign();
        HashMap<String, Object> pageContextMap = new HashMap<String, Object>();
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_SLINGREQUEST, slingRequest);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_RESOURCERESOLVER, resourceResolver);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_SLING, sling);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_COMPONENTCONTEXT, componentContext);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_RESOURCE, resource);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_CURRENTNODE, currentNode);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_PROPERTIES, properties);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_CURRENTSTYLE, currentStyle);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_CURRENTPAGE, currentPage);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_RESOURCEPAGE, resourcePage);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_RESOURCEDESIGN, resourceDesign);
        pageContextMap.put(PAGECONTEXTMAP_SOURCE, wcmUsePojoModel);
        pageContextMap.put(PAGECONTEXTMAP_SOURCE_TYPE, PAGECONTEXTMAP_SOURCE_TYPE_WCMUSEPOJO);
        return pageContextMap;
    }

    public static Map<String, Object> getContextObjects(PageContext pageContext) {
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)pageContext.getAttribute(PAGECONTEXTMAP_OBJECT_SLINGREQUEST);
        ResourceResolver resourceResolver = (ResourceResolver)pageContext.getAttribute(PAGECONTEXTMAP_OBJECT_RESOURCERESOLVER);
        SlingScriptHelper sling = (SlingScriptHelper)pageContext.getAttribute(PAGECONTEXTMAP_OBJECT_SLING);
        ComponentContext componentContext = (ComponentContext)pageContext.getAttribute(PAGECONTEXTMAP_OBJECT_COMPONENTCONTEXT);
        Resource resource = (Resource)pageContext.getAttribute(PAGECONTEXTMAP_OBJECT_RESOURCE);
        Node currentNode = (Node)pageContext.getAttribute(PAGECONTEXTMAP_OBJECT_CURRENTNODE);
        ValueMap properties = (ValueMap)pageContext.getAttribute(PAGECONTEXTMAP_OBJECT_PROPERTIES);
        Style currentStyle = (Style)pageContext.getAttribute(PAGECONTEXTMAP_OBJECT_CURRENTSTYLE);
        Page currentPage = (Page)pageContext.getAttribute(PAGECONTEXTMAP_OBJECT_CURRENTPAGE);
        Page resourcePage = (Page)pageContext.getAttribute(PAGECONTEXTMAP_OBJECT_RESOURCEPAGE);
        Design resourceDesign = (Design)pageContext.getAttribute(PAGECONTEXTMAP_OBJECT_RESOURCEDESIGN);
        HashMap<String, Object> pageContextMap = new HashMap<String, Object>();
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_SLINGREQUEST, slingRequest);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_RESOURCERESOLVER, resourceResolver);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_SLING, sling);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_COMPONENTCONTEXT, componentContext);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_RESOURCE, resource);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_CURRENTNODE, currentNode);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_PROPERTIES, properties);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_CURRENTSTYLE, currentStyle);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_CURRENTPAGE, currentPage);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_RESOURCEPAGE, resourcePage);
        pageContextMap.put(PAGECONTEXTMAP_OBJECT_RESOURCEDESIGN, resourceDesign);
        pageContextMap.put(PAGECONTEXTMAP_SOURCE, pageContext);
        pageContextMap.put(PAGECONTEXTMAP_SOURCE_TYPE, PAGECONTEXTMAP_SOURCE_TYPE_PAGECONTEXT);
        return pageContextMap;
    }

    public static ComponentProperties getComponentProperties(GenericModel genericModel, Object targetResource, Boolean includeComponentAttributes, Object[][] ... fieldLists) {
        try {
            return ComponentsUtil.getComponentProperties(genericModel.getPageContextMap(), targetResource, includeComponentAttributes, fieldLists);
        }
        catch (Exception ex) {
            LOGGER.error("getComponentProperties(genericModel,targetResource,includeComponentAttributes,fieldLists) could not read required objects: {}, error: {}", (Object)genericModel, (Object)ex);
            return ComponentsUtil.getNewComponentProperties(genericModel.getPageContextMap());
        }
    }

    public static ComponentProperties getComponentProperties(WCMUsePojo wcmUsePojoModel, Object targetResource, Boolean includeComponentAttributes, Object[][] ... fieldLists) {
        try {
            return ComponentsUtil.getComponentProperties(ComponentsUtil.getContextObjects(wcmUsePojoModel), targetResource, includeComponentAttributes, fieldLists);
        }
        catch (Exception ex) {
            LOGGER.error("getComponentProperties(wcmUsePojoModel,targetResource,includeComponentAttributes,fieldLists) could not read required objects: {}, error: {}", (Object)wcmUsePojoModel, (Object)ex);
            return ComponentsUtil.getNewComponentProperties(wcmUsePojoModel);
        }
    }

    public static ComponentProperties getComponentProperties(PageContext pageContext, Object targetResource, Boolean includeComponentAttributes, Object[][] ... fieldLists) {
        try {
            return ComponentsUtil.getComponentProperties(ComponentsUtil.getContextObjects(pageContext), targetResource, includeComponentAttributes, fieldLists);
        }
        catch (Exception ex) {
            LOGGER.error("getComponentProperties(PageContext) could not read required objects", (Throwable)ex);
            return ComponentsUtil.getNewComponentProperties(pageContext);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ComponentProperties getComponentProperties(Map<String, Object> pageContext, Object targetResource, Boolean includeComponentAttributes, Object[][] ... fieldLists) {
        ComponentProperties componentProperties = new ComponentProperties();
        boolean addMoreAttributes = includeComponentAttributes;
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)pageContext.get(PAGECONTEXTMAP_OBJECT_SLINGREQUEST);
        SlingScriptHelper sling = (SlingScriptHelper)pageContext.get(PAGECONTEXTMAP_OBJECT_SLING);
        XSSAPI oldXssAPI = (XSSAPI)slingRequest.adaptTo(XSSAPI.class);
        ComponentContext componentContext = (ComponentContext)pageContext.get(PAGECONTEXTMAP_OBJECT_COMPONENTCONTEXT);
        Component component = componentContext.getComponent();
        componentProperties.attr = new AttrBuilder((HttpServletRequest)slingRequest, oldXssAPI);
        if (addMoreAttributes) {
            componentProperties.attr.add("component", "true");
        }
        componentProperties.expressionFields = new ArrayList();
        Resource contentResource = null;
        String CLASS_TYPE_RESOURCE = Resource.class.getCanonicalName();
        String CLASS_TYPE_JCRNODERESOURCE = "org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResource";
        String CLASS_TYPE_ASSET = "com.adobe.granite.asset.core.impl.AssetImpl";
        ContentAccess contentAccess = (ContentAccess)sling.getService(ContentAccess.class);
        if (contentAccess == null) {
            LOGGER.error("getComponentProperties: could not get ContentAccess service.");
            return componentProperties;
        }
        try (ResourceResolver adminResourceResolver = contentAccess.getAdminResourceResolver();){
            Node currentNode = (Node)pageContext.get(PAGECONTEXTMAP_OBJECT_CURRENTNODE);
            TagManager tagManager = (TagManager)adminResourceResolver.adaptTo(TagManager.class);
            ValueMap properties = (ValueMap)pageContext.get(PAGECONTEXTMAP_OBJECT_PROPERTIES);
            ValueMap currentPolicy = ComponentsUtil.getContentPolicyProperties(componentContext.getResource(), adminResourceResolver);
            if (targetResource != null && targetResource.getClass().getCanonicalName().equals("com.adobe.granite.asset.core.impl.AssetImpl")) {
                try {
                    Asset asset = (Asset)targetResource;
                    contentResource = asset.getResourceResolver().getResource((Resource)asset, "jcr:content");
                    if (contentResource != null) {
                        contentResource = contentResource.getChild("metadata");
                    }
                    properties = (ValueMap)contentResource.adaptTo(ValueMap.class);
                    addMoreAttributes = false;
                    componentProperties.put(COMPONENT_TARGET_RESOURCE, contentResource.getPath());
                }
                catch (Exception ex) {
                    LOGGER.error("getComponentProperties: could not evaluate target asset", (Throwable)ex);
                    ComponentProperties componentProperties2 = componentProperties;
                    if (adminResourceResolver == null) return componentProperties2;
                    if (var17_18 == null) {
                        adminResourceResolver.close();
                        return componentProperties2;
                    }
                    try {
                        adminResourceResolver.close();
                        return componentProperties2;
                    }
                    catch (Throwable throwable) {
                        var17_18.addSuppressed(throwable);
                        return componentProperties2;
                    }
                }
            } else if (targetResource != null && (targetResource.getClass().getCanonicalName().equals(CLASS_TYPE_RESOURCE) || targetResource.getClass().getCanonicalName().equals("org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResource"))) {
                try {
                    Node resourceNode;
                    contentResource = (Resource)targetResource;
                    properties = (ValueMap)contentResource.adaptTo(ValueMap.class);
                    currentPolicy = ComponentsUtil.getContentPolicyProperties(contentResource, adminResourceResolver);
                    ComponentManager componentManager = (ComponentManager)contentResource.getResourceResolver().adaptTo(ComponentManager.class);
                    Component resourceComponent = componentManager.getComponentOfResource(contentResource);
                    if (resourceComponent != null) {
                        component = resourceComponent;
                    }
                    if ((resourceNode = (Node)contentResource.adaptTo(Node.class)) != null) {
                        currentNode = resourceNode;
                    }
                    componentProperties.put(COMPONENT_TARGET_RESOURCE, contentResource.getPath());
                }
                catch (Exception ex) {
                    LOGGER.error("getComponentProperties: could not evaluate target resource", (Throwable)ex);
                    ComponentProperties resourceComponent = componentProperties;
                    if (adminResourceResolver == null) return resourceComponent;
                    if (var17_18 == null) {
                        adminResourceResolver.close();
                        return resourceComponent;
                    }
                    try {
                        adminResourceResolver.close();
                        return resourceComponent;
                    }
                    catch (Throwable resourceNode) {
                        var17_18.addSuppressed(resourceNode);
                        return resourceComponent;
                    }
                }
            } else if (targetResource != null) {
                LOGGER.warn("getComponentProperties: processing is unsupported of target resource of type: {}", (Object)targetResource.getClass().getCanonicalName());
            } else if (targetResource == null) {
                LOGGER.warn("getComponentProperties: processing of NULL target resource of type return design defaults");
            }
            if (currentNode != null && addMoreAttributes) {
                componentProperties.put(COMPONENT_INSTANCE_NAME, currentNode.getName());
                String componentId = ComponentsUtil.getComponentId(currentNode);
                String componentInPagePath = ComponentsUtil.getComponentInPagePath(currentNode);
                componentProperties.put(COMPONENT_INPAGEPATH, componentInPagePath);
                componentProperties.attr.add(COMPONENT_ATTRIBUTE_INPAGEPATH, componentInPagePath);
            }
            if (component != null && addMoreAttributes) {
                componentProperties.attr.add("class", component.getName().trim());
            }
            if (fieldLists == null) return componentProperties;
            JexlEngine jexl = new JexlBuilder().create();
            JxltEngine jxlt = jexl.createJxltEngine();
            MapContext jc = new MapContext((Map<String, Object>)((Object)componentProperties));
            Object[][][] objectArray = fieldLists;
            int n = objectArray.length;
            int n2 = 0;
            block26: while (true) {
                Object[][] fieldDefaults;
                if (n2 >= n) {
                    String variant = (String)componentProperties.get(FIELD_VARIANT, "");
                    String badge = (String)componentProperties.get(DETAILS_BADGE_TEMPLATE, "");
                    if (addMoreAttributes) {
                        if (StringUtils.isEmpty((CharSequence)variant)) {
                            variant = "default";
                            componentProperties.put(FIELD_VARIANT_LEGACY, true);
                        } else {
                            ComponentProperties variantConfig = ComponentsUtil.getTemplateConfig(pageContext, variant, adminResourceResolver, tagManager, FIELD_VARIANT_FIELDS_TEMPLATE, FIELD_VARIANT_FIELDS, FIELD_VARIANT);
                            componentProperties.putAll((Map<? extends String, ?>)((Object)variantConfig));
                            variant = (String)componentProperties.get(FIELD_VARIANT, "");
                        }
                        if (StringUtils.isNotEmpty((CharSequence)badge)) {
                            ComponentProperties badgeConfig = ComponentsUtil.getTemplateConfig(pageContext, badge, adminResourceResolver, tagManager, DETAILS_BADGE_FIELDS_TEMPLATE, DETAILS_BADGE_FIELDS, "detailsBadge");
                            componentProperties.putAll((Map<? extends String, ?>)((Object)badgeConfig));
                        }
                        String variantTemplate = ComponentsUtil.getComponentVariantTemplate(component, MessageFormat.format(COMPONENT_VARIANT_TEMPLATE_FORMAT, variant), sling);
                        componentProperties.put(COMPONENT_VARIANT_TEMPLATE, variantTemplate);
                    }
                    if (componentProperties.attr.isEmpty()) return componentProperties;
                    if (!addMoreAttributes) return componentProperties;
                    if (StringUtils.isNotEmpty((CharSequence)variant) && !variant.equals("default")) {
                        componentProperties.attr.add("class", variant);
                    }
                    componentProperties.put(COMPONENT_ATTRIBUTES, ComponentsUtil.buildAttributesString(componentProperties.attr.getData(), oldXssAPI));
                    return componentProperties;
                }
                Object[][] objectArray2 = fieldDefaults = objectArray[n2];
                int n3 = objectArray2.length;
                int n4 = 0;
                while (true) {
                    block81: {
                        Object fieldValue;
                        boolean fieldValueHasExpressions;
                        String fieldName;
                        Object[] field;
                        block78: {
                            String fieldValueString;
                            String fieldDataName;
                            block87: {
                                int n5;
                                String[] newArray;
                                block86: {
                                    block79: {
                                        block82: {
                                            block83: {
                                                block84: {
                                                    block85: {
                                                        String fieldValueType;
                                                        Object fieldDefaultValue;
                                                        block80: {
                                                            if (n4 >= n3) break block79;
                                                            field = objectArray2[n4];
                                                            if (field.length < 1) {
                                                                throw new IllegalArgumentException(MessageFormat.format("Key, Value, ..., Value-n expected, instead got {0} fields.", field.length));
                                                            }
                                                            fieldName = field[0].toString();
                                                            fieldDefaultValue = field[1];
                                                            if (CommonUtil.isNull(fieldDefaultValue)) {
                                                                fieldDefaultValue = "";
                                                            }
                                                            fieldDataName = "";
                                                            if (field.length > 2) {
                                                                fieldDataName = field[2].toString();
                                                            }
                                                            fieldValueType = field.length > 3 ? (String)field[3] : String.class.getCanonicalName();
                                                            fieldValueHasExpressions = false;
                                                            if (!componentProperties.containsKey(fieldName)) break block80;
                                                            LOGGER.warn("getComponentProperties: skipping property [{}] its already defined, {}", (Object)fieldName, (Object)componentContext.getResource().getPath());
                                                            break block81;
                                                        }
                                                        fieldValue = null;
                                                        if (fieldDefaultValue instanceof String && StringUtils.isNotEmpty((CharSequence)fieldDefaultValue.toString()) && fieldValueType.equals(String.class.getCanonicalName()) && ComponentsUtil.isStringRegex(fieldDefaultValue.toString())) {
                                                            fieldValue = ComponentsUtil.getComponentProperty(properties, currentPolicy, fieldName, null, (Boolean)true);
                                                            boolean expressionValid = false;
                                                            try {
                                                                Object expressonResult = ComponentsUtil.evaluateExpressionWithValue(jxlt, jc, fieldDefaultValue.toString(), fieldValue);
                                                                if (expressonResult != null) {
                                                                    expressionValid = true;
                                                                    fieldDefaultValue = expressonResult;
                                                                }
                                                            }
                                                            catch (JexlException jex) {
                                                                LOGGER.warn("could not evaluate default value expression component={}, contentResource={}, currentNode={}, field={}, value={}, default value={}, componentProperties.keys={}, jex.info={}", new Object[]{component == null ? component : component.getPath(), contentResource == null ? contentResource : contentResource.getPath(), currentNode == null ? currentNode : currentNode.getPath(), fieldName, fieldValue, fieldDefaultValue, componentProperties.keySet(), jex.getInfo()});
                                                            }
                                                            catch (Exception ex) {
                                                                LOGGER.error("could not evaluate default value expression component={}, contentResource={}, currentNode={}, field={}, value={}, default value={}, componentProperties.keys={}, ex.cause={}, ex.message={}, ex={}", new Object[]{component == null ? component : component.getPath(), contentResource == null ? contentResource : contentResource.getPath(), currentNode == null ? currentNode : currentNode.getPath(), fieldName, fieldValue, fieldDefaultValue, componentProperties.keySet(), ex.getCause(), ex.getMessage(), ex});
                                                            }
                                                            if (!expressionValid) {
                                                                fieldDefaultValue = ComponentsUtil.removeRegexFromString((String)fieldDefaultValue);
                                                            }
                                                            fieldValue = fieldDefaultValue;
                                                        } else {
                                                            fieldValue = ComponentsUtil.getComponentProperty(properties, currentPolicy, fieldName, fieldDefaultValue, (Boolean)true);
                                                        }
                                                        if (fieldValue instanceof String && StringUtils.isNotEmpty((CharSequence)fieldValue.toString()) && ComponentsUtil.isStringRegex(fieldValue.toString())) {
                                                            fieldValueHasExpressions = true;
                                                        }
                                                        if (fieldValue instanceof String && StringUtils.isEmpty((CharSequence)fieldValue.toString())) {
                                                            fieldValue = fieldDefaultValue;
                                                        } else if (fieldValue instanceof String[] && fieldValue != null && StringUtils.isEmpty((CharSequence)StringUtils.join((Object[])((String[])fieldValue), (String)""))) {
                                                            fieldValue = fieldDefaultValue;
                                                        }
                                                        if (fieldValueType.equals(Tag.class.getCanonicalName()) && !fieldValue.getClass().isArray()) {
                                                            fieldValue = new String[]{(String)fieldValue};
                                                        } else if ((fieldValueType.getClass().isArray() || fieldDefaultValue.getClass().isArray()) && !fieldValue.getClass().isArray()) {
                                                            Class<?> arrayType = fieldValue.getClass().getComponentType();
                                                            newArray = Array.newInstance(arrayType, 1);
                                                            Array.set(newArray, 1, fieldValue);
                                                            fieldValue = newArray;
                                                        }
                                                        if (field.length <= 2) break block78;
                                                        fieldValueString = "";
                                                        if (!fieldValue.getClass().isArray()) break block82;
                                                        if (!ArrayUtils.isNotEmpty((Object[])((String[])fieldValue))) break block83;
                                                        if (!fieldValueType.equals(Tag.class.getCanonicalName())) break block84;
                                                        if (!StringUtils.isEmpty((CharSequence)fieldDataName)) break block85;
                                                        fieldValue = TagUtil.getTagsValues(tagManager, adminResourceResolver, FIELD_DATA_TAG_SEPARATOR, (String[])fieldValue);
                                                        newArray = (String[])fieldValue;
                                                        n5 = newArray.length;
                                                        break block86;
                                                    }
                                                    fieldValueString = TagUtil.getTagsAsValues(tagManager, adminResourceResolver, FIELD_DATA_TAG_SEPARATOR, (String[])fieldValue);
                                                    if (!ComponentsUtil.isStringRegex(fieldValueString)) break block87;
                                                    fieldValueHasExpressions = true;
                                                    break block87;
                                                }
                                                fieldValueString = StringUtils.join((Object[])((String[])fieldValue), (String)FIELD_DATA_ARRAY_SEPARATOR);
                                                break block87;
                                            }
                                            if (!StringUtils.isEmpty((CharSequence)fieldDataName)) break block87;
                                            fieldValue = "";
                                            break block87;
                                        }
                                        fieldValueString = fieldValue.toString();
                                        break block87;
                                    }
                                    ++n2;
                                    continue block26;
                                }
                                for (int i = 0; i < n5; ++i) {
                                    String tagValue = newArray[i];
                                    if (!ComponentsUtil.isStringRegex(tagValue)) continue;
                                    fieldValueHasExpressions = true;
                                    break;
                                }
                            }
                            if (StringUtils.isNotEmpty((CharSequence)fieldValueString) && StringUtils.isNotEmpty((CharSequence)fieldDataName) && !fieldDataName.equals(FIELD_DATA_TAG_SEPARATOR)) {
                                componentProperties.attr.add(fieldDataName, fieldValueString);
                            } else if (StringUtils.isNotEmpty((CharSequence)fieldValueString) && fieldDataName.equals(FIELD_DATA_TAG_SEPARATOR)) {
                                if (!fieldValueString.contains(FIELD_DATA_TAG_SEPARATOR)) {
                                    if (!fieldValueString.contains("=")) {
                                        componentProperties.attr.add(fieldValueString, "true");
                                    } else {
                                        String[] items = fieldValueString.split("=");
                                        componentProperties.attr.add(items[0], StringUtils.substringBetween((String)items[1], (String)"\"", (String)"\""));
                                    }
                                } else {
                                    for (String item : fieldValueString.split(FIELD_DATA_TAG_SEPARATOR)) {
                                        if (!item.contains("=")) {
                                            componentProperties.attr.add(item, "true");
                                            continue;
                                        }
                                        String[] items = item.split("=");
                                        componentProperties.attr.add(items[0], StringUtils.substringBetween((String)items[1], (String)"\"", (String)"\""));
                                    }
                                }
                            }
                        }
                        if (fieldValueHasExpressions) {
                            ComponentField expField = new ComponentField(field);
                            expField.setValue(fieldValue);
                            componentProperties.expressionFields.add(expField);
                        }
                        try {
                            componentProperties.put(fieldName, fieldValue);
                        }
                        catch (Exception ex) {
                            LOGGER.error("error adding value. {}", (Throwable)ex);
                        }
                    }
                    ++n4;
                }
                break;
            }
        }
        catch (Exception ex) {
            LOGGER.error("getComponentProperties: error processing properties: component={}, ex.message={}, ex={}", new Object[]{component.getPath(), ex.getMessage(), ex});
            return componentProperties;
        }
    }

    public static ComponentProperties getTemplateConfig(Map<String, Object> pageContext, String configTag, ResourceResolver resourceResolver, TagManager tagManager, String fieldNameTemplates, String fieldNameFields, String fieldNameFirstTemplateName) {
        ComponentProperties componentProperties = ComponentsUtil.getNewComponentProperties(pageContext);
        if (StringUtils.isNotEmpty((CharSequence)configTag)) {
            Tag tagConfig = TagUtil.getTag(configTag, resourceResolver, tagManager);
            if (tagConfig != null) {
                ValueMap tagConfigVM;
                componentProperties.put(FIELD_VARIANT_LEGACY, false);
                Resource tagConfigRS = resourceResolver.getResource(tagConfig.getPath());
                if (tagConfigRS != null && (tagConfigVM = (ValueMap)tagConfigRS.adaptTo(ValueMap.class)) != null) {
                    if (tagConfigVM.containsKey((Object)FIELD_TAG_TEMPLATE_CONFIG_TEMPLATES)) {
                        String[] template = (String[])tagConfigVM.get(FIELD_TAG_TEMPLATE_CONFIG_TEMPLATES, (Object)new String[0]);
                        componentProperties.put(fieldNameTemplates, template);
                        if (template.length > 0) {
                            componentProperties.put(fieldNameFirstTemplateName, template[0]);
                        }
                    } else if (tagConfigVM.containsKey((Object)FIELD_TAG_TEMPLATE_CONFIG_VALUE)) {
                        String value = (String)tagConfigVM.get(FIELD_TAG_TEMPLATE_CONFIG_VALUE, (Object)"default");
                        componentProperties.put(fieldNameFirstTemplateName, value);
                    }
                    if (tagConfigVM.containsKey((Object)FIELD_TAG_TEMPLATE_CONFIG_FIELDS)) {
                        String[] fields = (String[])tagConfigVM.get(FIELD_TAG_TEMPLATE_CONFIG_FIELDS, (Object)new String[0]);
                        componentProperties.put(fieldNameFields, fields);
                    }
                }
            } else {
                componentProperties.put(FIELD_VARIANT_LEGACY, true);
            }
        }
        return componentProperties;
    }

    public static String getComponentVariantTemplate(Component component, String variantTemplate, SlingScriptHelper sling) {
        String variantTemplatePath;
        String variantTemplateDefault = MessageFormat.format(COMPONENT_VARIANT_TEMPLATE_FORMAT, "default");
        if (component != null && StringUtils.isNotEmpty((CharSequence)variantTemplate) && StringUtils.isNotBlank((CharSequence)(variantTemplatePath = ComponentsUtil.findLocalResourceInSuperComponent(component, variantTemplate, sling)))) {
            return variantTemplatePath;
        }
        return variantTemplateDefault;
    }

    public static String buildAttributesString(Map<String, String> data, XSSAPI xssAPI) {
        return ComponentsUtil.buildAttributesString(data, xssAPI, null);
    }

    public static String buildAttributesString(Map<String, String> data, XSSAPI xssAPI, Map<String, String> encodings) {
        try {
            StringWriter out = new StringWriter();
            for (Map.Entry<String, String> e : data.entrySet()) {
                String encoding;
                String key = e.getKey();
                String value = e.getValue();
                if (value == null) continue;
                if (encodings != null && (encoding = encodings.get(e.getKey())) != null && value.length() > 0) {
                    switch (encoding) {
                        case "HREF": {
                            value = xssAPI.getValidHref(value);
                            break;
                        }
                        case "HTML_ATTR": {
                            value = xssAPI.encodeForHTMLAttr(value);
                        }
                    }
                }
                out.append(FIELD_DATA_TAG_SEPARATOR);
                if (value.length() > 0) {
                    out.append(key).append("=\"").append(value).append("\"");
                    continue;
                }
                out.append(key);
            }
            return out.toString().replaceAll("&#x20;", FIELD_DATA_TAG_SEPARATOR);
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Deprecated
    public static String addComponentBackgroundToAttributes(ComponentProperties componentProperties, Resource resource, String imageResourceName) {
        Resource fileReference;
        String componentAttributes = (String)componentProperties.get(COMPONENT_ATTRIBUTES, "");
        Resource imageResource = resource.getChild(imageResourceName);
        if (imageResource != null && (fileReference = imageResource.getChild("fileReference")) != null) {
            String imageSrc = "";
            if (imageResource.getResourceType().equals(DEFAULT_IMAGE_RESOURCETYPE) || imageResource.getResourceType().endsWith(DEFAULT_IMAGE_RESOURCETYPE_SUFFIX)) {
                Long lastModified = CommonUtil.getLastModified(imageResource);
                imageSrc = MessageFormat.format(DEFAULT_IMAGE_GENERATED_FORMAT, imageResource.getPath(), lastModified.toString());
                componentAttributes = componentAttributes + MessageFormat.format(" style=\"background-image: url({0})\"", ResolverUtil.mappedUrl(resource.getResourceResolver(), imageSrc));
            }
        }
        return componentAttributes;
    }

    @Deprecated
    public static String addComponentAttributes(ComponentProperties componentProperties, Object[][] keyValue) {
        String componentAttributes = (String)componentProperties.get(COMPONENT_ATTRIBUTES, "");
        for (Object[] item : keyValue) {
            if (item.length < 1) continue;
            String attributeName = item[0].toString();
            String attrbuteValue = item[1].toString();
            componentAttributes = componentAttributes + MessageFormat.format(" {0}=\"{1}\"", attributeName, attrbuteValue);
        }
        return componentAttributes;
    }

    @Deprecated
    public static String addComponentAttributes(ComponentProperties componentProperties, String attributeName, String attrbuteValue) {
        return ComponentsUtil.addComponentAttributes(componentProperties, new Object[][]{{attributeName, attrbuteValue}});
    }

    public static String getPageDescription(Page page) {
        String pageDescription = page.getDescription();
        try {
            Resource pageResource = page.getContentResource();
            if (pageResource != null) {
                Node detailsNode;
                String[] listLookForDetailComponent = CommonUtil.DEFAULT_LIST_DETAILS_SUFFIX;
                String detailsPath = CommonUtil.findComponentInPage(page, listLookForDetailComponent);
                ResourceResolver resourceResolver = pageResource.getResourceResolver();
                Resource detailsResource = resourceResolver.resolve(detailsPath);
                if (!ResourceUtil.isNonExistingResource((Resource)detailsResource) && (detailsNode = (Node)detailsResource.adaptTo(Node.class)) != null && detailsNode.hasProperty(DETAILS_DESCRIPTION)) {
                    return detailsNode.getProperty(DETAILS_DESCRIPTION).getString();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("getPageDescription: {}", (Throwable)ex);
        }
        return pageDescription;
    }

    public static String compileComponentMessage(String formatFieldName, String defaultFormat, ComponentProperties componentProperties, SlingScriptHelper sling) {
        if (componentProperties == null || sling == null) {
            return "";
        }
        String formatFieldTagPath = (String)componentProperties.get(formatFieldName, "");
        String fieldFormatValue = defaultFormat;
        if (StringUtils.isNotEmpty((CharSequence)formatFieldTagPath)) {
            fieldFormatValue = TagUtil.getTagValueAsAdmin(formatFieldTagPath, sling);
        }
        return CommonUtil.compileMapMessage(fieldFormatValue, (Map<String, Object>)((Object)componentProperties));
    }

    public static String getComponentId(Node componentNode) {
        String componentId = UUID.randomUUID().toString();
        if (componentNode == null) {
            return componentId;
        }
        String path = "";
        try {
            path = componentNode.getPath();
            if (!componentNode.hasProperty(FIELD_STYLE_COMPONENT_ID)) {
                String prefix = componentNode.getName();
                prefix = prefix.replaceAll("[^a-zA-Z0-9-_]", JCR_NAME_SEPARATOR);
                componentNode.setProperty(FIELD_STYLE_COMPONENT_ID, MessageFormat.format("{0}_{1}", prefix, RandomStringUtils.randomAlphanumeric((int)9).toUpperCase()));
                componentNode.getSession().save();
            }
            componentId = CommonUtil.getProperty(componentNode, FIELD_STYLE_COMPONENT_ID);
        }
        catch (Exception ex) {
            LOGGER.error("Could not get id for component path={},id={},error {}", new Object[]{path, componentId, ex});
        }
        return componentId;
    }

    public static String getCloudConfigProperty(InheritanceValueMap pageProperties, String configurationName, String propertyName, SlingScriptHelper sling) {
        String returnValue = "";
        ContentAccess contentAccess = (ContentAccess)sling.getService(ContentAccess.class);
        if (contentAccess != null) {
            try (ResourceResolver adminResourceResolver = contentAccess.getAdminResourceResolver();){
                ConfigurationManager cfgMgr = (ConfigurationManager)adminResourceResolver.adaptTo(ConfigurationManager.class);
                Configuration addthisConfiguration = null;
                String[] services = (String[])pageProperties.getInherited("cq:cloudserviceconfigs", (Object)new String[0]);
                if (cfgMgr != null && (addthisConfiguration = cfgMgr.getConfiguration(configurationName, services)) != null) {
                    returnValue = (String)addthisConfiguration.get(propertyName, (Object)"");
                }
            }
            catch (Exception ex) {
                LOGGER.error(Throwables.getStackTraceAsString((Throwable)ex));
            }
        } else {
            LOGGER.error("getCloudConfigProperty: could not get ContentAccess service.");
        }
        return returnValue;
    }

    public static Resource findInheritedResource(Page page, ComponentContext componentContext) {
        String pageResourcePath = page.getContentResource().getPath();
        Resource thisResource = componentContext.getResource();
        String nodeResourceType = thisResource.getResourceType();
        String relativePath = thisResource.getPath().replaceFirst(pageResourcePath.concat("/"), "");
        Resource curResource = null;
        Boolean curResourceTypeMatch = false;
        Boolean curCancelInheritParent = false;
        ValueMap curProperties = null;
        try {
            for (Page curPage = page.getParent(); null != curPage; curPage = curPage.getParent()) {
                String error = MessageFormat.format("findInheritedResource: looking for inherited resource for path=\"{0}\" by relative path=\"{1}\" in parent=\"{2}\"", pageResourcePath, relativePath, curPage.getPath());
                LOGGER.info(error);
                try {
                    curResource = curPage.getContentResource(relativePath);
                }
                catch (Exception e) {
                    LOGGER.info("Failed to get {} from {}", (Object)relativePath, (Object)curPage.getContentResource().getPath());
                }
                if (null == curResource) continue;
                curProperties = (ValueMap)curResource.adaptTo(ValueMap.class);
                if (curProperties != null) {
                    curResourceTypeMatch = curResource.isResourceType(nodeResourceType);
                    curCancelInheritParent = ((String)curProperties.get(COMPONENT_CANCEL_INHERIT_PARENT, (Object)"")).contentEquals("true");
                    if (curResourceTypeMatch.booleanValue() && curCancelInheritParent.booleanValue()) {
                        String found = MessageFormat.format("findInheritedResource: FOUND looking for inherited resource for path=\"{0}\" by relative path=\"{1}\" in parent=\"{2}\"", pageResourcePath, relativePath, curPage.getPath());
                        LOGGER.info(found);
                        break;
                    }
                    String notfound = MessageFormat.format("findInheritedResource: NOT FOUND looking for inherited resource for path=\"{0}\" by relative path=\"{1}\" in parent=\"{2}\"", pageResourcePath, relativePath, curPage.getPath());
                    LOGGER.info(notfound);
                    continue;
                }
                LOGGER.error("findInheritedResource: could not convert resource to value map, curResource={}", (Object)curResource);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to find inherited resource. {}", (Throwable)ex);
        }
        return curResource;
    }

    public static String getFirstAttributeFromList(LinkedHashMap<String, Map> sourceMap, String attributeName) {
        Map firstItem;
        if (sourceMap != null && !sourceMap.values().isEmpty() && (firstItem = sourceMap.values().iterator().next()).containsKey(attributeName)) {
            return firstItem.get(attributeName).toString();
        }
        return "";
    }

    public static String getComponentInPagePath(Node componentNode) {
        String componentInPagePath = "";
        if (componentNode == null) {
            return "";
        }
        try {
            String[] parts;
            componentInPagePath = componentNode.getPath();
            if (StringUtils.isNotEmpty((CharSequence)componentInPagePath) && componentInPagePath.contains("jcr:content") && (parts = componentInPagePath.split("jcr:content")).length > 0 && StringUtils.isNotEmpty((CharSequence)(componentInPagePath = parts[1])) && componentInPagePath.startsWith("/")) {
                componentInPagePath = componentInPagePath.replaceFirst("/", "");
            }
        }
        catch (Exception ex) {
            LOGGER.warn("getComponentInPagePath: could not get component in path {}, ex: {}", (Object)componentNode, (Object)ex);
        }
        return componentInPagePath;
    }

    public static Map<String, Resource> getLocalSubResourcesInSuperComponent(Component component, String resourceName, SlingScriptHelper sling) {
        HashMap<String, Resource> subResources;
        block25: {
            subResources = new HashMap<String, Resource>();
            Component superComponent = null;
            if (component != null && StringUtils.isNotEmpty((CharSequence)resourceName)) {
                ContentAccess contentAccess = (ContentAccess)sling.getService(ContentAccess.class);
                if (contentAccess != null) {
                    try (ResourceResolver adminResourceResolver = contentAccess.getAdminResourceResolver();){
                        String componentPath = component.getPath();
                        Resource componentAdminResource = adminResourceResolver.resolve(componentPath);
                        if (!ResourceUtil.isNonExistingResource((Resource)componentAdminResource)) {
                            superComponent = (Component)componentAdminResource.adaptTo(Component.class);
                            if (superComponent != null) {
                                String name;
                                Resource localresource = superComponent.getLocalResource(resourceName);
                                if (localresource != null && !ResourceUtil.isNonExistingResource((Resource)localresource)) {
                                    for (Resource resource : localresource.getChildren()) {
                                        name = resource.getName().replace(".html", "");
                                        subResources.put(name, resource);
                                    }
                                }
                                while (superComponent.getSuperComponent() != null) {
                                    if ((superComponent = superComponent.getSuperComponent()) == null) {
                                        break block25;
                                    }
                                    localresource = superComponent.getLocalResource(resourceName);
                                    if (localresource == null || ResourceUtil.isNonExistingResource((Resource)localresource)) continue;
                                    for (Resource resource : localresource.getChildren()) {
                                        if (subResources.containsValue(resource.getName())) continue;
                                        name = resource.getName().replace(".html", "");
                                        subResources.put(name, resource);
                                    }
                                }
                                break block25;
                            }
                            LOGGER.error("getComponentSubResources: could not convert resource to component, componentAdminResource={}", (Object)componentAdminResource);
                            break block25;
                        }
                        LOGGER.error("getComponentSubResources: could not resolve component path to resource, componentPath={}", (Object)componentPath);
                    }
                    catch (Exception ex) {
                        LOGGER.error(Throwables.getStackTraceAsString((Throwable)ex));
                    }
                } else {
                    LOGGER.error("getComponentSubResources: could not get ContentAccess service.");
                }
            } else {
                LOGGER.error("getComponentSubResources: please specify component and sub resource: component={},resourceName={}", (Object)component, (Object)resourceName);
            }
        }
        return subResources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String findLocalResourceInSuperComponent(Component component, String resourceName, SlingScriptHelper sling) {
        Resource localresource;
        Component superComponent;
        block28: {
            superComponent = null;
            if (component == null) return "";
            ContentAccess contentAccess = (ContentAccess)sling.getService(ContentAccess.class);
            if (contentAccess == null) {
                LOGGER.error("findLocalResourceInSuperComponent: could not get ContentAccess service.");
                return "";
            }
            try (ResourceResolver adminResourceResolver = contentAccess.getAdminResourceResolver();){
                String componentPath = component.getPath();
                Resource componentAdminResource = adminResourceResolver.resolve(componentPath);
                if (!ResourceUtil.isNonExistingResource((Resource)componentAdminResource)) {
                    superComponent = (Component)componentAdminResource.adaptTo(Component.class);
                    if (superComponent == null) {
                        LOGGER.error("findLocalResourceInSuperComponent: could not convert resource to component, componentAdminResource={}", (Object)componentAdminResource);
                        return "";
                    }
                    localresource = superComponent.getLocalResource(resourceName);
                    if (localresource != null && !ResourceUtil.isNonExistingResource((Resource)localresource)) {
                        String string = localresource.getPath();
                        return string;
                    }
                    break block28;
                }
                LOGGER.error("findLocalResourceInSuperComponent: could not resolve component path to resource, componentPath={}", (Object)componentPath);
                return "";
            }
            catch (Exception ex) {
                LOGGER.error(Throwables.getStackTraceAsString((Throwable)ex));
                return "";
            }
        }
        do {
            if (superComponent.getSuperComponent() == null) return "";
            if ((superComponent = superComponent.getSuperComponent()) != null) continue;
            return "";
        } while ((localresource = superComponent.getLocalResource(resourceName)) == null || ResourceUtil.isNonExistingResource((Resource)localresource));
        return localresource.getPath();
    }

    public static Map<String, Object> getComponentFieldsAndDialogMap(Resource componentResource, ResourceResolver adminResourceResolver, SlingScriptHelper slingScriptHelper) {
        HashMap<String, Object> firstComponentConfig;
        block17: {
            firstComponentConfig = new HashMap<String, Object>();
            if (!ResourceUtil.isNonExistingResource((Resource)componentResource)) {
                ValueMap componentResourceMap = (ValueMap)componentResource.adaptTo(ValueMap.class);
                if (componentResourceMap != null) {
                    try {
                        ComponentManager componentManager = (ComponentManager)adminResourceResolver.adaptTo(ComponentManager.class);
                        Component componentOfResource = componentManager.getComponentOfResource(componentResource);
                        if (componentOfResource != null) {
                            ValueMap componentOfResourceValueMap = componentOfResource.getProperties();
                            String componentPath = componentOfResource.getPath();
                            Resource componentOfResourceRS = adminResourceResolver.resolve(componentPath);
                            String componentDialogPath = ComponentsUtil.findLocalResourceInSuperComponent(componentOfResource, "cq:dialog", slingScriptHelper);
                            String dialogPath = "";
                            Document dialogContent = null;
                            if (StringUtils.isNotEmpty((CharSequence)componentDialogPath)) {
                                dialogPath = componentDialogPath.concat(".html").concat(componentResource.getPath());
                                String dialogHTML = CommonUtil.resourceRenderAsHtml(dialogPath, adminResourceResolver, slingScriptHelper, WCMMode.DISABLED, null, null, false);
                                dialogContent = Jsoup.parse(dialogHTML);
                            }
                            for (Map.Entry field : componentResourceMap.entrySet()) {
                                String name = (String)field.getKey();
                                Object value = field.getValue();
                                HashMap<String, Object> row = new HashMap<String, Object>();
                                row.put(FIELD_TAG_TEMPLATE_CONFIG_VALUE, value);
                                row.put("fieldDescription", "");
                                row.put("fieldLabel", "");
                                row.put("type", "");
                                if (StringUtils.isNotEmpty((CharSequence)dialogPath) && dialogContent != null) {
                                    String fieldSelection = "[name='./" + name + "']";
                                    Element htmlSection = dialogContent.selectFirst(".coral-Form-fieldwrapper:has(" + fieldSelection + ")");
                                    Element fieldElement = dialogContent.selectFirst(fieldSelection);
                                    if (fieldElement != null) {
                                        Object[] classNames = fieldElement.classNames().toArray();
                                        if (classNames.length > 0) {
                                            row.put("type", classNames[classNames.length - 1]);
                                        } else {
                                            row.put("type", fieldElement.tagName());
                                        }
                                    }
                                    if (htmlSection != null) {
                                        Element fieldLabel = htmlSection.selectFirst(".coral-Form-fieldlabel");
                                        Element fieldDescription = htmlSection.selectFirst(".coral-Form-fieldinfo");
                                        Element fieldTooltip = htmlSection.selectFirst("coral-tooltip-content");
                                        if (fieldLabel != null) {
                                            String fieldLabelText = fieldLabel.text();
                                            row.put("fieldLabel", fieldLabelText);
                                        }
                                        String fieldDescriptionString = "";
                                        if (fieldDescription != null) {
                                            fieldDescriptionString = fieldDescription.attr("data-quicktip-content");
                                        }
                                        if (fieldTooltip != null) {
                                            fieldDescriptionString = fieldTooltip.text();
                                        }
                                        row.put("fieldDescription", fieldDescriptionString);
                                    }
                                }
                                firstComponentConfig.put(name, row);
                            }
                            break block17;
                        }
                        LOGGER.error("getComponentFieldsAndDialogMap: could not get component from resource - path={}", (Object)componentResource.getPath());
                    }
                    catch (Exception ex) {
                        LOGGER.error("getComponentFieldsAndDialogMap: ex={}", (Throwable)ex);
                    }
                } else {
                    LOGGER.error("getComponentFieldsAndDialogMap: could not get component values - path={}", (Object)componentResource.getPath());
                }
            } else {
                LOGGER.error("getComponentFieldsAndDialogMap: could not find component for resource - path={}", (Object)componentResource.getPath());
            }
        }
        return firstComponentConfig;
    }

    public static ValueMap getContentPolicyProperties(Resource componentResource, ResourceResolver resourceResolver) {
        ContentPolicy policy;
        ValueMapDecorator contentPolicyProperties = new ValueMapDecorator(new HashMap());
        ContentPolicyManager contentPolicyManager = (ContentPolicyManager)resourceResolver.adaptTo(ContentPolicyManager.class);
        if (contentPolicyManager != null && (policy = contentPolicyManager.getPolicy(componentResource)) != null) {
            contentPolicyProperties = policy.getProperties();
        }
        return contentPolicyProperties;
    }

    public static boolean isStringRegex(String value) {
        return ComponentsUtil.isStringRegex(value, STRING_EXPRESSION_CHECK);
    }

    public static boolean isStringRegex(String value, String patternToUse) {
        try {
            Pattern valueIsRegexPattern = Pattern.compile(patternToUse);
            return valueIsRegexPattern.matcher(value).matches();
        }
        catch (PatternSyntaxException ex) {
            LOGGER.error("isStringRegex: could not check if string is a regex, ex={}", (Throwable)ex);
            return false;
        }
    }

    public static Object evaluateExpressionWithValue(JxltEngine jxlt, JexlContext jc, String expression, Object value) {
        JxltEngine.Expression expr = jxlt.createExpression(expression);
        jc.set(FIELD_TAG_TEMPLATE_CONFIG_VALUE, value);
        return expr.evaluate(jc);
    }

    public static String removeRegexFromString(String value) {
        try {
            Pattern valueIsRegexPattern = Pattern.compile("(\\$\\{.*?\\})");
            return value.replaceAll(valueIsRegexPattern.pattern(), "");
        }
        catch (PatternSyntaxException ex) {
            LOGGER.error("removeRegexFromString: could not remove patterns from string, ex={}", (Throwable)ex);
            return value;
        }
    }

    public static String formattedRssDate(Calendar cal) {
        if (cal == null) {
            return null;
        }
        FastDateFormat dateFormat = FastDateFormat.getInstance((String)"EEE, dd MMM yyyy HH:mm:ss");
        return dateFormat.format(cal);
    }

    public static String formatDate(Calendar cal, String format) {
        if (cal == null || format == null) {
            return null;
        }
        FastDateFormat dateFormat = FastDateFormat.getInstance((String)format);
        return dateFormat.format(cal);
    }

    public static String getUniquePageIdentifier(Page listPage) {
        if (listPage != null) {
            String uniqueBase = listPage.getPath().substring(1).replace("/", "-");
            return CommonUtil.hashMd5(uniqueBase);
        }
        return "";
    }
}

