/*
 * Decompiled with CFR 0.152.
 */
package design.aem.utils.components;

import com.adobe.cq.sightly.WCMUsePojo;
import com.adobe.granite.asset.api.AssetManager;
import com.adobe.xmp.XMPDateTime;
import com.adobe.xmp.XMPDateTimeFactory;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.tagging.Tag;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.foundation.Image;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import design.aem.components.ComponentProperties;
import design.aem.services.ContentAccess;
import design.aem.utils.WidthBasedRenditionComparator;
import design.aem.utils.components.CommonUtil;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.ResolverUtil;
import java.net.URI;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImagesUtil.class);
    public static final String DEFAULT_IMAGE_THUMB_SELECTOR = ".thumb.319.319.png";
    public static final String SMALL_IMAGE_THUMB_SELECTOR = ".thumb.140.100.png";
    public static final String DEFAULT_THUMB_SELECTOR_XSM = ".thumb.140.140.png";
    public static final String DEFAULT_THUMB_SELECTOR_SM = ".thumb.319.319.png";
    public static final String DEFAULT_THUMB_SELECTOR_MD = ".thumb.800.800.png";
    public static final String DEFAULT_THUMB_SELECTOR_LG = ".thumb.1280.1280.png";
    public static final String FORM_CHOOSER_SELECTOR_SERVLET = ".form";
    public static final String DEFAULT_IMAGE_PATH = "/content/dam/aemdesign/common/placeholder.png";
    public static final String DEFAULT_IMAGE_PATH_RENDITION = "/content/dam/aemdesign/common/placeholder".concat(".thumb.319.319.png");
    public static final String SMALL_IMAGE_PATH_SELECTOR = "cq5dam.thumb.140.100.png";
    public static final String DEFAULT_IMAGE_PATH_SELECTOR = "cq5dam.thumb.319.319.png";
    public static final String DEFAULT_DOWNLOAD_THUMB_ICON = "/content/dam/aemdesign/common/download.png";
    public static final String MEDIUM_THUMBNAIL_SIZE = "320";
    public static final String LARGE_THUMBNAIL_SIZE = "480";
    public static final String DEFAULT_BACKGROUND_IMAGE_NODE_NAME = "bgimage";
    public static final String DEFAULT_BACKGROUND_VIDEO_NODE_NAME = "bgvideo";
    public static final String DEFAULT_SECONDARY_IMAGE_NODE_NAME = "secondaryImage";
    public static final String DEFAULT_THUMBNAIL_IMAGE_NODE_NAME = "thumbnail";
    public static final String DEFAULT_BADGETHUMBNAIL_IMAGE_NODE_NAME = "badgeThumbnail";
    public static final String DEFAULT_IMAGE_NODE_NAME = "image";
    public static final String FIELD_RENDITIONS_VIDEO = "renditionsVideo";
    public static final String RENDITION_PROFILE_CUSTOM = "cq5dam.custom.";
    public static final String RENDITION_REGEX_PATTERN = "^(\\w*)\\.(\\w*)\\.(\\d*)\\.(\\d*)\\.(\\S{3,4})$";
    public static final String OSGI_CONFIG_MEDIA_IMAGE = "aemdesign.components.media.image";
    public static final String FIELD_RENDITION_PREFIX = "renditionPrefix";
    public static final String FIELD_RESPONSIVE_MAP = "renditionImageMapping";
    public static final String FIELD_ADAPTIVE_MAP = "adaptiveImageMapping";
    public static final String FIELD_MEDIAQUERYRENDITION_KEY = "assetMediaQuery";
    public static final String FIELD_MEDIAQUERYRENDITION_VALUE = "assetMediaQueryRendition";
    public static final String FIELD_IMAGE_OPTION = "imageOption";
    public static final String ASSET_METADATA_FOLDER = "jcr:content".concat("/").concat("metadata");
    public static final String[] DEFAULT_RENDITION_IMAGE_MAP = new String[]{"48=(min-width: 1px) and (max-width: 72px)", "140=(min-width: 73px) and (max-width: 210px)", "319=(min-width: 211px) and (max-width: 478px)", "1280=(min-width: 478px)"};
    public static final String[] DEFAULT_ADAPTIVE_IMAGE_MAP = new String[]{"480=(min-width: 1px) and (max-width: 533px)", "640=(min-width: 534px) and (max-width: 691px)", "720=(min-width: 692px) and (max-width: 770px)", "800=(min-width: 771px) and (max-width: 848px)", "960=(min-width: 849px) and (max-width: 1008px)", "1024=(min-width: 1009px) and (max-width: 1075px)", "1280=(min-width: 1076px) and (max-width: 1331px)", "1440=(min-width: 1332px) and (max-width: 1572px)", "1920=(min-width: 1573px) and (max-width: 1971px)", "2048=(min-width: 1971px)"};
    public static final Object[][] DEFAULT_FIELDS_IMAGE_OPTIONS = new Object[][]{{"imageOption", "responsive"}, {"htmlWidth", ""}, {"htmlHeight", ""}, {"width", 0}, {"height", 0}, {"fileReference", ""}, {"adaptiveImageMapping", DEFAULT_ADAPTIVE_IMAGE_MAP}, {"renditionImageMapping", DEFAULT_RENDITION_IMAGE_MAP}, {"renditionPrefix", ""}, {"assetMediaQuery", new String[0], "", Tag.class.getCanonicalName()}, {"assetMediaQueryRendition", new String[0]}};
    public static final Object[][] DEFAULT_FIELDS_BACKGROUNDVIDEO_OPTIONS = new Object[][]{{"fileReference", ""}};

    public static String getMetadataStringForKey(Node assetNode, String key, String defaultValue) {
        if (assetNode == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        String returnVal = "";
        try {
            if (assetNode.hasNode(ASSET_METADATA_FOLDER)) {
                Node metadataNode = assetNode.getNode(ASSET_METADATA_FOLDER);
                returnVal = DamUtil.getValue((Node)metadataNode, (String)key, (String)defaultValue);
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return returnVal;
    }

    public static String getMetadataStringForKey(com.adobe.granite.asset.api.Asset asset, String key) {
        if (asset == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        Object metadataObj = null;
        Node node = (Node)asset.adaptTo(Node.class);
        try {
            ValueMap map;
            Resource metadataRes;
            if (node != null && (metadataRes = asset.getResourceResolver().getResource(node.getPath().concat("/").concat(ASSET_METADATA_FOLDER))) != null && (map = (ValueMap)metadataRes.adaptTo(ValueMap.class)) != null && map.containsKey((Object)key)) {
                metadataObj = map.get((Object)key).toString();
            }
        }
        catch (Exception ex) {
            LOGGER.error("getMetadataStringForKey: {}", (Throwable)ex);
        }
        if (metadataObj == null) {
            return null;
        }
        if (metadataObj.getClass().isArray()) {
            return ((Object[])metadataObj)[0].toString();
        }
        return metadataObj.toString();
    }

    public static String getMetadataStringForKey(Asset asset, String key) {
        if (asset == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        Object metadataObj = asset.getMetadata(key);
        if (metadataObj == null) {
            return null;
        }
        if (metadataObj.getClass().isArray()) {
            return ((Object[])metadataObj)[0].toString();
        }
        return metadataObj.toString();
    }

    public static Rendition getThumbnail(Asset asset, int minWidth) {
        if (asset == null) {
            return null;
        }
        try {
            return DamUtil.getBestFitRendition((int)minWidth, (List)asset.getRenditions());
        }
        catch (Exception ex) {
            LOGGER.error("getThumbnail: {}", (Throwable)ex);
            return null;
        }
    }

    public static String getThumbnailUrl(Page page, ResourceResolver resourceResolver) {
        return resourceResolver.map(page.getPath().concat(DEFAULT_THUMB_SELECTOR_MD));
    }

    public static int getWidth(Node assetNode) throws RepositoryException {
        int width = 0;
        if (assetNode.hasNode(ASSET_METADATA_FOLDER)) {
            Node metadataNode = assetNode.getNode(ASSET_METADATA_FOLDER);
            try {
                width = Integer.valueOf(DamUtil.getValue((Node)metadataNode, (String)"tiff:ImageWidth", (String)DamUtil.getValue((Node)metadataNode, (String)"exif:PixelXDimension", (String)"")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return width;
    }

    public static Image getProcessedImage(Resource resource, String relativePath) {
        Image image = null;
        image = relativePath != null ? new Image(resource, relativePath) : new Image(resource);
        image.setSelector(".img");
        return image;
    }

    @Deprecated
    public static Image getScaledProcessedImage(Resource resource, String relativePath, int maxWidth) {
        Image image = ImagesUtil.getProcessedImage(resource, relativePath);
        image.setSelector(".scale.thumbnail." + maxWidth);
        return image;
    }

    public static String getResourceImageCustomHref(Resource resource, String imageResourceName) {
        Resource fileReference;
        String imageSrc = "";
        if (resource == null || StringUtils.isEmpty((CharSequence)imageResourceName)) {
            return imageSrc;
        }
        Resource imageResource = resource.getChild(imageResourceName);
        if (imageResource != null && (fileReference = imageResource.getChild("fileReference")) != null && (imageResource.getResourceType().equals("aemdesign/components/media/image") || imageResource.getResourceType().endsWith("/components/media/image"))) {
            Long lastModified = CommonUtil.getLastModified(imageResource);
            imageSrc = MessageFormat.format("{0}.img.jpeg/{1}.jpeg", imageResource.getPath(), lastModified.toString());
            imageSrc = ResolverUtil.mappedUrl(resource.getResourceResolver(), imageSrc);
        }
        return imageSrc;
    }

    public static String getPageImgReferencePath(Page page) {
        String imagePath = ImagesUtil.getResourceImagePath(page.getContentResource(), DEFAULT_IMAGE_NODE_NAME);
        if (StringUtils.isEmpty((CharSequence)imagePath)) {
            imagePath = page.getPath().concat(".thumb.319.319.png");
        }
        return imagePath;
    }

    public static String getResourceImagePath(Resource resource, String imageResourceName) {
        String fileReferencPath = "";
        if (resource == null || StringUtils.isEmpty((CharSequence)imageResourceName)) {
            return fileReferencPath;
        }
        try {
            Node fileReferenceNode;
            Resource fileReference = resource.getChild(imageResourceName);
            if (fileReference != null && (fileReferenceNode = (Node)fileReference.adaptTo(Node.class)) != null && fileReferenceNode.hasProperty("fileReference")) {
                fileReferencPath = fileReferenceNode.getProperty("fileReference").getString();
            }
        }
        catch (Exception ex) {
            LOGGER.error("getResourceImagePath: Exception occurred: {}", (Throwable)ex);
        }
        return fileReferencPath;
    }

    public static String getAssetPropertyValueWithDefault(Asset asset, String name, String defaultValue) {
        if (asset == null) {
            return defaultValue;
        }
        try {
            String assetValue = asset.getMetadataValue(name);
            if (StringUtils.isNotEmpty((CharSequence)assetValue)) {
                return assetValue;
            }
        }
        catch (Exception ex) {
            LOGGER.error("getAssetPropertyValueWithDefault: Exception occurred: {}", (Throwable)ex);
        }
        return defaultValue;
    }

    public static String getAssetCopyrightInfo(Asset asset, String format) {
        String copyrightInfo = "";
        if (asset == null) {
            return copyrightInfo;
        }
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = "\u00a9 {4} {0} {1} {2} {3}";
        }
        try {
            String values;
            String assetCreator = ImagesUtil.getAssetPropertyValueWithDefault(asset, "dc:creator", "");
            String assetContributor = ImagesUtil.getAssetPropertyValueWithDefault(asset, "dc:contributor", "");
            String assetLicense = ImagesUtil.getAssetPropertyValueWithDefault(asset, "dc:rights", "");
            String assetCopyrightOwner = ImagesUtil.getAssetPropertyValueWithDefault(asset, "xmpRights:Owner", "");
            String assetUsageTerms = asset.getMetadataValue("xmpRights:UsageTerms");
            String assetExpiresYear = "";
            String assetExpires = asset.getMetadataValue("prism:expirationDate");
            if (assetExpires != null) {
                XMPDateTime assetExpiresDate = XMPDateTimeFactory.createFromISO8601((String)assetExpires);
                assetExpiresYear = Integer.toString(assetExpiresDate.getCalendar().get(1));
            }
            if (StringUtils.isNotEmpty((CharSequence)(values = StringUtils.join((Object[])new String[]{assetCreator, assetContributor, assetLicense, assetCopyrightOwner, assetExpiresYear}).trim()))) {
                copyrightInfo = MessageFormat.format(format, assetCreator, assetContributor, assetLicense, assetCopyrightOwner, assetExpiresYear);
            }
        }
        catch (Exception ex) {
            LOGGER.error("getAssetCopyrightInfo: Exception occurred: {}", (Throwable)ex);
        }
        return copyrightInfo;
    }

    public static int getWidth(com.adobe.granite.asset.api.Rendition r) {
        return ImagesUtil.getDimension(r, "tiff:ImageWidth");
    }

    public static int getDimension(com.adobe.granite.asset.api.Rendition r, String dimensionProperty) {
        if (r == null) {
            LOGGER.debug("Null rendition at", (Throwable)new Exception("Null rendition"));
            return 0;
        }
        if (dimensionProperty == null || !dimensionProperty.equals("tiff:ImageLength") && !dimensionProperty.equals("tiff:ImageWidth")) {
            LOGGER.warn("Incorrect dimension property for {}, Invalid property name {}", (Object)r.getPath(), (Object)dimensionProperty);
            return 0;
        }
        String name = r.getName();
        if (StringUtils.isEmpty((CharSequence)name)) {
            LOGGER.warn("Empty name returned at {}", (Object)r.getPath());
            return 0;
        }
        try {
            if (name.equals("original")) {
                Node assetMetadata;
                com.adobe.granite.asset.api.Asset asset = (com.adobe.granite.asset.api.Asset)r.adaptTo(com.adobe.granite.asset.api.Asset.class);
                if (asset == null) {
                    LOGGER.debug("Rendition at {} is not adaptable to an asset.", (Object)r.getPath());
                    return 0;
                }
                String val = null;
                Node assetNode = (Node)asset.adaptTo(Node.class);
                if (assetNode != null && !assetNode.hasNode("jcr:content".concat("/").concat("metadata")) && (assetMetadata = assetNode.getNode("jcr:content".concat("/").concat("metadata"))).hasProperty(dimensionProperty)) {
                    val = assetMetadata.getProperty(dimensionProperty).getString();
                }
                if (val == null || val.length() == 0) {
                    LOGGER.debug("Unable to find metadata property {} for {}", (Object)dimensionProperty, (Object)asset.getPath());
                    return 0;
                }
                try {
                    return Integer.parseInt(val);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warn("Metadata property {} was {} and not a number at {}", new Object[]{dimensionProperty, val, asset.getPath()});
                    return 0;
                }
            }
            Matcher matcher = ComponentsUtil.DEFAULT_RENDTION_PATTERN_OOTB.matcher(name);
            if (matcher.matches()) {
                int matcherIndex = "tiff:ImageLength".equals(dimensionProperty) ? 3 : 2;
                return Integer.parseInt(matcher.group(matcherIndex));
            }
            LOGGER.debug("Unknown naming format for name {} at {}", (Object)name, (Object)r.getPath());
            return 0;
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected exception finding dimension for asset at {}, {}", (Object)r.getPath(), (Object)e);
            return 0;
        }
    }

    public static String getBestFitRendition(String assetPath, int renditionWidth, ResourceResolver resourceResolver) {
        String renditionPath = assetPath;
        if (StringUtils.isEmpty((CharSequence)assetPath)) {
            return "";
        }
        try {
            AssetManager assetManager = (AssetManager)resourceResolver.adaptTo(AssetManager.class);
            if (assetManager != null) {
                com.adobe.granite.asset.api.Rendition bestRendition;
                com.adobe.granite.asset.api.Asset asset = assetManager.getAsset(assetPath);
                if (asset != null && (bestRendition = ImagesUtil.getBestFitRendition(renditionWidth, asset)) != null) {
                    renditionPath = bestRendition.getPath();
                }
            } else {
                LOGGER.error("getBestFitRendition: could not get AssetManager object");
            }
        }
        catch (Exception ex) {
            LOGGER.error("getBestFitRendition error {} ", (Throwable)ex);
        }
        return renditionPath;
    }

    public static com.adobe.granite.asset.api.Rendition getBestFitRendition(int width, com.adobe.granite.asset.api.Asset asset) {
        ArrayList renditions = Lists.newArrayList((Iterator)asset.listRenditions());
        return ImagesUtil.getBestFitRendition(width, renditions, null);
    }

    public static com.adobe.granite.asset.api.Rendition getBestFitRendition(int width, com.adobe.granite.asset.api.Asset asset, String renditionPrefix) {
        ArrayList renditions = Lists.newArrayList((Iterator)asset.listRenditions());
        return ImagesUtil.getBestFitRendition(width, renditions, renditionPrefix);
    }

    public static com.adobe.granite.asset.api.Rendition getBestFitRendition(int width, List<com.adobe.granite.asset.api.Rendition> renditions, String renditionPrefix) {
        com.adobe.granite.asset.api.Rendition bestFitRendition = null;
        if (renditionPrefix != null) {
            bestFitRendition = ImagesUtil.getRenditionByPrefix(renditions.iterator(), renditionPrefix + width);
        }
        if (bestFitRendition == null && (bestFitRendition = ImagesUtil.getRenditionByPrefix(renditions.iterator(), "cq5dam.thumbnail." + width)) == null) {
            bestFitRendition = ImagesUtil.getRenditionByPrefix(renditions.iterator(), "cq5dam.web." + width);
        }
        if (bestFitRendition != null) {
            return bestFitRendition;
        }
        WidthBasedRenditionComparator comp = new WidthBasedRenditionComparator();
        Collections.sort(renditions, comp);
        Iterator<com.adobe.granite.asset.api.Rendition> itr = renditions.iterator();
        com.adobe.granite.asset.api.Rendition bestFit = null;
        Object original = null;
        while (itr.hasNext()) {
            int w;
            com.adobe.granite.asset.api.Rendition rend = itr.next();
            if (!ImagesUtil.canRenderOnWeb(rend.getMimeType()) || (w = ImagesUtil.getWidth(rend)) < width) continue;
            bestFit = rend;
            if (!(renditionPrefix != null ? rend.getName().startsWith(renditionPrefix) : rend.getName().startsWith("cq5dam.thumbnail.") || rend.getName().startsWith("cq5dam.web."))) continue;
            break;
        }
        if (bestFit == null) {
            for (com.adobe.granite.asset.api.Rendition rend : renditions) {
                if (!ImagesUtil.canRenderOnWeb(rend.getMimeType())) continue;
                bestFit = rend;
                break;
            }
        }
        return bestFit;
    }

    public static boolean canRenderOnWeb(String mimeType) {
        return mimeType != null && (mimeType.toLowerCase().contains("jpeg") || mimeType.toLowerCase().contains("jpg") || mimeType.toLowerCase().contains("gif") || mimeType.toLowerCase().contains("png"));
    }

    public static com.adobe.granite.asset.api.Rendition getRenditionByPrefix(Iterator<com.adobe.granite.asset.api.Rendition> renditions, String prefix) {
        return ImagesUtil.getRenditionByPrefix(renditions, prefix, false);
    }

    public static com.adobe.granite.asset.api.Rendition getRenditionByPrefix(Iterator<com.adobe.granite.asset.api.Rendition> renditions, String prefix, boolean returnOriginal) {
        com.adobe.granite.asset.api.Rendition original = null;
        while (renditions.hasNext()) {
            com.adobe.granite.asset.api.Rendition rendition = renditions.next();
            if ("original".equals(rendition.getName())) {
                original = rendition;
            }
            if (!rendition.getName().startsWith(prefix)) continue;
            return rendition;
        }
        if (returnOriginal) {
            return original;
        }
        return null;
    }

    public static Map<String, String> getAssetInfo(ResourceResolver resourceResolver, String assetPath, String infoPrefix, String defaultPath) {
        Map<String, String> assetInfo = ImagesUtil.getAssetInfo(resourceResolver, assetPath, infoPrefix);
        if (assetInfo.size() == 0) {
            assetInfo.put(infoPrefix, defaultPath);
        }
        return assetInfo;
    }

    public static Map<String, String> getAssetInfo(ResourceResolver resourceResolver, String assetPath, String infoPrefix) {
        if (StringUtils.isEmpty((CharSequence)infoPrefix)) {
            infoPrefix = DEFAULT_IMAGE_NODE_NAME;
        }
        HashMap<String, String> assetInfo = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)assetPath)) {
            Asset pageImageAsset;
            assetInfo.put(infoPrefix, assetPath);
            Resource pageImageResource = resourceResolver.resolve(assetPath);
            if (!ResourceUtil.isNonExistingResource((Resource)pageImageResource) && (pageImageAsset = (Asset)pageImageResource.adaptTo(Asset.class)) != null) {
                assetInfo.put(infoPrefix + "LicenseInfo", ImagesUtil.getAssetCopyrightInfo(pageImageAsset, "\u00a9 {4} {0} {1} {2} {3}"));
                assetInfo.put(infoPrefix + "Title", ImagesUtil.getAssetPropertyValueWithDefault(pageImageAsset, "dc:title", ""));
                assetInfo.put(infoPrefix + "Description", ImagesUtil.getAssetPropertyValueWithDefault(pageImageAsset, "dc:description", ""));
                try {
                    Node pageImageResourceNode = (Node)pageImageResource.adaptTo(Node.class);
                    if (pageImageResourceNode != null && pageImageResourceNode.hasProperty("jcr:uuid")) {
                        assetInfo.put(infoPrefix + "Id", pageImageResourceNode.getProperty("jcr:uuid").getString());
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("getAssetInfo: could not get assetID {}", (Throwable)ex);
                }
            }
        }
        return assetInfo;
    }

    public static TreeMap<String, String> getAssetRenditionsVideo(com.adobe.granite.asset.api.Asset asset) {
        TreeMap<String, String> renditionsSet = new TreeMap<String, String>();
        if (asset != null) {
            Iterator renditions = asset.listRenditions();
            while (renditions.hasNext()) {
                com.adobe.granite.asset.api.Rendition rendition = (com.adobe.granite.asset.api.Rendition)renditions.next();
                if (rendition == null || !rendition.getName().contains(".video.") && !rendition.getName().equals("original")) continue;
                renditionsSet.put(rendition.getPath(), rendition.getMimeType());
            }
        }
        return renditionsSet;
    }

    public static ComponentProperties getBackgroundVideoRenditions(WCMUsePojo wcmUsePojoModel) {
        try {
            return ImagesUtil.getBackgroundVideoRenditions(ComponentsUtil.getContextObjects(wcmUsePojoModel));
        }
        catch (Exception ex) {
            LOGGER.error("getBackgroundImageRenditions(WCMUsePojo) could not read required objects={}, error={}", (Object)wcmUsePojoModel, (Object)ex);
            return ComponentsUtil.getNewComponentProperties(wcmUsePojoModel);
        }
    }

    public static ComponentProperties getBackgroundVideoRenditions(PageContext pageContext) {
        try {
            return ImagesUtil.getBackgroundVideoRenditions(ComponentsUtil.getContextObjects(pageContext));
        }
        catch (Exception ex) {
            LOGGER.error("getBackgroundImageRenditions(PageContext) could not read required objects", (Throwable)ex);
            return ComponentsUtil.getNewComponentProperties(pageContext);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ComponentProperties getBackgroundVideoRenditions(Map<String, Object> pageContext) {
        Resource resource = (Resource)pageContext.get("resource");
        SlingScriptHelper sling = (SlingScriptHelper)pageContext.get("sling");
        ContentAccess contentAccess = (ContentAccess)sling.getService(ContentAccess.class);
        if (contentAccess == null) {
            LOGGER.error("getBackgroundVideoRenditions: could not get ContentAccess service.");
            return null;
        }
        try (ResourceResolver resourceResolver = contentAccess.getAdminResourceResolver();){
            Resource backgroundResource = resourceResolver.getResource(resource, DEFAULT_BACKGROUND_VIDEO_NODE_NAME);
            if (backgroundResource == null) return null;
            ComponentProperties imageProperties = ComponentsUtil.getComponentProperties(pageContext, (Object)backgroundResource, (Boolean)false, (Object[][][])new Object[][][]{DEFAULT_FIELDS_BACKGROUNDVIDEO_OPTIONS});
            String fileReference = (String)imageProperties.get("fileReference", "");
            Resource assetR = resourceResolver.resolve(fileReference);
            if (!ResourceUtil.isNonExistingResource((Resource)assetR)) {
                AssetManager assetManager = (AssetManager)resourceResolver.adaptTo(AssetManager.class);
                if (assetManager != null) {
                    com.adobe.granite.asset.api.Asset videoAsset = assetManager.getAsset(fileReference);
                    if (videoAsset != null) {
                        imageProperties.putAll(ImagesUtil.getAssetInfo(resourceResolver, fileReference, "backgroundVideo"));
                        imageProperties.put(FIELD_RENDITIONS_VIDEO, ImagesUtil.getAssetRenditionsVideo(videoAsset));
                    }
                } else {
                    LOGGER.error("getBackgroundVideoRenditions: could not get AssetManager object");
                }
            }
            ComponentProperties componentProperties = imageProperties;
            return componentProperties;
        }
        catch (Exception ex) {
            LOGGER.error(Throwables.getStackTraceAsString((Throwable)ex));
            return null;
        }
    }

    public static ComponentProperties getBackgroundImageRenditions(WCMUsePojo wcmUsePojoModel) {
        try {
            return ImagesUtil.getBackgroundImageRenditions(ComponentsUtil.getContextObjects(wcmUsePojoModel));
        }
        catch (Exception ex) {
            LOGGER.error("getBackgroundImageRenditions(WCMUsePojo) could not read required objects={}, error={}", (Object)wcmUsePojoModel, (Object)ex);
            return ComponentsUtil.getNewComponentProperties(wcmUsePojoModel);
        }
    }

    public static ComponentProperties getBackgroundImageRenditions(PageContext pageContext) {
        try {
            return ImagesUtil.getBackgroundImageRenditions(ComponentsUtil.getContextObjects(pageContext));
        }
        catch (Exception ex) {
            LOGGER.error("getBackgroundImageRenditions(PageContext) could not read required objects", (Throwable)ex);
            return ComponentsUtil.getNewComponentProperties(pageContext);
        }
    }

    public static ComponentProperties getBackgroundImageRenditions(Map<String, Object> pageContext) {
        Resource resource = (Resource)pageContext.get("resource");
        Resource backgroundResource = resource.getChild(DEFAULT_BACKGROUND_IMAGE_NODE_NAME);
        return ImagesUtil.getResourceImageRenditions(pageContext, backgroundResource, "componentBackgroundAssets", "backgroundImage");
    }

    public static ComponentProperties getResourceImageRenditions(WCMUsePojo wcmUsePojoModel, Resource resource, String attributeName, String returnLastRenditionName) {
        try {
            return ImagesUtil.getResourceImageRenditions(ComponentsUtil.getContextObjects(wcmUsePojoModel), resource, attributeName, returnLastRenditionName);
        }
        catch (Exception ex) {
            LOGGER.error("getBackgroundImageRenditions(WCMUsePojo) could not read required objects={}, error={}", (Object)wcmUsePojoModel, (Object)ex);
            return ComponentsUtil.getNewComponentProperties(wcmUsePojoModel);
        }
    }

    public static ComponentProperties getResourceImageRenditions(PageContext pageContext, Resource resource, String attributeName, String returnLastRenditionName) {
        try {
            return ImagesUtil.getResourceImageRenditions(ComponentsUtil.getContextObjects(pageContext), resource, attributeName, returnLastRenditionName);
        }
        catch (Exception ex) {
            LOGGER.error("getBackgroundImageRenditions(pageContext) could not read required objects", (Throwable)ex);
            return ComponentsUtil.getNewComponentProperties(pageContext);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ComponentProperties getResourceImageRenditions(Map<String, Object> pageContext, Resource imageResource, String returnRenditionsListName, String returnLastRenditionName) {
        SlingScriptHelper sling = (SlingScriptHelper)pageContext.get("sling");
        ContentAccess contentAccess = (ContentAccess)sling.getService(ContentAccess.class);
        if (contentAccess == null) {
            LOGGER.error("getResourceImageRenditions: could not get ContentAccess service.");
            return ComponentsUtil.getNewComponentProperties(pageContext);
        }
        try (ResourceResolver resourceResolver = contentAccess.getAdminResourceResolver();){
            ComponentProperties imageProperties;
            block24: {
                block25: {
                    if (StringUtils.isEmpty((CharSequence)returnRenditionsListName)) {
                        returnRenditionsListName = "images";
                    }
                    if (imageResource == null) return ComponentsUtil.getNewComponentProperties(pageContext);
                    imageProperties = ComponentsUtil.getComponentProperties(pageContext, (Object)imageResource, (Boolean)false, (Object[][][])new Object[][][]{DEFAULT_FIELDS_IMAGE_OPTIONS});
                    String fileReference = (String)imageProperties.get("fileReference", "");
                    Resource assetR = resourceResolver.resolve(fileReference);
                    if (ResourceUtil.isNonExistingResource((Resource)assetR)) break block24;
                    AssetManager assetManager = (AssetManager)resourceResolver.adaptTo(AssetManager.class);
                    if (assetManager == null) break block25;
                    com.adobe.granite.asset.api.Asset asset = assetManager.getAsset(fileReference);
                    if (asset != null) {
                        try {
                            String imageOption = (String)imageProperties.get(FIELD_IMAGE_OPTION, "");
                            Map<Object, Object> responsiveImageSet = new LinkedHashMap();
                            if (fileReference.endsWith(".svg") || fileReference.endsWith(".gif")) {
                                imageProperties.put(returnLastRenditionName, fileReference);
                                imageProperties.put(FIELD_IMAGE_OPTION, "simple");
                            } else {
                                responsiveImageSet = ImagesUtil.getImageSetForImageOptions(imageOption, asset, imageProperties, assetR, resourceResolver, sling);
                            }
                            imageProperties.put(returnRenditionsListName, responsiveImageSet);
                            if (responsiveImageSet.values().size() > 0) {
                                imageProperties.put(returnLastRenditionName, responsiveImageSet.values().toArray()[responsiveImageSet.values().size() - 1]);
                            }
                            break block24;
                        }
                        catch (Exception ex) {
                            LOGGER.error("failed to create Width and Image Mapping: {}", (Throwable)ex);
                        }
                    }
                    break block24;
                }
                LOGGER.error("getResourceImageRenditions: could not get AssetManager object");
            }
            ComponentProperties componentProperties = imageProperties;
            return componentProperties;
        }
        catch (Exception ex) {
            LOGGER.error(Throwables.getStackTraceAsString((Throwable)ex));
            return ComponentsUtil.getNewComponentProperties(pageContext);
        }
    }

    public static Map<String, String> getBestFitMediaQueryRenditionSet(com.adobe.granite.asset.api.Asset asset, String[] renditionImageMapping, String renditionPrefix) {
        LinkedHashMap<String, String> profileRendtiions = new LinkedHashMap<String, String>();
        if (asset != null && renditionImageMapping != null) {
            for (String entry : renditionImageMapping) {
                String[] entryArray = StringUtils.split((String)entry, (String)"=");
                if (entryArray == null || entryArray.length != 2) {
                    LOGGER.error("getBestFitMediaQueryRenditionSet [{}] is invalid", (Object)entry);
                    continue;
                }
                String minWidth = entryArray[0];
                if (StringUtils.isEmpty((CharSequence)minWidth) || !NumberUtils.isDigits((String)minWidth)) {
                    LOGGER.error("getBestFitMediaQueryRenditionSet [{}] is invalid, incorrect width [{}]", (Object)entry, (Object)minWidth);
                    continue;
                }
                String mediaQuery = entryArray[1];
                com.adobe.granite.asset.api.Rendition rendition = ImagesUtil.getBestFitRendition(CommonUtil.tryParseInt(minWidth, 0), asset, (String)StringUtils.defaultIfEmpty((CharSequence)renditionPrefix, null));
                String renditionPath = rendition.getPath();
                if (renditionPath.endsWith("/original")) {
                    Resource assetPathResource;
                    String assetPath = renditionPath.substring(0, renditionPath.indexOf("jcr:content") - 1);
                    ResourceResolver resourceResolver = asset.getResourceResolver();
                    if (resourceResolver != null && !ResourceUtil.isNonExistingResource((Resource)(assetPathResource = resourceResolver.resolve(assetPath)))) {
                        renditionPath = assetPath;
                    }
                }
                profileRendtiions.put(mediaQuery, renditionPath);
            }
        }
        return profileRendtiions;
    }

    public static Map<String, String> getAdaptiveImageSet(String[] adaptiveImageMapping, ResourceResolver resolver, String componentPath, String fileReference, String outputFormat, Boolean useFileReferencePathAsRender, SlingScriptHelper sling) {
        LinkedHashMap<String, String> responsiveImageSet = new LinkedHashMap<String, String>();
        URI fileReferenceURI = URI.create(fileReference);
        if (StringUtils.isBlank((CharSequence)outputFormat)) {
            String extension = fileReferenceURI.getPath();
            outputFormat = extension.substring(extension.lastIndexOf("."));
        }
        String suffix = StringUtils.defaultString((String)fileReferenceURI.getQuery(), (String)"");
        String renderPath = componentPath;
        if (useFileReferencePathAsRender.booleanValue()) {
            renderPath = fileReference;
        }
        int[] allowedSizes = ImagesUtil.getAdaptiveImageSupportedWidths(sling);
        for (String entry : adaptiveImageMapping) {
            String[] entryArray = StringUtils.split((String)entry, (String)"=");
            if (entryArray == null || entryArray.length != 2) {
                LOGGER.error("getAdaptiveImageSet [{}] is invalid", (Object)entry);
                continue;
            }
            String adaptiveProfile = entryArray[0];
            if (StringUtils.isEmpty((CharSequence)adaptiveProfile) && !adaptiveProfile.contains(".")) {
                LOGGER.error("getAdaptiveImageSet [{}] is invalid, incorrect profile format [{}] expecting {width}.{quality}.{format}", (Object)entry, (Object)adaptiveProfile);
                continue;
            }
            String mediaQuery = entryArray[1];
            String[] adaptiveProfileArray = StringUtils.split((String)adaptiveProfile, (String)".");
            Integer profileWidth = CommonUtil.tryParseInt(adaptiveProfileArray[0], 0);
            String profileOutputFormat = outputFormat;
            if (adaptiveProfileArray.length == 3) {
                profileOutputFormat = "";
            }
            if (adaptiveProfile.equals("full") || ArrayUtils.contains((int[])allowedSizes, (int)profileWidth)) {
                responsiveImageSet.put(mediaQuery, MessageFormat.format("{0}.img.{1}{2}{3}", renderPath, adaptiveProfile, profileOutputFormat, suffix));
                continue;
            }
            LOGGER.error("getAdaptiveImageSet rendition selected size is not allowed [{}], [{}]", (Object)profileWidth, (Object)entry);
        }
        return responsiveImageSet;
    }

    public static int[] getAdaptiveImageSupportedWidths(SlingScriptHelper sling) {
        int[] defaultWidths = new int[]{480, 640, 720, 800, 960, 1024, 1280, 1440, 1920, 2048};
        int[] supportedWidths = new int[]{};
        try {
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)sling.getService(ConfigurationAdmin.class);
            if (configAdmin != null) {
                int i;
                Configuration config = configAdmin.getConfiguration(OSGI_CONFIG_MEDIA_IMAGE);
                String[] obj = PropertiesUtil.toStringArray(config.getProperties().get("adapt.supported.widths"));
                if (obj instanceof String[]) {
                    String[] strings = obj;
                    supportedWidths = new int[strings.length];
                    for (i = 0; i < strings.length; ++i) {
                        supportedWidths[i] = Integer.parseInt(strings[i]);
                    }
                }
                if (obj instanceof long[]) {
                    long[] longs = (long[])obj;
                    supportedWidths = new int[longs.length];
                    for (i = 0; i < longs.length; ++i) {
                        supportedWidths[i] = (int)longs[i];
                    }
                }
            } else {
                LOGGER.error("getAdaptiveImageSupportedWidths: could not get ConfigurationAdmin service");
            }
        }
        catch (Exception ex) {
            LOGGER.warn("using default adapt.supported.widths=[{}] as config is missing OSGI configuration: {}", (Object)defaultWidths, (Object)OSGI_CONFIG_MEDIA_IMAGE);
            return defaultWidths;
        }
        return supportedWidths;
    }

    public static Map<String, String> getImageSetForImageOptions(String imageOption, com.adobe.granite.asset.api.Asset asset, ComponentProperties componentProperties, Resource assetResource, ResourceResolver resourceResolver, SlingScriptHelper sling) {
        Map<String, String> responsiveImageSet = new LinkedHashMap<String, String>();
        if (asset != null && !ResourceUtil.isNonExistingResource((Resource)assetResource)) {
            try {
                String assetPath = assetResource.getPath();
                switch (imageOption) {
                    case "generated": {
                        String imageHref = "";
                        Long lastModified = CommonUtil.getLastModified(assetResource);
                        imageHref = MessageFormat.format("{0}.img.jpeg/{1}.jpeg", assetPath, lastModified.toString());
                        responsiveImageSet.put("", imageHref);
                        break;
                    }
                    case "rendition": {
                        int targetWidth = (Integer)componentProperties.get("width", 0);
                        com.adobe.granite.asset.api.Rendition bestRendition = ImagesUtil.getBestFitRendition(targetWidth, asset);
                        if (bestRendition != null) {
                            responsiveImageSet.put("", bestRendition.getPath());
                        }
                        break;
                    }
                    case "adaptive": {
                        String[] adaptiveImageMapping = (String[])componentProperties.get(FIELD_ADAPTIVE_MAP, new String[0]);
                        responsiveImageSet = ImagesUtil.getAdaptiveImageSet(adaptiveImageMapping, resourceResolver, assetPath, assetPath, null, false, sling);
                        break;
                    }
                    case "mediaqueryrendition": {
                        String[] mediaQueryList = (String[])componentProperties.get(FIELD_MEDIAQUERYRENDITION_KEY, new String[0]);
                        String[] renditionList = (String[])componentProperties.get(FIELD_MEDIAQUERYRENDITION_VALUE, new String[0]);
                        if (mediaQueryList.length != renditionList.length) {
                            LOGGER.error(MessageFormat.format("fields {0} and {1} need to be equal length", FIELD_MEDIAQUERYRENDITION_KEY, FIELD_MEDIAQUERYRENDITION_VALUE));
                            break;
                        }
                        for (int i = 0; i < mediaQueryList.length; ++i) {
                            responsiveImageSet.put(mediaQueryList[i], assetPath + "/jcr:content/renditions/" + renditionList[i]);
                        }
                        break;
                    }
                    default: {
                        String[] renditionImageMapping = (String[])componentProperties.get(FIELD_RESPONSIVE_MAP, new String[0]);
                        String renditionPrefix = (String)componentProperties.get(FIELD_RENDITION_PREFIX, "");
                        responsiveImageSet = ImagesUtil.getBestFitMediaQueryRenditionSet(asset, renditionImageMapping, renditionPrefix);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("getAssetInfo: could not collect renditions asset={}", (Object)asset);
            }
        }
        return responsiveImageSet;
    }

    public static Duration getAssetDuration(ValueMap assetMetadataDurationValueMap) {
        if (assetMetadataDurationValueMap != null) {
            try {
                String durationScale = (String)assetMetadataDurationValueMap.get("xmpDM:scale", (Object)"");
                String durationValue = (String)assetMetadataDurationValueMap.get("xmpDM:value", (Object)"");
                Double scale = Double.parseDouble("1");
                Double value = Double.parseDouble(durationValue);
                if (durationScale.contains("/")) {
                    String[] scaleList = durationScale.split("/");
                    String stringOne = scaleList[0];
                    String stringDivided = scaleList[1];
                    Double doubleOne = Double.parseDouble(stringOne);
                    Double doubleDivided = Double.parseDouble(stringDivided);
                    scale = doubleOne / doubleDivided;
                }
                Double duration = scale * value;
                return Duration.ofSeconds(Math.round(duration));
            }
            catch (Exception ex) {
                LOGGER.error("getAssetDuration: could not extract duration asset metadata={}", (Object)assetMetadataDurationValueMap);
            }
        }
        return Duration.ZERO;
    }
}

