/*
 * Decompiled with CFR 0.152.
 */
package design.aem.utils.components;

import com.day.cq.commons.Externalizer;
import java.text.MessageFormat;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolverUtil.class);
    public static final String DEFAULT_MAP_CONFIG_SCHEMA = "http";
    public static final String SECURE_MAP_CONFIG_SCHEMA = "https";

    public static String mappedUrl(ResourceResolver resolver, String path) {
        if (path == null) {
            return null;
        }
        return resolver.map(path);
    }

    public static String mappedUrl(ResourceResolver resolver, SlingHttpServletRequest slingRequest, String path) {
        return ResolverUtil.mappedUrl(resolver, slingRequest, "local", path, false);
    }

    public static String mappedUrl(ResourceResolver resolver, SlingHttpServletRequest slingRequest, String domain, String path) {
        return ResolverUtil.mappedUrl(resolver, slingRequest, domain, path, false);
    }

    public static String mappedUrl(ResourceResolver resolver, SlingHttpServletRequest slingRequest, String path, Boolean secure) {
        return ResolverUtil.mappedUrl(resolver, slingRequest, "local", path, secure);
    }

    public static String mappedUrl(ResourceResolver resolver, SlingHttpServletRequest slingRequest, String domain, String path, Boolean secure) {
        if (path == null || resolver == null || slingRequest == null || domain == null || secure == null) {
            LOGGER.error(MessageFormat.format("mappedUrl not enough parameters: resolver=[{0}],slingRequest=[{1}],domain=[{2}],path=[{3}],secure=[{4}]", resolver, slingRequest, domain, path, secure));
            return null;
        }
        Externalizer externalizer = (Externalizer)resolver.adaptTo(Externalizer.class);
        if (externalizer != null) {
            if (secure.booleanValue()) {
                return externalizer.externalLink(resolver, domain, SECURE_MAP_CONFIG_SCHEMA, resolver.map(path));
            }
            return externalizer.externalLink(resolver, domain, DEFAULT_MAP_CONFIG_SCHEMA, resolver.map(path));
        }
        LOGGER.error("mappedUrl: could not get Externalizer object");
        return null;
    }

    public static boolean checkResourceHasChildResource(String resourceName, Resource _resource, ResourceResolver _resourceResolver) {
        String file_name;
        Resource foundResource;
        boolean resourceExist = false;
        String foundResourceType = ResourceUtil.findResourceSuperType((Resource)_resource);
        if (foundResourceType != null && (foundResource = _resourceResolver.getResource(ResourceUtil.findResourceSuperType((Resource)_resource) + "/" + resourceName)) != null && (file_name = foundResource.getName()).equals(resourceName)) {
            resourceExist = true;
        }
        return resourceExist;
    }
}

