/*
 * Decompiled with CFR 0.152.
 */
package design.aem.utils.components;

import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityUtil.class);

    public static boolean isUserMemberOf(Authorizable authorizable, List<String> groups) {
        User authUser;
        if (authorizable instanceof User && (authUser = (User)authorizable).isAdmin()) {
            return true;
        }
        try {
            Iterator groupIt = authorizable.memberOf();
            while (groupIt.hasNext()) {
                Group group = (Group)groupIt.next();
                if (!groups.contains(group.getPrincipal().getName())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getUserEmail(UserManager userManager, UserPropertiesManager userPropertiesManager, String userId, String defaultValue) {
        if (StringUtils.isEmpty((CharSequence)defaultValue)) {
            defaultValue = "";
        }
        String email = defaultValue;
        try {
            Authorizable userAuth = userManager.getAuthorizable(userId);
            if (userAuth != null) {
                UserProperties userProps = userPropertiesManager.getUserProperties(userAuth, "profile");
                if (userProps != null) {
                    email = userProps.getProperty("email");
                    if (email == null) {
                        email = defaultValue;
                    }
                } else {
                    LOGGER.warn(">> getUserEmail: userId: {0}, has not profile", (Object)userId);
                }
            } else {
                LOGGER.warn(">> getUserEmail: userId: {0}, does not exist1", (Object)userId);
            }
        }
        catch (Exception ex) {
            LOGGER.error("could not get user email {0}, {1}", (Object)userId, (Object)ex);
        }
        return email;
    }

    public static String getUserFullName(UserManager userManager, UserPropertiesManager userPropertiesManager, String userId, String defaultValue) {
        if (StringUtils.isEmpty((CharSequence)defaultValue)) {
            defaultValue = "";
        }
        String fullName = defaultValue;
        String givenName = "";
        String familyName = "";
        try {
            Authorizable userAuth = userManager.getAuthorizable(userId);
            if (userAuth != null) {
                fullName = userAuth.getPrincipal().getName();
                UserProperties userProps = userPropertiesManager.getUserProperties(userAuth, "profile");
                if (userProps != null) {
                    givenName = userProps.getProperty("givenName");
                    if (givenName == null) {
                        givenName = "";
                    }
                    if ((familyName = userProps.getProperty("familyName")) == null) {
                        familyName = "";
                    }
                    if (StringUtils.isEmpty((CharSequence)(fullName = MessageFormat.format("{0} {1}", givenName, familyName).trim()))) {
                        fullName = defaultValue;
                    }
                } else {
                    LOGGER.warn(">> getUserFullName: userId: {0}, has not profile", (Object)userId);
                }
            } else {
                LOGGER.warn(">> getUserFullName: userId: {0}, does not exist1", (Object)userId);
            }
        }
        catch (Exception ex) {
            LOGGER.error("could not get user full name {0}, {1}", (Object)userId, (Object)ex);
        }
        return fullName;
    }
}

