/*
 * Decompiled with CFR 0.152.
 */
package design.aem.utils.components;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingPostUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlingPostUtil.class);

    public static void processDeletes(Node parentNode, HttpServletRequest req) throws Exception {
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            if (!name.startsWith("./") || !name.endsWith("@Delete")) continue;
            if (parentNode.hasProperty(name)) {
                parentNode.getProperty(name).remove();
                continue;
            }
            if (!parentNode.hasNode(name)) continue;
            parentNode.getNode(name).remove();
        }
    }

    public static void writeContent(Node parentNode, HttpServletRequest req) throws RepositoryException {
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            if (!name.startsWith("./") || name.indexOf("cq:tags") > 0 || name.startsWith("jcr:primaryType") || name.startsWith("jcr:mixinTypes") || name.endsWith("@TypeHint")) continue;
            String[] values = req.getParameterValues(name);
            String typeHint = req.getParameter(name + "@TypeHint");
            boolean multiple = false;
            if (typeHint != null && typeHint.endsWith("[]")) {
                typeHint = typeHint.substring(0, typeHint.length() - "[]".length());
                multiple = true;
            }
            int type = 1;
            if (typeHint != null) {
                type = PropertyType.valueFromName((String)typeHint);
            }
            ArrayList<String> jcrValues = new ArrayList<String>();
            for (String value : values) {
                if (value.length() <= 0) continue;
                jcrValues.add(value);
            }
            multiple = multiple || jcrValues.size() > 1;
            String n = SlingPostUtil.getPropertyName(name);
            Node finalNode = SlingPostUtil.getParentNode(parentNode, name);
            if (multiple) {
                finalNode.setProperty(n, jcrValues.toArray(new String[0]), type);
                continue;
            }
            if (jcrValues.isEmpty()) continue;
            finalNode.setProperty(n, (String)jcrValues.get(0), type);
        }
    }

    public static List<String> getProcessedTags(TagManager tagManager, String name, HttpServletRequest req) throws Exception {
        String[] tags;
        ArrayList<String> processedTags = new ArrayList<String>();
        if (tagManager != null && (tags = req.getParameterValues(name)) != null) {
            for (String tagId : tags) {
                if (tagId.length() == 0) continue;
                if (tagId.contains(":")) {
                    Tag tag = tagManager.createTagByTitle(tagId, Locale.ENGLISH);
                    tagId = tag.getTagID();
                }
                processedTags.add(tagId);
            }
        }
        return processedTags;
    }

    public static List<String> getTagRequestParameters(HttpServletRequest req) {
        ArrayList<String> tagsParameters = new ArrayList<String>();
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            if (!name.endsWith("cq:tags")) continue;
            tagsParameters.add(name);
        }
        return tagsParameters;
    }

    public static String getPropertyName(String name) {
        if (name.startsWith("./") && (name = name.substring("./".length())).contains("/")) {
            name = name.substring(name.lastIndexOf("/") + 1);
        }
        return name;
    }

    public static Node getParentNode(Node parentNode, String name) {
        try {
            if (name.startsWith("./") && (name = name.substring("./".length())).contains("/")) {
                String relPath = name.substring(0, name.lastIndexOf("/"));
                parentNode = parentNode.hasNode(relPath) ? parentNode.getNode(relPath) : JcrUtil.createPath((String)(parentNode.getPath() + "/" + relPath), (String)"nt:unstructured", (Session)parentNode.getSession());
            }
        }
        catch (Exception ex) {
            LOGGER.error("getParentNode: could not get node named {} in {}, ex: {}", new Object[]{name, parentNode, ex});
        }
        return parentNode;
    }
}

