/*
 * Decompiled with CFR 0.152.
 */
package design.aem.workflow.process;

import com.adobe.acs.commons.fam.ThrottledTaskRunner;
import com.adobe.acs.commons.util.WorkflowHelper;
import com.adobe.acs.commons.util.visitors.ContentVisitor;
import com.adobe.acs.commons.util.visitors.ResourceRunnable;
import com.adobe.acs.commons.workflow.WorkflowPackageManager;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import design.aem.utils.components.CommonUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.component.propertytypes.ServiceVendor;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowProcess.class})
@Designate(ocd=Config.class)
@ServiceDescription(value="Workflow step for generating pages for Content Fragments")
@ServiceRanking(value=1001)
@ServiceVendor(value="AEM.Design")
public class ContentFragmentPageGenerator
implements WorkflowProcess {
    private Config config;
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentFragmentPageGenerator.class);
    protected static final String ARG_THROTTLE = "throttle";
    protected static final String ARG_TEMPLATE_PAGE = "templatePage";
    protected static final String ARG_OUTPUT_LOCATION = "outputLocation";
    protected static final String ARG_CONTENT_FRAGMENT_RESOURCETYPE = "contentFragmentComponentResourceType";
    protected static final String ARG_CONTENT_FRAGMENT_CREATE = "contentFragmentComponentCreate";
    protected static final String ARG_CONTENT_FRAGMENT_PAGE_ROOT_PATH = "contentFragmentComponentPageRootPath";
    protected static final String ARG_CONTENT_FRAGMENT_NODE_NAME = "contentFragmentComponentNodeName";
    protected static final String ARG_UPDATE_EXISTING_COMPONENT_UPDATE = "updateExistingComponent";
    protected static final String ARG_UPDATE_EXISTING_COMPONENT_RESOURCETYPE = "updateComponentResourceType";
    protected static final String ARG_UPDATE_EXISTING_ROOT_PATHS = "updateExistingRootPath";
    protected static final String ARG_CONTENT_FRAGMENT_ATTRIBUTE_NAME = "contentFragmentAttributeName";
    @Reference
    private WorkflowHelper workflowHelper;
    @Reference
    private WorkflowPackageManager workflowPackageManager;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private ThrottledTaskRunner throttledTaskRunner;

    @Activate
    @Modified
    protected void activate(Config config) {
        LOGGER.info("activate: resourceResolverFactory={}", (Object)this.resourceResolverFactory);
        this.config = config;
    }

    @Deactivate
    protected void deactivate(Config config) {
    }

    public final void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        ResourceResolver resourceResolver = null;
        long start = System.currentTimeMillis();
        try {
            resourceResolver = this.workflowHelper.getResourceResolver(workflowSession);
            String originalPayload = (String)workItem.getWorkflowData().getPayload();
            List<String> payloads = this.workflowPackageManager.getPaths(resourceResolver, originalPayload);
            final ProcessArgs processArgs = new ProcessArgs(metaDataMap, this.config);
            final AtomicInteger count = new AtomicInteger(0);
            final AtomicInteger failCount = new AtomicInteger(0);
            final PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
            final Session session = (Session)resourceResolver.adaptTo(Session.class);
            ResourceRunnable generatorRunnable = new ResourceRunnable(){

                @Override
                public void run(Resource resource) throws Exception {
                    block15: {
                        if (processArgs.isThrottle()) {
                            ContentFragmentPageGenerator.this.throttledTaskRunner.waitForLowCpuAndLowMemory();
                        }
                        boolean autoSaveContent = false;
                        try {
                            ContentFragment contentFragment = (ContentFragment)resource.adaptTo(ContentFragment.class);
                            if (contentFragment == null) {
                                this.failed("Payload is not a Content Fragment at path: {}", resource);
                                return;
                            }
                            Page newPage = pageManager.create(processArgs.getOutputLocation(), contentFragment.getName(), processArgs.getTemplatePath(), contentFragment.getTitle(), autoSaveContent);
                            if (newPage != null) {
                                Resource contentResource = newPage.getContentResource();
                                if (contentResource != null) {
                                    Node contentNode = (Node)contentResource.adaptTo(Node.class);
                                    if (contentNode == null) break block15;
                                    if (processArgs.isUpdateComponent()) {
                                        String containerPath = CommonUtil.findComponentInPage(newPage, processArgs.getUpdateComponentResourceType(), processArgs.getUpdateExistingRootPaths());
                                        if (StringUtils.isNotEmpty((CharSequence)containerPath)) {
                                            Node componentNode = JcrUtils.getNodeIfExists((String)containerPath, (Session)session);
                                            if (componentNode != null) {
                                                componentNode.setProperty(processArgs.getContentFragmentAttributeName(), resource.getPath());
                                            } else {
                                                this.failed("Could not get component node to update at path {}", containerPath);
                                            }
                                        } else {
                                            this.failed("Could not find component int root paths {} with resource type {}", processArgs.getUpdateExistingRootPaths(), processArgs.getUpdateComponentResourceType());
                                        }
                                    }
                                    if (!processArgs.isCreateContentFragmentComponent()) break block15;
                                    if (contentNode.hasNode(processArgs.getContentFragmentComponentPageRootPath())) {
                                        Node parNode = contentNode.getNode(processArgs.getContentFragmentComponentPageRootPath());
                                        if (parNode != null) {
                                            Node fragmentNode = JcrUtils.getOrCreateUniqueByPath((Node)parNode, (String)processArgs.getContentFragmentComponentNodeName(), (String)"nt:unstructured");
                                            fragmentNode.setProperty("sling:resourceType", processArgs.getContentFragmentComponentResourceType());
                                            fragmentNode.setProperty(processArgs.getContentFragmentAttributeName(), resource.getPath());
                                        }
                                    } else {
                                        this.failed("Page does not have required root node at path {}", processArgs.getUpdateExistingRootPaths());
                                    }
                                    break block15;
                                }
                                this.failed("Page does not have content resource at path {}", processArgs.getUpdateExistingRootPaths());
                                break block15;
                            }
                            this.failed("Could not create new page {}", newPage);
                        }
                        catch (Exception e) {
                            this.failed("Error occurred creating a new page, error: {}", e);
                        }
                    }
                    count.incrementAndGet();
                }

                private void failed(String message, Object ... error) {
                    failCount.incrementAndGet();
                    LOGGER.error(message, error);
                }
            };
            ContentVisitor<1> visitor = new ContentVisitor<1>(generatorRunnable);
            for (String payload : payloads) {
                Resource resource = resourceResolver.getResource(payload);
                if (!ResourceUtil.isNonExistingResource((Resource)resource)) {
                    visitor.accept(resource);
                    continue;
                }
                LOGGER.info("Content Fragment does not exist: {}", (Object)payload);
            }
            if (failCount.get() == 0) {
                session.save();
            } else {
                LOGGER.info("There were failures total of {} not saving", (Object)failCount.get());
            }
            LOGGER.error("Content Fragment Pages generated [{}] in {} ms", (Object)count.get(), (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            LOGGER.error("Error occurred Content Fragment Pages were not saved.");
            throw new WorkflowException((Throwable)e);
        }
    }

    protected static class ProcessArgs {
        private boolean throttle;
        private String templatePage;
        private String outputLocation;
        private String contentFragmentComponentResourceType;
        private boolean contentFragmentComponentCreate;
        private String contentFragmentComponentPageRootPath;
        private boolean updateExistingComponent;
        private String[] updateComponentResourceType;
        private String[] updateExistingRootPaths;
        private String contentFragmentAttributeName;
        private String contentFragmentComponentNodeName;

        ProcessArgs(MetaDataMap map, Config config) throws WorkflowException {
            if (map.get(ContentFragmentPageGenerator.ARG_TEMPLATE_PAGE, String.class) == null) {
                throw new WorkflowException("Please set template Page.");
            }
            this.templatePage = (String)map.get(ContentFragmentPageGenerator.ARG_TEMPLATE_PAGE, (Object)"");
            if (map.get(ContentFragmentPageGenerator.ARG_OUTPUT_LOCATION, String.class) == null) {
                throw new WorkflowException("Please set output location for generated pages.");
            }
            this.outputLocation = (String)map.get(ContentFragmentPageGenerator.ARG_OUTPUT_LOCATION, (Object)"");
            if (map.get(ContentFragmentPageGenerator.ARG_CONTENT_FRAGMENT_RESOURCETYPE, String.class) == null) {
                LOGGER.warn("Content Fragment Component Resource Type not specified using default: {}.", (Object)config.content_fragment_component_resourcetype());
            }
            this.contentFragmentComponentResourceType = (String)map.get(ContentFragmentPageGenerator.ARG_CONTENT_FRAGMENT_RESOURCETYPE, (Object)config.content_fragment_component_resourcetype());
            if (map.get(ContentFragmentPageGenerator.ARG_CONTENT_FRAGMENT_CREATE, Boolean.class) == null) {
                LOGGER.warn("Content Fragment Component Create not specified using default: {}.", (Object)config.content_fragment_component_create());
            }
            this.contentFragmentComponentCreate = (Boolean)map.get(ContentFragmentPageGenerator.ARG_CONTENT_FRAGMENT_CREATE, (Object)config.content_fragment_component_create());
            if (map.get(ContentFragmentPageGenerator.ARG_CONTENT_FRAGMENT_PAGE_ROOT_PATH, String.class) == null) {
                LOGGER.warn("Content Fragment Component Page Root Path not specified using default: {}.", (Object)config.content_fragment_component_page_root_path());
            }
            this.contentFragmentComponentPageRootPath = (String)map.get(ContentFragmentPageGenerator.ARG_CONTENT_FRAGMENT_PAGE_ROOT_PATH, (Object)config.content_fragment_component_page_root_path());
            if (map.get(ContentFragmentPageGenerator.ARG_CONTENT_FRAGMENT_NODE_NAME, String.class) == null) {
                LOGGER.warn("Content Fragment Component Node Name not specified using default: {}.", (Object)config.content_fragment_component_node_name());
            }
            this.contentFragmentComponentNodeName = (String)map.get(ContentFragmentPageGenerator.ARG_CONTENT_FRAGMENT_NODE_NAME, (Object)config.content_fragment_component_node_name());
            if (map.get(ContentFragmentPageGenerator.ARG_UPDATE_EXISTING_COMPONENT_UPDATE, Boolean.class) == null) {
                LOGGER.warn("Update Existing Component not specified using default: {}.", (Object)config.update_existing_component());
            }
            this.updateExistingComponent = (Boolean)map.get(ContentFragmentPageGenerator.ARG_UPDATE_EXISTING_COMPONENT_UPDATE, (Object)config.update_existing_component());
            if (map.get(ContentFragmentPageGenerator.ARG_UPDATE_EXISTING_COMPONENT_RESOURCETYPE, String[].class) == null) {
                LOGGER.warn("Page Container Component Resource Type not specified using default: {}", (Object[])config.update_existing_component_resourcetype());
            }
            this.updateComponentResourceType = (String[])map.get(ContentFragmentPageGenerator.ARG_UPDATE_EXISTING_COMPONENT_RESOURCETYPE, (Object)config.update_existing_component_resourcetype());
            LOGGER.warn("updateComponentResourceType {}", (Object[])this.updateComponentResourceType);
            if (map.get(ContentFragmentPageGenerator.ARG_UPDATE_EXISTING_ROOT_PATHS, String[].class) == null) {
                LOGGER.warn("Page Root Path not specified using default: {}", (Object[])config.update_page_root_path());
            }
            this.updateExistingRootPaths = (String[])map.get(ContentFragmentPageGenerator.ARG_UPDATE_EXISTING_ROOT_PATHS, (Object)config.update_page_root_path());
            if (map.get(ContentFragmentPageGenerator.ARG_CONTENT_FRAGMENT_ATTRIBUTE_NAME, String.class) == null) {
                LOGGER.warn("Page Root Path not specified using default: {}", (Object)config.content_fragment_attribute_name());
            }
            this.contentFragmentAttributeName = (String)map.get(ContentFragmentPageGenerator.ARG_CONTENT_FRAGMENT_ATTRIBUTE_NAME, (Object)config.content_fragment_attribute_name());
            if (map.get(ContentFragmentPageGenerator.ARG_THROTTLE, Boolean.class) == null) {
                LOGGER.warn("Throttle not specified defaulting to throttle enabled.");
            }
            this.throttle = Boolean.parseBoolean((String)map.get(ContentFragmentPageGenerator.ARG_THROTTLE, (Object)"true"));
        }

        public String getTemplatePath() {
            return this.templatePage;
        }

        public String getOutputLocation() {
            return this.outputLocation;
        }

        public boolean isCreateContentFragmentComponent() {
            return this.contentFragmentComponentCreate;
        }

        public String getContentFragmentComponentResourceType() {
            return this.contentFragmentComponentResourceType;
        }

        public String getContentFragmentComponentPageRootPath() {
            return this.contentFragmentComponentPageRootPath;
        }

        public String getContentFragmentComponentNodeName() {
            return this.contentFragmentComponentNodeName;
        }

        public boolean isUpdateComponent() {
            return this.updateExistingComponent;
        }

        public String[] getUpdateComponentResourceType() {
            return this.updateComponentResourceType;
        }

        public String[] getUpdateExistingRootPaths() {
            return this.updateExistingRootPaths;
        }

        public String getContentFragmentAttributeName() {
            return this.contentFragmentAttributeName;
        }

        public boolean isThrottle() {
            return this.throttle;
        }
    }

    @ObjectClassDefinition(name="AEM Design - Workflow - Content Fragment Page Generator", description="Workflow step for generating pages for Content Fragments")
    public static @interface Config {
        @AttributeDefinition(name="Content Fragment Attribute Name", description="Attribute Name for path to content fragment, default: fragmentPath")
        public String content_fragment_attribute_name() default "fragmentPath";

        @AttributeDefinition(name="Content Fragment Component Node Name", description="Name of new content fragment component node, default: contentfragment")
        public String content_fragment_component_node_name() default "contentfragment";

        @AttributeDefinition(name="Update Existing Component", description="Add reference to existing component, default: true", type=AttributeType.BOOLEAN)
        public boolean update_existing_component() default true;

        @AttributeDefinition(name="Update Page Root Path", description="Path of root nodes in page to use, default: article/par")
        public String[] update_page_root_path() default {"article/par"};

        @AttributeDefinition(name="Update Existing Component Resource Types", description="Resource type for Component to Update, default: aemdesign/components/details/generic-details")
        public String[] update_existing_component_resourcetype() default {"aemdesign/components/details/generic-details"};

        @AttributeDefinition(name="Create Content Fragment Component", description="Create content component in page root, default: false", type=AttributeType.BOOLEAN)
        public boolean content_fragment_component_create() default false;

        @AttributeDefinition(name="Create Content Fragment Resource Type", description="Resource type for Content Fragment component default: aemdesign/components/content/contentfragment")
        public String content_fragment_component_resourcetype() default "aemdesign/components/content/contentfragment";

        @AttributeDefinition(name="Create Content Fragment Page Root Path", description="Path of root node where to create Content Fragment, default: article/par")
        public String content_fragment_component_page_root_path() default "article/par";
    }
}

