/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.adobeio.service.impl;

import com.adobe.acs.commons.adobeio.service.EndpointService;
import com.adobe.acs.commons.adobeio.service.IntegrationService;
import com.adobe.acs.commons.adobeio.service.impl.AdobeioHelper;
import com.adobe.acs.commons.adobeio.service.impl.EndpointConfiguration;
import com.adobe.acs.commons.util.ParameterUtil;
import com.drew.lang.annotations.NotNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={EndpointService.class})
@Designate(ocd=EndpointConfiguration.class, factory=true)
public class EndpointServiceImpl
implements EndpointService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointServiceImpl.class);
    private String id;
    private String url;
    private String method;
    private List<Map.Entry<String, String>> specificServiceHeaders;
    private EndpointConfiguration config;
    @Reference
    private IntegrationService integrationService;
    @Reference
    private AdobeioHelper helper;

    @Activate
    protected void activate(EndpointConfiguration config) throws Exception {
        LOGGER.debug("Start ACTIVATE Endpoint {}", (Object)config.id());
        this.id = config.id();
        this.url = config.endpoint();
        this.method = config.method();
        this.config = config;
        this.specificServiceHeaders = this.convertServiceSpecificHeaders(config.specificServiceHeaders());
        LOGGER.debug("End ACTIVATE Endpoint {}", (Object)this.id);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String[] getConfigServiceSpecificHeaders() {
        return this.config.specificServiceHeaders();
    }

    @Override
    public JsonObject performIO_Action() {
        return this.performio(this.url, Collections.emptyMap());
    }

    @Override
    public JsonObject performIO_Action(String url, String method, String[] headers, JsonObject payload) {
        return this.process(url, Collections.emptyMap(), method, headers, payload);
    }

    @Override
    public JsonObject performIO_Action(@NotNull Map<String, String> queryParameters) {
        return this.performio(this.url, queryParameters);
    }

    @Override
    public JsonObject performIO_Action(@NotNull JsonObject payload) {
        return this.handleAdobeIO_Action(payload);
    }

    @Override
    public boolean isConnected() {
        try {
            JsonObject response = this.processGet(new URIBuilder(this.url).build(), null);
            return !response.has("error");
        }
        catch (Exception e) {
            LOGGER.error("Problem testing the connection for {}", (Object)this.id, (Object)e);
            return false;
        }
    }

    private JsonObject handleAdobeIO_Action(@NotNull JsonObject payload) {
        JsonObject processResponse = new JsonObject();
        try {
            LOGGER.debug("ActionUrl = {} . method = {}", (Object)this.url, (Object)this.method);
            processResponse = this.process(this.url, Collections.emptyMap(), this.method, null, payload);
        }
        catch (Exception e) {
            processResponse.addProperty("error", "Problem processing");
            LOGGER.error("Problem processing action {} in handleAdobeIO_Action", (Object)this.url);
        }
        return processResponse;
    }

    private JsonObject process(@NotNull String actionUrl, @NotNull Map<String, String> queryParameters, @NotNull String method, String[] headers, @NotNull JsonObject payload) {
        if (StringUtils.isBlank((CharSequence)actionUrl) || StringUtils.isBlank((CharSequence)method)) {
            LOGGER.error("Method or url is null");
            return new JsonObject();
        }
        URI uri = null;
        try {
            URIBuilder builder = new URIBuilder(actionUrl);
            queryParameters.forEach((k, v) -> builder.addParameter(k, v));
            uri = builder.build();
        }
        catch (URISyntaxException uriexception) {
            LOGGER.error(uriexception.getMessage());
            return new JsonObject();
        }
        LOGGER.debug("Performing method = {}. queryParameters = {}. actionUrl = {}. payload = {}", new Object[]{method, queryParameters, uri, payload});
        try {
            if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)"POST")) {
                return this.processPost(uri, payload, headers);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)"GET")) {
                return this.processGet(uri, headers);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)"PATCH")) {
                return this.processPatch(uri, payload, headers);
            }
            return new JsonObject();
        }
        catch (IOException ioexception) {
            LOGGER.error(ioexception.getMessage());
            return new JsonObject();
        }
    }

    private JsonObject processGet(@NotNull URI uri, String[] headers) throws IOException {
        StopWatch stopWatch = new StopWatch();
        LOGGER.debug("STARTING STOPWATCH {}", (Object)uri);
        stopWatch.start();
        HttpGet get = new HttpGet(uri);
        get.setHeader("authorization", "Bearer " + this.integrationService.getAccessToken());
        get.setHeader("cache-control", "no-cache");
        get.setHeader("X-Api-Key", this.integrationService.getApiKey());
        if (headers == null || headers.length == 0) {
            this.addHeaders((HttpRequest)get, this.specificServiceHeaders);
        } else {
            this.addHeaders((HttpRequest)get, this.convertServiceSpecificHeaders(headers));
        }
        Object[] contentTypeHeaders = get.getHeaders("content-type");
        if (ArrayUtils.isEmpty((Object[])contentTypeHeaders)) {
            get.setHeader("content-type", "application/json");
        }
        try (CloseableHttpClient httpClient = this.helper.getHttpClient(this.integrationService.getTimeoutinMilliSeconds());){
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
            JsonObject result = this.responseAsJson((HttpResponse)response);
            LOGGER.debug("Response-code {}", (Object)response.getStatusLine().getStatusCode());
            LOGGER.debug("STOPPING STOPWATCH {}", (Object)uri);
            stopWatch.stop();
            LOGGER.debug("Stopwatch time: {}", (Object)stopWatch);
            stopWatch.reset();
            JsonObject jsonObject = result;
            return jsonObject;
        }
    }

    private JsonObject processPost(@NotNull URI uri, @NotNull JsonObject payload, String[] headers) throws IOException {
        HttpPost post = new HttpPost(uri);
        return payload != null && StringUtils.isNotBlank((CharSequence)payload.toString()) ? this.processRequestWithBody((HttpEntityEnclosingRequestBase)post, payload, headers) : new JsonObject();
    }

    private JsonObject processPatch(@NotNull URI uri, @NotNull JsonObject payload, String[] headers) throws IOException {
        HttpPatch patch = new HttpPatch(uri);
        return payload != null && StringUtils.isNotBlank((CharSequence)payload.toString()) ? this.processRequestWithBody((HttpEntityEnclosingRequestBase)patch, payload, headers) : new JsonObject();
    }

    private JsonObject processRequestWithBody(@NotNull HttpEntityEnclosingRequestBase base, @NotNull JsonObject payload, String[] headers) throws IOException {
        StopWatch stopWatch = new StopWatch();
        LOGGER.debug("STARTING STOPWATCH processRequestWithBody");
        stopWatch.start();
        base.setHeader("authorization", "Bearer " + this.integrationService.getAccessToken());
        base.setHeader("cache-control", "no-cache");
        base.setHeader("X-Api-Key", this.integrationService.getApiKey());
        base.setHeader("content-type", "application/json");
        if (headers == null || headers.length == 0) {
            this.addHeaders((HttpRequest)base, this.specificServiceHeaders);
        } else {
            this.addHeaders((HttpRequest)base, this.convertServiceSpecificHeaders(headers));
        }
        StringEntity input = new StringEntity(payload.toString());
        input.setContentType("application/json");
        if (!base.getClass().isInstance(HttpGet.class)) {
            base.setEntity((HttpEntity)input);
        }
        LOGGER.debug("Process call. uri = {}. payload = {}", (Object)base.getURI().toString(), (Object)payload);
        try (CloseableHttpClient httpClient = this.helper.getHttpClient(this.integrationService.getTimeoutinMilliSeconds());){
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)base);
            JsonObject result = this.responseAsJson((HttpResponse)response);
            LOGGER.debug("STOPPING STOPWATCH processRequestWithBody");
            stopWatch.stop();
            LOGGER.debug("Stopwatch time processRequestWithBody: {}", (Object)stopWatch);
            stopWatch.reset();
            JsonObject jsonObject = result;
            return jsonObject;
        }
    }

    private JsonObject responseAsJson(@NotNull HttpResponse response) throws IOException {
        String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
        JsonParser parser = new JsonParser();
        JsonObject resultJson = new JsonObject();
        try {
            LOGGER.debug("Call result = {}", (Object)result);
            resultJson = parser.parse(result).getAsJsonObject();
        }
        catch (Exception e) {
            resultJson.addProperty("error", result);
        }
        LOGGER.debug("JSON result from Service: {}", (Object)resultJson);
        return resultJson;
    }

    private JsonObject performio(@NotNull String actionUrl, @NotNull Map<String, String> queryParameters) {
        try {
            return this.process(actionUrl, queryParameters, StringUtils.upperCase((String)this.method), null, null);
        }
        catch (Exception e) {
            LOGGER.error("Problem processing action {} in performIO", (Object)actionUrl, (Object)e);
            return new JsonObject();
        }
    }

    private void addHeaders(HttpRequest request, List<Map.Entry<String, String>> headers) {
        headers.forEach(e -> request.addHeader((String)e.getKey(), (String)e.getValue()));
    }

    protected List<Map.Entry<String, String>> convertServiceSpecificHeaders(String[] specificServiceHeaders) {
        if (specificServiceHeaders == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(specificServiceHeaders).stream().map(s -> ParameterUtil.toMapEntry(s, ":")).filter(e -> e != null).collect(Collectors.toList());
    }
}

