/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.audit_log_search.impl;

import com.adobe.acs.commons.audit_log_search.AuditLogSearchRequest;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(label="ACS AEM Commons - Audit Log Search Servlet", methods={"GET"}, resourceTypes={"acs-commons/components/utilities/audit-log-search"}, selectors={"auditlogsearch"}, extensions={"json"}, metatype=false)
public class AuditLogSearchServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(AuditLogSearchServlet.class);

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        log.trace("doGet");
        AuditLogSearchRequest req = null;
        JsonObject result = new JsonObject();
        boolean succeeded = true;
        try {
            req = new AuditLogSearchRequest(request);
            log.debug("Loaded search request: {}", (Object)req);
            JsonArray results = new JsonArray();
            long count = 0L;
            String whereClause = req.getQueryParameters();
            StringBuilder queryBuilder = new StringBuilder("SELECT * FROM [cq:AuditEvent] AS s");
            if (StringUtils.isNotEmpty((String)whereClause)) {
                queryBuilder.append(" WHERE ").append(whereClause);
            }
            String queryStr = queryBuilder.toString();
            log.debug("Finding audit events with: {}", (Object)queryStr);
            ResourceResolver resolver = request.getResourceResolver();
            QueryManager queryManager = ((Session)resolver.adaptTo(Session.class)).getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryStr, "JCR-SQL2");
            int limit = -1;
            if (StringUtils.isNotEmpty((String)request.getParameter("limit")) && (limit = Integer.parseInt(request.getParameter("limit"), 10)) > 0) {
                log.debug("Limiting to {} results", (Object)limit);
                query.setLimit((long)limit);
            }
            NodeIterator nodes = query.execute().getNodes();
            log.debug("Query execution complete!");
            while (nodes.hasNext()) {
                results.add((JsonElement)this.serializeAuditEvent(resolver.getResource(nodes.nextNode().getPath()), req));
                ++count;
            }
            result.addProperty("count", (Number)count);
            result.add("events", (JsonElement)results);
            log.debug("Found {} audit events", (Object)count);
        }
        catch (ParseException e) {
            log.warn("Encountered exception parsing start / end date", (Throwable)e);
            succeeded = false;
        }
        catch (RepositoryException e) {
            log.warn("Encountered respository exception attempting to retrieve audit events", (Throwable)e);
            succeeded = false;
        }
        catch (ClassNotFoundException e) {
            log.warn("Encountered exception deserializing attributes", (Throwable)e);
            succeeded = false;
        }
        result.addProperty("succeeded", Boolean.valueOf(succeeded));
        response.setContentType("application/json");
        response.getWriter().write(result.toString());
    }

    private JsonObject serializeAuditEvent(Resource auditEventResource, AuditLogSearchRequest request) throws RepositoryException, IOException, ClassNotFoundException {
        JsonObject auditEvent = new JsonObject();
        ValueMap properties = auditEventResource.getValueMap();
        auditEvent.addProperty("category", (String)properties.get("cq:category", String.class));
        auditEvent.addProperty("eventPath", auditEventResource.getPath());
        auditEvent.addProperty("path", (String)properties.get("cq:path", String.class));
        auditEvent.addProperty("type", (String)properties.get("cq:type", String.class));
        String userId = (String)properties.get("cq:userid", String.class);
        auditEvent.addProperty("userId", userId);
        auditEvent.addProperty("userName", request.getUserName(auditEventResource.getResourceResolver(), userId));
        auditEvent.addProperty("userPath", request.getUserPath(auditEventResource.getResourceResolver(), userId));
        auditEvent.addProperty("time", (Number)((Date)properties.get("cq:time", (Object)new Date())).getTime());
        JsonArray modified = this.getModifiedProperties(properties);
        if (properties.get("above", String.class) != null) {
            modified.add((JsonElement)new JsonPrimitive("above=" + (String)properties.get("above", String.class)));
        }
        if (properties.get("destination", String.class) != null) {
            modified.add((JsonElement)new JsonPrimitive("destination=" + (String)properties.get("destination", String.class)));
        }
        if (properties.get("versionId", String.class) != null) {
            modified.add((JsonElement)new JsonPrimitive("versionId=" + (String)properties.get("versionId", String.class)));
        }
        if (modified.size() != 0) {
            auditEvent.add("modified", (JsonElement)modified);
        }
        return auditEvent;
    }

    private JsonArray getModifiedProperties(ValueMap properties) throws IOException {
        JsonArray modifiedProperties = new JsonArray();
        InputStream is = (InputStream)properties.get("cq:properties", InputStream.class);
        if (is != null) {
            ObjectInputStream ois = new ObjectInputStream(is);
            ois.readInt();
            while (ois.available() != -1) {
                try {
                    Object obj = ois.readObject();
                    if (!(obj instanceof HashSet)) continue;
                    Set propertiesSet = (Set)obj;
                    for (String property : propertiesSet) {
                        modifiedProperties.add((JsonElement)new JsonPrimitive(property));
                    }
                    break;
                }
                catch (Exception e) {
                    break;
                }
            }
        }
        return modifiedProperties;
    }
}

