/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dam.impl;

import com.adobe.acs.commons.dam.AbstractRenditionModifyingProcess;
import com.adobe.acs.commons.util.WorkflowHelper;
import com.day.cq.dam.api.Rendition;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import com.day.image.Layer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.mime.MimeTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Property(name="process.label", value={"Add Watermark to Rendition"})
public final class AddWatermarkToRenditionProcess
extends AbstractRenditionModifyingProcess
implements WorkflowProcess {
    private static ConcurrentMap<String, Object> watermarkLogCache = new ConcurrentHashMap<String, Object>();
    @Reference
    private WorkflowHelper workflowHelper;
    @Reference
    private MimeTypeService mimeTypeService;
    private static final Logger log = LoggerFactory.getLogger(AddWatermarkToRenditionProcess.class);
    private static final String ARG_WATERMARK = "watermark";
    private static final String WATERMARK_SPECIFIER = "watermark";

    private static void logMissingWatermark(String path) {
        if (watermarkLogCache.putIfAbsent(path, new Object()) == null) {
            log.warn("Watermark path {} is not found.", (Object)path);
        }
    }

    private static void logInvalidWatermark(String path) {
        if (watermarkLogCache.putIfAbsent(path, new Object()) == null) {
            log.warn("Watermark path {} is not valid.", (Object)path);
        }
    }

    private void addWatermark(Layer layer, Layer watermark) {
        layer.blit(watermark, 0, layer.getHeight() - watermark.getHeight(), watermark.getWidth(), watermark.getHeight(), 0, 0);
    }

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        this.execute(workItem, workflowSession, metaDataMap, this.workflowHelper);
    }

    private Layer getLayer(String path, WorkflowSession session) throws LoginException {
        if (path != null) {
            ResourceResolver resolver = this.workflowHelper.getResourceResolver(session);
            Resource resource = resolver.getResource(path);
            if (resource != null) {
                Layer layer = (Layer)resource.adaptTo(Layer.class);
                if (layer != null) {
                    return layer;
                }
                AddWatermarkToRenditionProcess.logInvalidWatermark(path);
            } else {
                AddWatermarkToRenditionProcess.logMissingWatermark(path);
            }
        }
        return null;
    }

    @Override
    protected String getTempFileSpecifier() {
        return "watermark";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Layer processLayer(Layer layer, Rendition rendition, WorkflowSession workflowSession, String[] args) {
        String watermarkPath;
        String string = watermarkPath = this.workflowHelper.getValuesFromArgs("watermark", args).size() > 0 ? this.workflowHelper.getValuesFromArgs("watermark", args).get(0) : null;
        if (watermarkPath != null) {
            Layer watermark = null;
            try {
                watermark = this.getLayer(watermarkPath, workflowSession);
                if (watermark == null) return layer;
                this.addWatermark(layer, watermark);
                return layer;
            }
            catch (LoginException e) {
                log.error("Unable to log into repository.", (Throwable)e);
                return layer;
            }
            finally {
                if (watermark != null) {
                    watermark.dispose();
                    watermark = null;
                }
            }
        } else {
            log.info("No watermark specified. Skipping.");
        }
        return layer;
    }

    protected void bindWorkflowHelper(WorkflowHelper workflowHelper) {
        this.workflowHelper = workflowHelper;
    }

    protected void unbindWorkflowHelper(WorkflowHelper workflowHelper) {
        if (this.workflowHelper == workflowHelper) {
            this.workflowHelper = null;
        }
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }
}

