/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.designer;

import com.adobe.acs.commons.designer.DesignHtmlLibraryManager;
import com.adobe.acs.commons.designer.PageRegion;
import com.day.cq.wcm.api.designer.Design;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.jsp.util.TagUtil;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class IncludeDesignLibrariesTag
extends TagSupport {
    private PageRegion region;
    private boolean js;
    private boolean css;
    private Design design;

    public int doEndTag() throws JspException {
        SlingHttpServletRequest request = TagUtil.getRequest((PageContext)this.pageContext);
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        DesignHtmlLibraryManager manager = (DesignHtmlLibraryManager)bindings.getSling().getService(DesignHtmlLibraryManager.class);
        if (manager != null) {
            try {
                if (this.js && this.css) {
                    manager.writeIncludes(request, this.getDesign(), this.region, (Writer)this.pageContext.getOut());
                } else if (this.js) {
                    manager.writeJsInclude(request, this.getDesign(), this.region, (Writer)this.pageContext.getOut());
                } else if (this.css) {
                    manager.writeCssInclude(request, this.getDesign(), this.region, (Writer)this.pageContext.getOut());
                }
            }
            catch (IOException e) {
                throw new JspException("Unable to write client library includes", (Throwable)e);
            }
        }
        this.reset();
        return 6;
    }

    public void release() {
        this.reset();
        super.release();
    }

    public void setCss(boolean css) {
        this.css = css;
    }

    public void setDesign(Design design) {
        this.design = design;
    }

    public void setJs(boolean js) {
        this.js = js;
    }

    public void setRegion(String region) {
        this.region = PageRegion.valueOf(region.toUpperCase());
    }

    private Design getDesign() {
        if (this.design == null) {
            return (Design)this.pageContext.getAttribute("currentDesign");
        }
        return this.design;
    }

    private void reset() {
        this.region = null;
        this.js = false;
        this.css = false;
    }
}

