/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.etag.impl;

import acscommons.com.google.common.io.BaseEncoding;
import com.adobe.acs.commons.util.BufferedServletOutput;
import com.adobe.acs.commons.util.BufferedSlingHttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, property={"sling.filter.scope=REQUEST"})
@Designate(ocd=Config.class)
public class EtagMessageDigestServletFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(EtagMessageDigestServletFilter.class);
    private Config configuration;
    private Collection<String> ignoredHeaderNames;

    @Activate
    public void activate(Config configuration) {
        this.configuration = configuration;
        this.ignoredHeaderNames = configuration.ignoredResponseHeaders() != null && configuration.ignoredResponseHeaders().length > 0 ? (Collection<Object>)Arrays.asList(configuration.ignoredResponseHeaders()).stream().map(String::toLowerCase).collect(Collectors.toSet()) : Collections.emptySet();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(response instanceof SlingHttpServletResponse) || !(request instanceof SlingHttpServletRequest)) {
            throw new IllegalStateException("Filter not properly registered as Sling Servlet Filter");
        }
        if (!this.configuration.enabled()) {
            log.debug("ETag filter not enabled");
            chain.doFilter(request, response);
            return;
        }
        try {
            SlingHttpServletResponse slingHttpServletResponse = (SlingHttpServletResponse)response;
            SlingHttpServletRequest slingHttpServletRequest = (SlingHttpServletRequest)request;
            ByteArrayOutputStream outputStream = this.configuration.enabledForOutputStream() ? new ByteArrayOutputStream() : null;
            try (BufferedSlingHttpServletResponse bufferedResponse = new BufferedSlingHttpServletResponse(slingHttpServletResponse, new StringWriter(), outputStream);){
                chain.doFilter(request, (ServletResponse)bufferedResponse);
                if (!this.configuration.overwrite() && slingHttpServletResponse.containsHeader("ETag")) {
                    log.debug("Do not overwrite existing ETag header with value '{}'", (Object)slingHttpServletResponse.getHeader("ETag"));
                    return;
                }
                if (!this.configuration.enabledForOutputStream() && bufferedResponse.getBufferedServletOutput().getWriteMethod() == BufferedServletOutput.ResponseWriteMethod.OUTPUTSTREAM) {
                    log.debug("Can not calculate message digest as response was written via output stream which was not buffered.");
                    return;
                }
                if (slingHttpServletResponse.isCommitted()) {
                    log.error("Can not send ETag header because response is already committed, try to give this filter a higher ranking!");
                    return;
                }
                String digest = this.calculateDigestFromResponse(bufferedResponse);
                slingHttpServletRequest.getRequestProgressTracker().log("ETag from digest calculated with {0}: {1}", new Object[]{this.configuration.messageDigestAlgorithm(), digest});
                slingHttpServletResponse.setHeader("ETag", "\"" + digest + "\"");
                if (EtagMessageDigestServletFilter.isUnmodified(slingHttpServletRequest.getHeaders("If-None-Match"), digest)) {
                    log.debug("Digest is equal to one of the given ETags in the If-None-Match request header, returning empty response with a 304");
                    bufferedResponse.resetBuffer();
                    slingHttpServletResponse.setStatus(304);
                    return;
                }
                if (this.configuration.addAsHtmlComment() && bufferedResponse.getBufferedServletOutput().getWriteMethod() == BufferedServletOutput.ResponseWriteMethod.WRITER && slingHttpServletResponse.getContentType() != null && slingHttpServletResponse.getContentType().startsWith("text/html")) {
                    bufferedResponse.getWriter().println(String.format("%n<!-- ETag: %s -->", digest));
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.error("The algorithm configured for this servlet filter is invalid: " + this.configuration.messageDigestAlgorithm(), (Throwable)e);
        }
    }

    static boolean isUnmodified(Enumeration<String> ifNoneMatchETags, String responseETag) {
        if (ifNoneMatchETags == null) {
            throw new IllegalStateException("Can not access request headers");
        }
        while (ifNoneMatchETags.hasMoreElements()) {
            String ifNoneMatchETag = ifNoneMatchETags.nextElement();
            if (!ifNoneMatchETag.equals(responseETag) && !ifNoneMatchETag.equals("*")) continue;
            return true;
        }
        return false;
    }

    String calculateDigestFromResponse(BufferedSlingHttpServletResponse bufferedResponse) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance(this.configuration.messageDigestAlgorithm());
        if (bufferedResponse.getBufferedServletOutput().getWriteMethod() == BufferedServletOutput.ResponseWriteMethod.OUTPUTSTREAM) {
            messageDigest.update(bufferedResponse.getBufferedServletOutput().getBufferedBytes());
        } else if (bufferedResponse.getBufferedServletOutput().getWriteMethod() == BufferedServletOutput.ResponseWriteMethod.WRITER) {
            Object charsetName = bufferedResponse.getCharacterEncoding();
            if (charsetName == null) {
                charsetName = StandardCharsets.ISO_8859_1.name();
            }
            messageDigest.update(bufferedResponse.getBufferedServletOutput().getBufferedString().getBytes((String)charsetName));
        }
        if (this.configuration.considerResponseHeaders()) {
            for (String name : bufferedResponse.getHeaderNames()) {
                String lowerCaseName = name.toLowerCase();
                if (this.ignoredHeaderNames.contains(lowerCaseName)) continue;
                String header = lowerCaseName + ":" + StringUtils.join((Collection)bufferedResponse.getHeaders(name), (char)',');
                messageDigest.update(header.getBytes(StandardCharsets.US_ASCII));
                log.debug("Considering header {} for the digest calculation", (Object)header);
            }
        }
        if (!StringUtils.isEmpty((String)this.configuration.salt())) {
            log.debug("Considering salt {} for the digest calculation", (Object)this.configuration.salt());
            messageDigest.update(this.configuration.salt().getBytes(StandardCharsets.UTF_8));
        }
        byte[] digest = messageDigest.digest();
        String hexDigest = BaseEncoding.base16().lowerCase().encode(digest);
        log.debug("ETag based on {} digest of the response is {}", (Object)messageDigest.getAlgorithm(), (Object)hexDigest);
        return hexDigest;
    }

    public void destroy() {
    }

    @ObjectClassDefinition(name="ACS AEM Commons - Digest-based ETag Servlet Filter", description="Sets an ETag response header based on a message digest from the response's content and optionally its' other headers. Enabling it increases the memory consumption as the full response need to be buffered before being sent to the client!")
    public static @interface Config {
        @AttributeDefinition(name="Enabled", description="If this filter should not be active, rather try to delete this config. Only in cases where this cannot be easily accomplished uncheck this option to disable the filter.")
        public boolean enabled() default true;

        @AttributeDefinition(name="Message Digest Algorithm", description="The message digest algorithm for calculating the ETag header. Must be one of the supported ones by the JRE (for Oracle JRE8 listed in https://docs.oracle.com/javase/8/docs/technotes/guides/security/StandardNames.html#MessageDigest).")
        public String messageDigestAlgorithm() default "MD5";

        @AttributeDefinition(name="Overwrite existing ETag header", description="If this is set a previously set ETag header will be disregarded and overwritten by this filter. Otherwise the original ETag is used.")
        public boolean overwrite() default false;

        @AttributeDefinition(name="Service Ranking", description="Indication of where to place the filter in the filter chain. The higher the number the earlier in the filter chain. This value may span the whole range of integer values. Two filters with equal service.ranking property value (explicitly set or default value of zero) will be ordered according to their service.id service property as described in section 5.2.5, Service Properties, of the OSGi Core Specification R 4.2.")
        public int service_ranking() default 0x7FFFFFFF;

        @AttributeDefinition(name="Pattern", description="Restricts the filter to paths that match the supplied regular expression. Requires Sling Engine 2.4.0 or newer.")
        public String sling_filter_pattern() default ".*";

        @AttributeDefinition(name="Consider Response Headers", description="If checked will also include the existing response headers for the digest calculation, i.e. different headers lead to different ETags. That is usually intended as you cannot send arbitrary response headers with a 304 response (https://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3.5).")
        public boolean considerResponseHeaders() default true;

        @AttributeDefinition(name="Ignored Response Headers", description="The header names (case-insensitive) which should in no case be considered for the digest calculation as they are considered also for a 304 response (compare with https://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3.5).")
        public String[] ignoredResponseHeaders() default {"Date", "Cache-Control", "Expires", "Vary"};

        @AttributeDefinition(name="Salt", description="The (optional) salt is also taken into account for the message digest calculation. It is necessary to change that value whenever the response content or the response headers are now modified differently in a proxy instance between client and AEM (e.g. Dispatcher sets additional headers).")
        public String salt();

        @AttributeDefinition(name="Enabled for output streams", description="If set to 'true' this will also calculate the ETag for response output streams (binary output) and not only for response writers (text output). Enabling this option might lead to heavy memory demands as the full output stream is then buffered (i.e. kept in memory) before being delivered to the client. Especially if you deliver large assets like videos from AEM you should not enable this option.")
        public boolean enabledForOutputStream() default false;

        @AttributeDefinition(name="Add as HTML comment", description="If set to 'true' this filter will also emit a HTML comment at the very end of each HTML document exposing the ETag. This may be helpful to debug issues with stale HTML cache entries in case the ETag header is not properly propagated.")
        public boolean addAsHtmlComment() default false;
    }
}

