/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.fam.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;

public class ReusableResolver {
    private final ResourceResolver resolver;
    private int changeCount;
    private final int saveInterval;
    private final List<String> pendingItems;
    private String currentItem;

    public ReusableResolver(ResourceResolver res, int save) {
        this.resolver = res;
        this.changeCount = 0;
        this.saveInterval = save;
        this.pendingItems = new ArrayList<String>();
    }

    public void setCurrentItem(String current) {
        this.currentItem = current;
    }

    public String getCurrentItem() {
        return this.currentItem;
    }

    public void free() throws PersistenceException {
        if (this.getResolver().isLive()) {
            if (this.getResolver().hasChanges()) {
                this.setChangeCount(this.getChangeCount() + 1);
                this.getPendingItems().add(this.getCurrentItem());
            }
            if (this.getChangeCount() >= this.getSaveInterval()) {
                this.commit();
            }
        }
    }

    public void commit() throws PersistenceException {
        this.setChangeCount(0);
        if (this.getResolver().isLive() && this.getResolver().hasChanges()) {
            try {
                this.getResolver().commit();
            }
            catch (PersistenceException e) {
                this.getResolver().revert();
                this.getResolver().refresh();
                throw e;
            }
            finally {
                this.getPendingItems().clear();
            }
        }
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public ResourceResolver getResolver() {
        return this.resolver;
    }

    private void setChangeCount(int changeCount) {
        this.changeCount = changeCount;
    }

    public int getSaveInterval() {
        return this.saveInterval;
    }

    public List<String> getPendingItems() {
        return this.pendingItems;
    }
}

