/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.filefetch.impl;

import com.adobe.acs.commons.filefetch.FileFetchConfiguration;
import com.adobe.acs.commons.filefetch.FileFetcher;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.api.Rendition;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.Replicator;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.jcr.Session;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Runnable.class, FileFetcher.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"webconsole.configurationFactory.nameHint=File Fetcher for: {remoteUrl}, saving to: {damPath}"})
@Designate(ocd=FileFetchConfiguration.class, factory=true)
public class FileFetcherImpl
implements FileFetcher,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(FileFetcherImpl.class);
    private static final String SERVICE_USER_NAME = "file-fetch";
    protected FileFetchConfiguration config;
    @Reference
    private ResourceResolverFactory factory;
    private Exception lastException = null;
    private boolean lastJobSucceeded = true;
    private String lastModified = null;
    @Reference
    private Replicator replicator;

    @Activate
    public void activate(FileFetchConfiguration config) {
        log.info("Activing with configuration: {}", (Object)config);
        this.config = config;
        this.run();
    }

    @Override
    public FileFetchConfiguration getConfig() {
        return this.config;
    }

    @Override
    public Exception getLastException() {
        return this.lastException;
    }

    @Override
    public String getLastModified() {
        return this.lastModified;
    }

    @Override
    public boolean isLastJobSucceeded() {
        return this.lastJobSucceeded;
    }

    protected HttpURLConnection openConnection() throws IOException {
        return (HttpURLConnection)new URL(this.config.remoteUrl()).openConnection();
    }

    @Override
    public void run() {
        try {
            this.updateFile();
            this.lastJobSucceeded = true;
            this.lastException = null;
        }
        catch (Exception e) {
            log.warn("Failed to run fetch file job for {}", (Object)this.config.remoteUrl(), (Object)e);
            this.lastException = e;
            this.lastJobSucceeded = false;
        }
    }

    public void setFactory(ResourceResolverFactory factory) {
        this.factory = factory;
    }

    public void setReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    private HttpURLConnection setupConnection() throws IOException {
        log.trace("fetchFile");
        log.debug("Opening connection to {}", (Object)this.config.remoteUrl());
        HttpURLConnection con = this.openConnection();
        con.setConnectTimeout(this.config.timeout());
        List header = Arrays.stream(this.config.headers()).map(h -> h.split("\\=")).filter(h -> ((String[])h).length >= 2).map(h -> {
            String value = Arrays.stream((String[])ArrayUtils.remove((Object[])h, (int)0)).collect(Collectors.joining("="));
            return new ImmutablePair((Object)h[0], (Object)value);
        }).collect(Collectors.toList());
        for (Pair p : header) {
            log.trace("Adding request property {}={}", p.getKey(), p.getValue());
            con.addRequestProperty((String)p.getKey(), (String)p.getValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.lastModified)) {
            con.addRequestProperty("If-Modified-Since", this.lastModified);
        }
        con.setUseCaches(false);
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFile() throws IOException, ReplicationException {
        log.trace("updateFile");
        try (ResourceResolver resolver = this.factory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", SERVICE_USER_NAME));){
            block23: {
                AssetManager manager = Optional.ofNullable((AssetManager)resolver.adaptTo(AssetManager.class)).orElseThrow(() -> new PersistenceException("Failed to get Asset Manager"));
                HttpURLConnection con = null;
                try {
                    con = this.setupConnection();
                    int responseCode = con.getResponseCode();
                    if (responseCode == 304) {
                        log.debug("Received Not Modified status code, no further action required");
                        break block23;
                    }
                    if (Arrays.stream(this.config.validResponseCodes()).anyMatch(rc -> rc == responseCode)) {
                        log.debug("Received valid status code: {}", (Object)responseCode);
                        String path = this.config.damPath();
                        Resource assetResource = resolver.getResource(path);
                        Asset asset = null;
                        try (InputStream is = con.getInputStream();){
                            if (assetResource != null) {
                                asset = Optional.ofNullable((Asset)assetResource.adaptTo(Asset.class)).orElseThrow(() -> new PersistenceException("Failed to adapt Resource to Asset"));
                                log.debug("Updating asset: {}", (Object)path);
                                for (Rendition r : asset.getRenditions()) {
                                    asset.removeRendition(r.getName());
                                }
                                asset.removeRendition("original");
                                asset.addRendition("original", is, this.config.mimeType());
                            } else {
                                log.debug("Adding new asset: {}", (Object)path);
                                asset = manager.createAsset(path, is, this.config.mimeType(), true);
                                assetResource = Optional.ofNullable((Resource)asset.adaptTo(Resource.class)).orElseThrow(() -> new PersistenceException("Failed to adapt Asset to Resource"));
                            }
                        }
                        this.lastModified = con.getHeaderField("Last-Modified");
                        log.info("Replicating fetched file {}", (Object)path);
                        this.replicator.replicate((Session)resolver.adaptTo(Session.class), ReplicationActionType.ACTIVATE, path);
                        break block23;
                    }
                    log.warn("Received invalid status code: {}", (Object)responseCode);
                    throw new IOException("Received invalid status code: " + responseCode);
                }
                finally {
                    if (con != null) {
                        con.disconnect();
                    }
                }
            }
            log.debug("Update complete!");
        }
        catch (LoginException e) {
            log.error("Failed to get service user", (Throwable)e);
        }
    }
}

