/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.i18n.impl;

import acscommons.com.google.common.cache.Cache;
import acscommons.com.google.common.cache.CacheBuilder;
import com.adobe.acs.commons.i18n.I18nProvider;
import com.adobe.acs.commons.i18n.impl.Config;
import com.adobe.acs.commons.models.injectors.impl.InjectorUtils;
import com.adobe.acs.commons.util.impl.AbstractGuavaCacheMBean;
import com.adobe.acs.commons.util.impl.CacheMBean;
import com.adobe.acs.commons.util.impl.exception.CacheMBeanException;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Page;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.osgi.Order;
import org.apache.sling.commons.osgi.RankedServices;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.Designate;

@Component(property={"jmx.objectname=com.adobe.acs.commons.i18n:type=I18N Provider Cache"}, service={I18nProvider.class}, immediate=true, reference={@Reference(name="resourceBundleProviders", service=ResourceBundleProvider.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, bind="bindResourceBundleProvider", unbind="unbindResourceBundleProvider")})
@Designate(ocd=Config.class)
public class I18nProviderImpl
extends AbstractGuavaCacheMBean<String, I18n>
implements I18nProvider {
    private static final String JMX_PN_I18N = "I18n Object";
    private final RankedServices<ResourceBundleProvider> resourceBundleProviders = new RankedServices(Order.ASCENDING);
    private Cache<String, I18n> cache;

    public I18nProviderImpl() throws NotCompliantMBeanException {
        super(CacheMBean.class);
    }

    protected void bindResourceBundleProvider(ResourceBundleProvider resourceBundleProvider, Map<String, Object> props) {
        this.resourceBundleProviders.bind((Object)resourceBundleProvider, props);
    }

    protected void unbindResourceBundleProvider(ResourceBundleProvider resourceBundleProvider, Map<String, Object> props) {
        this.resourceBundleProviders.unbind((Object)resourceBundleProvider, props);
    }

    protected void activate(Config config) {
        long size = config.maxSizeCount();
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder().maximumSize(size).recordStats();
        long ttl = config.getTtl();
        if (ttl != -1L) {
            cacheBuilder.expireAfterWrite(ttl, TimeUnit.SECONDS);
        }
        this.cache = cacheBuilder.build();
    }

    @Override
    public String translate(String key, Resource resource) {
        I18n i18n = this.i18n(resource);
        if (i18n != null) {
            return i18n.get(key);
        }
        return null;
    }

    @Override
    public String translate(String key, Locale locale) {
        return I18n.get((ResourceBundle)this.getResourceBundle(locale), (String)key);
    }

    @Override
    public String translate(String key, HttpServletRequest request) {
        return I18n.get((HttpServletRequest)request, (String)key);
    }

    @Override
    public I18n i18n(Resource resource) {
        I18n cached = this.cache.getIfPresent(resource.getPath());
        if (cached != null) {
            return cached;
        }
        I18n i18n = this.i18n(this.getResourceBundleFromPageLocale(resource));
        this.cache.put(resource.getPath(), i18n);
        return i18n;
    }

    @Override
    public I18n i18n(Locale locale) {
        return this.i18n(this.getResourceBundle(locale));
    }

    @Override
    public I18n i18n(HttpServletRequest request) {
        return new I18n(request);
    }

    protected I18n i18n(ResourceBundle resourceBundle) {
        return new I18n(resourceBundle);
    }

    private ResourceBundle getResourceBundleFromPageLocale(Resource resource) {
        return this.getResourceBundle(this.getLocaleFromResource(resource));
    }

    private Locale getLocaleFromResource(Resource resource) {
        Page page = this.getResourcePage(resource);
        if (page != null) {
            return page.getLanguage(false);
        }
        return null;
    }

    protected Page getResourcePage(Resource resource) {
        return InjectorUtils.getResourcePage(resource);
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        for (ResourceBundleProvider provider : this.resourceBundleProviders) {
            ResourceBundle resourceBundle = provider.getResourceBundle(locale);
            if (resourceBundle == null) continue;
            return resourceBundle;
        }
        return null;
    }

    @Override
    protected Cache<String, I18n> getCache() {
        return this.cache;
    }

    @Override
    protected long getBytesLength(I18n cacheObj) {
        return 0L;
    }

    @Override
    protected void addCacheData(Map<String, Object> data, I18n cacheObj) {
        data.put(JMX_PN_I18N, cacheObj.toString());
    }

    @Override
    protected String toString(I18n cacheObj) throws CacheMBeanException {
        return cacheObj.toString();
    }

    @Override
    protected CompositeType getCacheEntryType() throws OpenDataException {
        return new CompositeType("Cache Entry", "Cache Entry", new String[]{"Cache Key", JMX_PN_I18N}, new String[]{"Cache Key", JMX_PN_I18N}, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
    }
}

