/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;

public class JcrJsonAdapter
extends TypeAdapter<Node> {
    public void write(JsonWriter writer, Node t) throws IOException {
        if (t != null) {
            try {
                writer.beginObject();
                PropertyIterator pi = t.getProperties();
                while (pi.hasNext()) {
                    Property p = (Property)pi.next();
                    writer.name(p.getName());
                    if (p.isMultiple()) {
                        writer.beginArray();
                        for (Value v : p.getValues()) {
                            this.writeValue(writer, v);
                        }
                        continue;
                    }
                    this.writeValue(writer, p.getValue());
                }
                NodeIterator ni = t.getNodes();
                while (ni.hasNext()) {
                    Node child = ni.nextNode();
                    writer.name(child.getName());
                    this.write(writer, child);
                }
                writer.endObject();
            }
            catch (RepositoryException ex) {
                throw new IOException(ex);
            }
        }
    }

    private void writeValue(JsonWriter writer, Value v) throws IOException, RepositoryException {
        switch (v.getType()) {
            case 2: {
                writer.value("(binary value)");
                break;
            }
            case 6: {
                writer.value(v.getBoolean());
                break;
            }
            case 3: 
            case 5: {
                writer.value(v.getLong());
                break;
            }
            case 4: 
            case 12: {
                writer.value(v.getDecimal().toPlainString());
                break;
            }
            default: {
                writer.value(v.getString());
            }
        }
    }

    public Node read(JsonReader reader) throws IOException {
        throw new UnsupportedOperationException("JcrJsonAdaper.read(JsonReader) is not supported yet.");
    }
}

