/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.form;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ModifiableValueMapDecorator;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class AbstractResourceImpl
extends AbstractResource {
    List<Resource> children = new ArrayList<Resource>();
    ResourceMetadata meta;
    ResourceResolver rr;
    Resource parent;
    String path;
    String type;
    String superType;

    public AbstractResourceImpl(String path, String resourceType, String resourceSuperType, ResourceMetadata metadata) {
        this.path = path;
        this.type = resourceType;
        this.superType = resourceSuperType;
        ResourceMetadata resourceMetadata = this.meta = metadata == null ? new ResourceMetadata() : metadata;
        if (resourceType != null) {
            this.meta.put("sling:resourceType", (Object)resourceType);
        }
        this.meta.put("jcr:primaryType", (Object)"nt:unstructured");
    }

    public <T> T adaptTo(Class<T> clazz) {
        if (clazz.equals(ModifiableValueMap.class)) {
            return (T)new ModifiableValueMapDecorator((Map)this.getValueMap());
        }
        if (clazz == ValueMap.class || clazz == Map.class) {
            return (T)this.getValueMap();
        }
        return null;
    }

    public void setResourceResolver(ResourceResolver rr) {
        this.rr = rr;
        this.children.forEach(r -> ((AbstractResourceImpl)((Object)r)).setResourceResolver(rr));
    }

    public void addChild(Resource res) {
        if (res instanceof AbstractResourceImpl) {
            String originalName;
            String name = originalName = res.getName();
            int seq = 1;
            while (this.getChildNamed(name) != null) {
                name = originalName + seq++;
            }
            AbstractResourceImpl child = (AbstractResourceImpl)res;
            child.parent = this;
            child.path = this.path + "/" + name;
            child.setResourceResolver(this.rr);
        }
        this.children.add(res);
    }

    public void removeChild(Resource res) {
        this.children.remove(res);
        if (res instanceof AbstractResourceImpl) {
            AbstractResourceImpl child = (AbstractResourceImpl)res;
            child.parent = null;
            if (child.path.startsWith("/")) {
                child.path = child.path.replaceFirst(this.path + "/", "");
            }
        }
    }

    public String getName() {
        return this.path.contains("/") ? StringUtils.substringAfterLast((String)this.path, (String)"/") : this.path;
    }

    public Resource getParent() {
        return this.parent;
    }

    public Resource getChild(String relPath) {
        if (relPath.startsWith("/")) {
            relPath = relPath.replace(this.getPath(), "");
        }
        AbstractResourceImpl current = this;
        for (String name : StringUtils.split((String)relPath, (String)"/")) {
            if (current instanceof AbstractResourceImpl) {
                if ((current = current.getChildNamed(name)) != null) continue;
                return null;
            }
            if (current.getChild(name) == null) {
                return null;
            }
            current = current.getChild(name);
        }
        return current;
    }

    public Resource getChildNamed(String name) {
        for (Resource child : this.getChildren()) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public Iterable<Resource> getChildren() {
        return this.children;
    }

    public Iterator<Resource> listChildren() {
        return this.children.iterator();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean isResourceType(String type) {
        return Objects.equals(this.getResourceType(), type);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public String getResourceType() {
        return this.type;
    }

    public String getResourceSuperType() {
        return this.superType;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.meta;
    }

    public ValueMap getValueMap() {
        return new ValueMapDecorator((Map)this.meta);
    }

    public ResourceResolver getResourceResolver() {
        return this.rr;
    }

    public AbstractResourceImpl cloneResource() {
        ResourceMetadata clonedMetadata = new ResourceMetadata();
        if (this.meta != null) {
            clonedMetadata.putAll((Map)this.meta);
        }
        AbstractResourceImpl clone = new AbstractResourceImpl(this.getPath(), this.getResourceType(), this.getResourceSuperType(), clonedMetadata);
        this.getChildren().forEach(child -> clone.addChild((Resource)((AbstractResourceImpl)((Object)child)).cloneResource()));
        return clone;
    }

    public void disableMergeResourceProvider() {
        this.getResourceMetadata().put("sling:hideChildren", (Object)"*");
        this.children.forEach(c -> ((AbstractResourceImpl)((Object)c)).disableMergeResourceProvider());
    }
}

