/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl;

import com.adobe.acs.commons.mcp.form.AbstractResourceImpl;
import com.adobe.acs.commons.mcp.form.DialogProvider;
import com.adobe.acs.commons.mcp.form.GeneratedDialog;
import com.adobe.acs.commons.mcp.form.GeneratedDialogWrapper;
import com.adobe.acs.commons.mcp.util.SyntheticResourceBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.commons.lang.reflect.MethodUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogResourceProviderImpl
extends ResourceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialogResourceProviderImpl.class);
    private String resourceType = "/unknown/type";
    private String root = "";
    private final GeneratedDialog dialog;
    private final AbstractResourceImpl resource;
    private final Class originalClass;
    private final boolean isComponent;

    public DialogResourceProviderImpl(Class c, DialogProvider annotation) throws InstantiationException, IllegalAccessException {
        this.originalClass = c;
        this.isComponent = annotation != null && annotation.style() == DialogProvider.DialogStyle.COMPONENT;
        this.dialog = GeneratedDialog.class.isAssignableFrom(c) ? (GeneratedDialog)c.newInstance() : new GeneratedDialogWrapper(c);
        this.dialog.initAnnotationValues(annotation);
        this.setResourceTypeFromClass();
        this.root = "/apps/" + this.resourceType + "/cq:dialog";
        AbstractResourceImpl formResource = (AbstractResourceImpl)this.dialog.getFormResource();
        AbstractResourceImpl formItems = ((AbstractResourceImpl)formResource.getChild("items")).cloneResource();
        SyntheticResourceBuilder rb = new SyntheticResourceBuilder(this.root, this.isComponent ? "cq/gui/components/authoring/dialog" : formResource.getResourceType());
        if (StringUtils.isNotBlank((String)this.dialog.getFormTitle())) {
            rb.withAttributes("jcr:title", this.dialog.getFormTitle());
        }
        rb.createChild("content", "granite/ui/components/coral/foundation/container");
        rb.withChild((Resource)formItems);
        this.resource = rb.build();
        this.resource.disableMergeResourceProvider();
    }

    private void setResourceTypeFromClass() throws IllegalAccessException, InstantiationException {
        Model modelAnnotation = this.originalClass.getAnnotation(Model.class);
        if (modelAnnotation != null && modelAnnotation.resourceType() != null && modelAnnotation.resourceType().length == 1) {
            this.resourceType = modelAnnotation.resourceType()[0];
        } else {
            try {
                Method getter = MethodUtils.getMatchingAccessibleMethod((Class)this.originalClass, (String)"getResourceType", (Class[])new Class[0]);
                if (getter != null) {
                    this.resourceType = String.valueOf(getter.invoke(this.originalClass.newInstance(), new Object[0]));
                } else {
                    Field field = FieldUtils.getField((Class)this.originalClass, (String)"resourceType", (boolean)true);
                    if (field != null) {
                        this.resourceType = String.valueOf(field.get(this.originalClass.newInstance()));
                    }
                }
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                LOGGER.debug("Unable to determine sling resource type for model bean: " + this.originalClass);
            }
        }
    }

    @CheckForNull
    public Resource getResource(@Nonnull ResolveContext resolveContext, @Nonnull String path, @Nonnull ResourceContext resourceContext, @CheckForNull Resource parent) {
        LOGGER.debug("Get resource at path: " + path);
        AbstractResourceImpl clone = null;
        if (this.root.equals(path)) {
            clone = this.resource.cloneResource();
        } else {
            if (parent != null && path.equals(parent.getPath())) {
                return parent;
            }
            String relPath = path.substring(this.root.length() + 1);
            LOGGER.debug("Relative path: " + relPath);
            AbstractResourceImpl child = (AbstractResourceImpl)this.resource.getChild(relPath);
            if (child != null) {
                clone = child.cloneResource();
            }
        }
        if (clone != null) {
            clone.setResourceResolver(resolveContext.getResourceResolver());
            clone.setPath(path);
        } else {
            LOGGER.debug("Unable to find node for " + path);
        }
        return clone;
    }

    @CheckForNull
    public Iterator<Resource> listChildren(@Nonnull ResolveContext resolveContext, @Nonnull Resource parent) {
        LOGGER.debug("List children of " + parent.getPath());
        if (parent instanceof AbstractResourceImpl) {
            AbstractResourceImpl res = (AbstractResourceImpl)parent;
            return res.listChildren();
        }
        return Collections.emptyIterator();
    }

    public String getRoot() {
        return this.root;
    }
}

