/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.FileUploadComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.SelectComponent;
import com.adobe.acs.commons.mcp.model.GenericReport;
import com.adobe.acs.commons.mcp.util.StringUtil;
import com.adobe.acs.commons.util.datadefinitions.ResourceDefinition;
import com.adobe.acs.commons.util.datadefinitions.ResourceDefinitionBuilder;
import com.adobe.acs.commons.util.datadefinitions.impl.BasicResourceDefinition;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetFolderCreator
extends ProcessDefinition
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(AssetFolderCreator.class);
    private static final long serialVersionUID = 4393712954263547160L;
    public static final String NAME = "Asset Folder Creator";
    protected transient Map<String, ResourceDefinitionBuilder> resourceDefinitionBuilders;
    @FormField(name="Excel File", description="Provide the .xlsx file that defines the Asset Folder taxonomy", component=FileUploadComponent.class, options={"mimeTypes=application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "required"})
    public transient InputStream excelFile = null;
    @FormField(name="Folder Type", description="", component=SelectComponent.EnumerationSelector.class, options={"default=UNORDERED_FOLDER", "required"})
    public FolderType assetFolderType = FolderType.UNORDERED_FOLDER;
    @FormField(name="Primary Creator", description="This will be used first and the Fallback will only be used if this fails to generate a valid Asset Folder definition.", component=SelectComponent.EnumerationSelector.class, options={"default=TITLE_AND_NODE_NAME", "required"})
    public AssetFolderBuilder primary = AssetFolderBuilder.TITLE_AND_NODE_NAME;
    @FormField(name="Fallback Creator", description="This is only invoked when the Primary cannot generate a valid Asset Folder definition. If this can also not generate a valid Asset Folder definition then the row will be skipped.", component=SelectComponent.EnumerationSelector.class, options={"default=LOWERCASE_WITH_DASHES", "required"})
    public AssetFolderBuilder fallback = AssetFolderBuilder.LOWERCASE_WITH_DASHES;
    volatile HashMap<String, AssetFolderDefinition> assetFolderDefinitions = new LinkedHashMap<String, AssetFolderDefinition>();
    private final transient GenericReport report = new GenericReport();
    private final ArrayList<EnumMap<ReportColumns, Object>> reportRows = new ArrayList();

    public AssetFolderCreator(Map<String, ResourceDefinitionBuilder> resourceDefinitionBuilders) {
        this.resourceDefinitionBuilders = resourceDefinitionBuilders;
    }

    @Override
    public void init() throws RepositoryException {
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        this.report.setName(instance.getName());
        instance.getInfo().setDescription(String.format("Create Asset Folders using [ %s / %s ]", StringUtil.getFriendlyName(this.primary.name()), StringUtil.getFriendlyName(this.fallback.name())));
        instance.defineCriticalAction("Parse Asset Folder definitions", rr, this::parseAssetFolderDefinitions);
        instance.defineCriticalAction("Create Asset Folders", rr, this::createAssetFolders);
    }

    public void parseAssetFolderDefinitions(ActionManager manager) throws Exception {
        manager.withResolver(rr -> {
            XSSFWorkbook workbook = new XSSFWorkbook(this.excelFile);
            this.excelFile.close();
            XSSFSheet sheet = workbook.getSheetAt(0);
            Iterator rows = sheet.rowIterator();
            while (rows.hasNext()) {
                this.parseAssetFolderRow((Row)rows.next());
            }
            log.info("Finished Parsing and collected [ {} ] asset folders for creation.", (Object)this.assetFolderDefinitions.size());
        });
    }

    private void parseAssetFolderRow(Row row) {
        Iterator cells = row.cellIterator();
        String previousAssetFolderPath = null;
        while (cells.hasNext()) {
            try {
                previousAssetFolderPath = this.parseAssetFolderCell((Cell)cells.next(), previousAssetFolderPath);
            }
            catch (IllegalArgumentException e) {
                break;
            }
        }
    }

    private String parseAssetFolderCell(Cell cell, String previousAssetFolderPath) throws IllegalArgumentException {
        cell.setCellType(1);
        String cellValue = StringUtils.trimToNull((String)cell.getStringCellValue());
        if (StringUtils.isNotBlank((CharSequence)cellValue)) {
            AssetFolderDefinition assetFolderDefinition = this.getAssetFolderDefinition(this.primary, cellValue, previousAssetFolderPath);
            if (assetFolderDefinition == null) {
                assetFolderDefinition = this.getAssetFolderDefinition(this.fallback, cellValue, previousAssetFolderPath);
            }
            if (assetFolderDefinition == null) {
                log.warn("Could not find a Asset Folder Converter that accepts value [ {} ]; skipping...", (Object)cellValue);
                this.record(ReportRowStatus.FAILED_TO_PARSE, "", cellValue);
                throw new IllegalArgumentException(String.format("Unable to parse value [ %s ]. Skipping rest of row to prevent undesired structured from being created.", cellValue));
            }
            if (this.assetFolderDefinitions.get(assetFolderDefinition.getId()) == null) {
                this.assetFolderDefinitions.put(assetFolderDefinition.getId(), assetFolderDefinition);
            }
            return assetFolderDefinition.getPath();
        }
        return previousAssetFolderPath;
    }

    public void createAssetFolders(ActionManager manager) {
        this.assetFolderDefinitions.values().stream().forEach(assetFolderDefinition -> {
            try {
                manager.withResolver(rr -> this.createAssetFolder((AssetFolderDefinition)assetFolderDefinition, (ResourceResolver)rr));
            }
            catch (Exception e) {
                log.error("Unable to import asset folders via ACS Commons MCP - Asset Folder Creator", (Throwable)e);
            }
        });
    }

    protected void createAssetFolder(AssetFolderDefinition assetFolderDefinition, ResourceResolver resourceResolver) {
        Resource folder = resourceResolver.getResource(assetFolderDefinition.getPath());
        try {
            ReportRowStatus status;
            if (folder == null) {
                HashMap<String, String> folderProperties = new HashMap<String, String>();
                folderProperties.put("jcr:primaryType", assetFolderDefinition.getNodeType());
                folder = resourceResolver.create(resourceResolver.getResource(assetFolderDefinition.getParentPath()), assetFolderDefinition.getName(), folderProperties);
                status = ReportRowStatus.CREATED;
            } else {
                status = ReportRowStatus.UPDATED_FOLDER_TITLES;
            }
            Resource jcrContent = folder.getChild("jcr:content");
            if (jcrContent == null) {
                HashMap<String, String> jcrContentProperties = new HashMap<String, String>();
                jcrContentProperties.put("jcr:primaryType", "nt:unstructured");
                resourceResolver.create(folder, "jcr:content", jcrContentProperties);
            }
            this.setTitles(folder, assetFolderDefinition);
            this.record(status, assetFolderDefinition.getPath(), assetFolderDefinition.getTitle());
            log.debug("Created Asset Folder [ {} -> {} ]", (Object)assetFolderDefinition.getPath(), (Object)assetFolderDefinition.getTitle());
        }
        catch (Exception e) {
            this.record(ReportRowStatus.FAILED_TO_CREATE, assetFolderDefinition.getPath(), assetFolderDefinition.getTitle());
            log.error("Unable to create Asset Folder [ {} -> {} ]", (Object)new String[]{assetFolderDefinition.getPath(), assetFolderDefinition.getTitle()}, (Object)e);
        }
    }

    private AssetFolderDefinition getAssetFolderDefinition(AssetFolderBuilder assetFolderBuilder, String value, String previousAssetFolderPath) {
        ResourceDefinitionBuilder resourceDefinitionBuilder = this.resourceDefinitionBuilders.get(assetFolderBuilder.name());
        if (resourceDefinitionBuilder != null && resourceDefinitionBuilder.accepts(value)) {
            return new AssetFolderDefinition(resourceDefinitionBuilder.convert(value), previousAssetFolderPath, this.assetFolderType);
        }
        return null;
    }

    private void setTitles(Resource folder, AssetFolderDefinition assetFolderDefinition) throws RepositoryException {
        if (folder == null) {
            log.error("Asset Folder resource [ {} ] is null", (Object)assetFolderDefinition.getPath());
            return;
        }
        Resource jcrContent = folder.getChild("jcr:content");
        if (jcrContent == null) {
            log.error("Asset Folder [ {} ] does not have a jcr:content child", (Object)assetFolderDefinition.getPath());
            return;
        }
        ModifiableValueMap properties = (ModifiableValueMap)jcrContent.adaptTo(ModifiableValueMap.class);
        if (!StringUtils.equals((CharSequence)assetFolderDefinition.getTitle(), (CharSequence)((CharSequence)properties.get("jcr:title", String.class)))) {
            properties.put((Object)"jcr:title", (Object)assetFolderDefinition.getTitle());
        }
    }

    private void record(ReportRowStatus status, String path, String title) {
        EnumMap<ReportColumns, String> row = new EnumMap<ReportColumns, String>(ReportColumns.class);
        row.put(ReportColumns.STATUS, StringUtil.getFriendlyName(status.name()));
        row.put(ReportColumns.ASSET_FOLDER_PATH, path);
        row.put(ReportColumns.ASSET_FOLDER_TITLE, title);
        this.reportRows.add(row);
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
        this.report.setRows(this.reportRows, ReportColumns.class);
        this.report.persist(rr, instance.getPath() + "/jcr:content/report");
    }

    protected static final class AssetFolderDefinition
    extends BasicResourceDefinition {
        private static final String ASSET_ROOT_PATH = "/content/dam";
        private String parentPath = null;
        private FolderType folderType;

        public AssetFolderDefinition(ResourceDefinition resourceDefinition, String parentPath, FolderType folderType) {
            super(resourceDefinition.getName());
            super.setTitle(resourceDefinition.getTitle());
            this.folderType = folderType;
            this.parentPath = (String)StringUtils.defaultIfBlank((CharSequence)parentPath, (CharSequence)ASSET_ROOT_PATH);
            super.setPath(this.parentPath + "/" + resourceDefinition.getName());
        }

        @Override
        public String getId() {
            return this.getPath();
        }

        public String getParentPath() {
            return this.parentPath;
        }

        public String getNodeType() {
            if (FolderType.ORDERED_FOLDER.equals((Object)this.folderType)) {
                return "sling:OrderedFolder";
            }
            return "sling:Folder";
        }
    }

    public static enum ReportRowStatus {
        CREATED,
        UPDATED_FOLDER_TITLES,
        FAILED_TO_PARSE,
        FAILED_TO_CREATE;

    }

    private static enum ReportColumns {
        STATUS,
        ASSET_FOLDER_PATH,
        ASSET_FOLDER_TITLE;

    }

    static enum FolderType {
        UNORDERED_FOLDER,
        ORDERED_FOLDER;

    }

    public static enum AssetFolderBuilder {
        TITLE_TO_NODE_NAME,
        TITLE_AND_NODE_NAME,
        LOWERCASE_WITH_DASHES,
        NONE;

    }
}

