/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.DatePickerComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.MultifieldComponent;
import com.adobe.acs.commons.mcp.model.GenericReport;
import com.adobe.acs.commons.workflow.bulk.removal.WorkflowInstanceRemover;
import com.adobe.acs.commons.workflow.bulk.removal.WorkflowRemovalStatus;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;

public class WorkflowRemover
extends ProcessDefinition {
    private static final int BATCH_SIZE = 1000;
    private static final int MAX_DURATION_MINS = 0;
    private final WorkflowInstanceRemover workflowInstanceRemover;
    private final transient GenericReport report = new GenericReport();
    private final transient List<EnumMap<ReportColumns, Object>> reportRows = new ArrayList<EnumMap<ReportColumns, Object>>();
    @FormField(name="Workflow Payload Paths", description="Payload path regex", hint="/content/dam/.*", component=MultifieldComponent.class)
    public List<String> payloadPaths;
    @FormField(name="Workflows Older Than", description="only remove workflows older than the specified date", component=DatePickerComponent.class)
    public String olderThanVal;
    @FormField(name="Workflow Models", description="If no Workflow Models are selected, Workflow Instances will not be filtered by Workflow Model.", component=MultifieldComponent.class, options={"use_class=com.adobe.acs.commons.mcp.form.workflow.WorkflowModelSelector"})
    public List<String> modelIds = new ArrayList<String>();
    private List<Pattern> payloads = new ArrayList<Pattern>();
    private Calendar olderThan;
    @FormField(name="Workflow Statuses", component=MultifieldComponent.class, required=true, options={"use_class=com.adobe.acs.commons.mcp.form.workflow.WorkflowStatusSelector"})
    public List<String> statuses = new ArrayList<String>();

    public WorkflowRemover(WorkflowInstanceRemover workflowInstanceRemover) {
        this.workflowInstanceRemover = workflowInstanceRemover;
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        instance.defineCriticalAction("Seek and Destroy Workflows", rr, this::performCleanupActivity);
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
        this.report.setRows(this.reportRows, ReportColumns.class);
        this.report.persist(rr, instance.getPath() + "/jcr:content/report");
    }

    @Override
    public void init() throws RepositoryException {
    }

    void performCleanupActivity(ActionManager manager) throws Exception {
        manager.withResolver(rr -> {
            this.parseParameters();
            this.workflowInstanceRemover.removeWorkflowInstances((ResourceResolver)rr, (Collection<String>)this.modelIds, (Collection<String>)this.statuses, (Collection<Pattern>)this.payloads, this.olderThan, 1000, 0);
            WorkflowRemovalStatus status = this.workflowInstanceRemover.getStatus();
            EnumMap<ReportColumns, Object> reportRow = this.report(status);
            this.reportRows.add(reportRow);
        });
    }

    EnumMap<ReportColumns, Object> report(WorkflowRemovalStatus status) {
        EnumMap<ReportColumns, Object> row = new EnumMap<ReportColumns, Object>(ReportColumns.class);
        row.put(ReportColumns.STARTED, status.getStartedAt());
        row.put(ReportColumns.CHECKED, Integer.valueOf(status.getChecked()));
        row.put(ReportColumns.REMOVED, Integer.valueOf(status.getRemoved()));
        row.put(ReportColumns.COMPLETED, status.getCompletedAt());
        row.put(ReportColumns.ERRED, status.getErredAt());
        row.put(ReportColumns.INITIATED_BY, status.getInitiatedBy());
        return row;
    }

    void parseParameters() throws ParseException {
        if (this.payloadPaths != null) {
            this.payloads = this.payloadPaths.stream().map(Pattern::compile).collect(Collectors.toList());
        }
        if (StringUtils.isNotEmpty((String)this.olderThanVal)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            Date d = sdf.parse(this.olderThanVal);
            this.olderThan = Calendar.getInstance();
            this.olderThan.setTime(d);
        }
    }

    public List<String> getModelIds() {
        return this.modelIds;
    }

    public List<Pattern> getPayloads() {
        return this.payloads;
    }

    public Calendar getOlderThan() {
        return this.olderThan;
    }

    public List<String> getStatuses() {
        return this.statuses;
    }

    public static enum ReportColumns {
        STARTED,
        CHECKED,
        REMOVED,
        COMPLETED,
        ERRED,
        INITIATED_BY;

    }
}

