/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.asset;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.functions.CheckedConsumer;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.CheckboxComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.PathfieldComponent;
import com.adobe.acs.commons.mcp.form.RadioComponent;
import com.adobe.acs.commons.mcp.impl.processes.asset.AssetIngestorException;
import com.adobe.acs.commons.mcp.impl.processes.asset.HierarchicalElement;
import com.adobe.acs.commons.mcp.impl.processes.asset.NameUtil;
import com.adobe.acs.commons.mcp.impl.processes.asset.NamesFilter;
import com.adobe.acs.commons.mcp.impl.processes.asset.Source;
import com.adobe.acs.commons.mcp.model.GenericReport;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.mime.MimeTypeService;

public abstract class AssetIngestor
extends ProcessDefinition {
    private static final String ALL_ASSETS = "All Assets";
    private static final int DEFAULT_TIMEOUT = 200;
    private static final int DEFAULT_RETRIES = 10;
    static final String[] AUTHORIZED_GROUPS = new String[]{"administrators", "asset-ingest", "dam-administrators"};
    public static final String PN_MIGRATED_FROM = "migratedFrom";
    protected final transient MimeTypeService mimetypeService;
    @FormField(name="Retry pause", description="Used as retry pause between createFolder, createAsset actions and etc...", options={"default=200"})
    int retryPause = 200;
    @FormField(name="Retries", description="Actions to attempt", options={"default=10"})
    int retries = 10;
    @FormField(name="Dry run", description="If checked, no import happens.  Useful for data validation", component=CheckboxComponent.class, options={"checked"})
    boolean dryRunMode = true;
    @FormField(name="Detailed report", description="If checked, information about every asset is recorded", component=CheckboxComponent.class, options={"checked"})
    boolean detailedReport = true;
    @FormField(name="Inhibit workflow", description="If checked, disables asset processing workflow", component=CheckboxComponent.class, options={"checked"})
    boolean inhibitWorkflow = true;
    @FormField(name="Preserve Filename", description="If checked, file name is preserved as asset name.  If unchecked, asset name will support only the following characters: letters, digits, hyphens, underscores, another chars will be replaced with hyphens", component=CheckboxComponent.class, options={"checked"})
    boolean preserveFileName = true;
    @FormField(name="Target JCR Folder", description="Prepended to target path if it does not begin with /content", hint="/content/dam", component=PathfieldComponent.FolderSelectComponent.class, required=true, options={"default=/content/dam", "base=/content/dam"})
    String jcrBasePath = "/content/dam";
    @FormField(name="Folders filter", description="Comma-delimited list of folders to filter, useful for bypassing thumnail folders and such. If you want to exclude folder name add '-' sign before name.If you want to include name, just write folder name or add '+' sign before name.", hint="tmp,.DS_STORE", options={"default=-tmp,-ds_store,-.ds_store,-.thumbs,-.appledouble"})
    String foldersFilterExpression = "-tmp,-ds_store,-.ds_store,-.thumbs,-.appledouble";
    NamesFilter folderFilter;
    @FormField(name="Files Filter", description="Comma-delimited list of files to filter, also useful for bypassing additional metadata files which might not be useful in a DAM setting. If you want to exclude file name add '-' sign before name.If you want to include name, just write file name or add '+' sign before name.", hint="full file names, comma separated", options={"default=-ds_store,-.ds_store"})
    String filesFilterExpression = "-ds_store,-.ds_store";
    NamesFilter fileFilter;
    @FormField(name="Extensions filter", description="Comma-delimited list of file extensions to filter. If you want to exclude extension add '-' sign before name.If you want to include extension, just write extension or add '+' sign before name", hint="mp4,txt, etc.", options={"default=-txt,-html,-css,-js,-thm,-exe,-db"})
    String extensionsFilterExpression = "-txt,-html,-css,-js,-thm,-exe,-db";
    NamesFilter extensionFilter;
    @FormField(name="Existing action", description="What to do if an asset exists", component=RadioComponent.EnumerationSelector.class, options={"default=skip", "vertical"})
    protected transient AssetAction existingAssetAction = AssetAction.skip;
    @FormField(name="Minimum size", description="Min size to import (in bytes), 0=none", hint="1024...", options={"default=1024"})
    private transient long minimumSize = 1024L;
    @FormField(name="Maximum size", description="Max size to import (in bytes), 0=none", hint="1gb = 1073741824", options={"default=1073741824"})
    private transient long maximumSize = 0x40000000L;
    protected static final String DEFAULT_FOLDER_TYPE = "sling:Folder";
    protected static final String CHANGED_BY_WORKFLOW = "changedByWorkflowProcess";
    EnumMap<ReportColumns, Object> createdFolders = this.trackActivity("All folders", "Create", "Count of all folders created", 0L);
    EnumMap<ReportColumns, Object> importedAssets = this.trackActivity("All Assets", "Import", "Count of all assets imports", 0L);
    EnumMap<ReportColumns, Object> skippedFiles = this.trackActivity("All Assets", "Skipped", "Count of skipped files", 0L);
    EnumMap<ReportColumns, Object> importedData = this.trackActivity("All Assets", "Data imported", "Count of bytes imported", 0L);
    private List<EnumMap<ReportColumns, Object>> reportRows;
    final Set<String> alreadyCreatedFolders = Collections.synchronizedSet(new TreeSet());
    private transient GenericReport report = new GenericReport();

    public AssetIngestor(MimeTypeService mimeTypeService) {
        this.mimetypeService = mimeTypeService;
    }

    private synchronized EnumMap<ReportColumns, Object> trackActivity(String item, String action, String description, Long bytes) {
        if (this.reportRows == null) {
            this.reportRows = Collections.synchronizedList(new ArrayList());
        }
        EnumMap<ReportColumns, Object> reportRow = new EnumMap<ReportColumns, Object>(ReportColumns.class);
        reportRow.put(ReportColumns.item, item);
        reportRow.put(ReportColumns.action, action);
        reportRow.put(ReportColumns.description, description);
        reportRow.put(ReportColumns.count, Long.valueOf(0L));
        reportRow.put(ReportColumns.bytes, bytes);
        this.reportRows.add(reportRow);
        return reportRow;
    }

    protected synchronized EnumMap<ReportColumns, Object> trackDetailedActivity(String item, String action, String description, Long bytes) {
        if (this.detailedReport) {
            return this.trackActivity(item, action, description, bytes);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increment(EnumMap<ReportColumns, Object> row, ReportColumns col, long amt) {
        if (row != null) {
            EnumMap<ReportColumns, Object> enumMap = row;
            synchronized (enumMap) {
                row.put(col, (Object)((Long)row.getOrDefault((Object)col, 0) + amt));
            }
        }
    }

    protected void incrementCount(EnumMap<ReportColumns, Object> row, long amt) {
        this.increment(row, ReportColumns.count, amt);
    }

    protected void incrementBytes(EnumMap<ReportColumns, Object> row, long amt) {
        this.increment(row, ReportColumns.bytes, amt);
    }

    protected long getCount(EnumMap<ReportColumns, Object> row) {
        return (Long)row.getOrDefault((Object)ReportColumns.count, 0);
    }

    @Override
    public void init() throws RepositoryException {
        if (this.foldersFilterExpression == null) {
            this.foldersFilterExpression = "";
        }
        this.folderFilter = new NamesFilter(this.foldersFilterExpression);
        if (this.filesFilterExpression == null) {
            this.filesFilterExpression = "";
        }
        this.fileFilter = new NamesFilter(this.filesFilterExpression);
        if (this.extensionsFilterExpression == null) {
            this.extensionsFilterExpression = "";
        }
        this.extensionFilter = new NamesFilter(this.extensionsFilterExpression);
        if (this.retries <= 0) {
            this.retries = 10;
        }
        if (this.retryPause <= 0) {
            this.retryPause = 200;
        }
        if (!this.preserveFileName) {
            this.jcrBasePath = NameUtil.createValidDamPath(this.jcrBasePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAsset(Source source, String assetPath, ResourceResolver r, boolean versioning) throws Exception {
        try {
            boolean versioned = false;
            if (!this.dryRunMode) {
                Asset asset;
                this.disableWorkflowProcessing(r);
                AssetManager assetManager = (AssetManager)r.adaptTo(AssetManager.class);
                String type = this.mimetypeService.getMimeType(source.getName());
                if (versioning) {
                    asset = (Asset)r.getResource(assetPath).adaptTo(Asset.class);
                    versioned = asset != null;
                    assetManager.createRevision(asset, "initial version of asset", asset.getName());
                    r.commit();
                    r.refresh();
                }
                if ((asset = assetManager.createAsset(assetPath, source.getStream(), type, false)) == null) {
                    AssetIngestorException ex = new AssetIngestorException("Cannot create asset: asset is null on path  " + assetPath);
                    throw ex;
                }
                this.saveMigrationInfo(source, asset);
                r.commit();
                r.refresh();
            }
            if (versioned) {
                this.trackDetailedActivity(assetPath, "Revised", "Created new version of asset", source.getLength());
            } else {
                this.trackDetailedActivity(assetPath, "Create", "Imported asset", source.getLength());
            }
            this.incrementBytes(this.importedData, source.getLength());
            this.incrementCount(this.importedAssets, 1L);
        }
        finally {
            source.close();
        }
    }

    void saveMigrationInfo(Source source, Asset asset) {
        ValueMap assetProperties;
        Resource assetResource = (Resource)asset.adaptTo(Resource.class);
        if (assetResource != null) {
            assetResource = assetResource.getChild("jcr:content");
        }
        if (assetResource != null && (assetProperties = (ValueMap)assetResource.adaptTo(ModifiableValueMap.class)) != null) {
            if (!StringUtils.equals((CharSequence)asset.getName(), (CharSequence)source.getName())) {
                assetProperties.put((Object)"jcr:title", (Object)source.getName());
            }
            assetProperties.put((Object)PN_MIGRATED_FROM, (Object)source.getElement().getItemName());
        }
    }

    protected void handleExistingAsset(Source source, String assetPath, ResourceResolver r) throws Exception {
        switch (this.existingAssetAction) {
            case skip: {
                if (r.getResource(assetPath) == null) {
                    this.createAsset(source, assetPath, r, false);
                    break;
                }
                this.incrementCount(this.skippedFiles, 1L);
                this.trackDetailedActivity(source.getElement().getSourcePath() + " -> " + assetPath, "Skip", "Skipped existing asset", 0L);
                break;
            }
            case replace: {
                this.createAsset(source, assetPath, r, false);
                break;
            }
            default: {
                this.versionExistingAsset(source, assetPath, r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createFolderNode(HierarchicalElement el, ResourceResolver r) throws RepositoryException, PersistenceException {
        String nodeName;
        String parentPath;
        if (el == null || !el.isFolder()) {
            return false;
        }
        if (this.dryRunMode) {
            return true;
        }
        String folderPath = el.getNodePath(this.preserveFileName);
        Set<String> set = this.alreadyCreatedFolders;
        synchronized (set) {
            if (this.alreadyCreatedFolders.contains(folderPath)) {
                return false;
            }
            this.alreadyCreatedFolders.add(folderPath);
        }
        String name = el.getName();
        Session s = (Session)r.adaptTo(Session.class);
        if (s.nodeExists(folderPath)) {
            Node folderContentNode;
            Node folderNode = s.getNode(folderPath);
            Node node = folderContentNode = folderNode.hasNode("jcr:content") ? folderNode.getNode("jcr:content") : null;
            if (folderNode.getPath().equals(this.jcrBasePath) || null != folderContentNode && folderContentNode.hasProperty("jcr:title") && folderContentNode.getProperty("jcr:title").getString().equals(name)) {
                return false;
            }
            this.setFolderTitle(folderNode, name);
            r.commit();
            r.refresh();
            return true;
        }
        HierarchicalElement parent = el.getParent();
        if (parent != null) {
            parentPath = parent.getNodePath(this.preserveFileName);
            nodeName = el.getNodeName(this.preserveFileName);
            if (!this.jcrBasePath.equals(parentPath)) {
                this.createFolderNode(parent, r);
            }
        } else {
            parentPath = StringUtils.substringBeforeLast((String)el.getNodePath(this.preserveFileName), (String)"/");
            nodeName = StringUtils.substringAfterLast((String)el.getNodePath(this.preserveFileName), (String)"/");
        }
        Node child = s.getNode(parentPath).addNode(nodeName, DEFAULT_FOLDER_TYPE);
        this.setFolderTitle(child, name);
        this.trackDetailedActivity(el.getNodePath(this.preserveFileName), "Create Folder", "Create folder", 0L);
        this.incrementCount(this.createdFolders, 1L);
        r.commit();
        r.refresh();
        return true;
    }

    private void setFolderTitle(Node child, String title) throws RepositoryException {
        if (!child.getPath().equals(this.jcrBasePath)) {
            if (child.hasNode("jcr:content")) {
                child.getNode("jcr:content").setProperty("jcr:title", title);
            } else {
                child.addNode("jcr:content", "nt:unstructured").setProperty("jcr:title", title);
            }
        }
    }

    private void versionExistingAsset(Source source, String assetPath, ResourceResolver r) throws Exception {
        this.createAsset(source, assetPath, r, r.getResource(assetPath) != null);
    }

    protected CheckedConsumer<ResourceResolver> importAsset(Source source, ActionManager actionManager) {
        return r -> {
            HierarchicalElement el = source.getElement();
            if (null != el) {
                this.createFolderNode(el.getParent(), (ResourceResolver)r);
                actionManager.setCurrentItem(el.getSourcePath());
                String path = el.getNodePath(this.preserveFileName);
                this.handleExistingAsset(source, path, (ResourceResolver)r);
            }
        };
    }

    protected boolean canImportFile(Source source) throws IOException {
        int extPos;
        String ext;
        String name = source.getName().toLowerCase();
        if (this.minimumSize > 0L && source.getLength() < this.minimumSize) {
            return false;
        }
        if (this.maximumSize > 0L && source.getLength() > this.maximumSize) {
            return false;
        }
        if (name.startsWith(".") || this.fileFilter.isNotValidName(name)) {
            return false;
        }
        return !name.contains(".") || !this.extensionFilter.isNotValidName(ext = name.substring((extPos = name.lastIndexOf(46)) + 1));
    }

    protected boolean canImportFolder(HierarchicalElement element) {
        String name = element.getName();
        if (this.folderFilter.isNotValidName(name.toLowerCase())) {
            return false;
        }
        HierarchicalElement parent = element.getParent();
        if (parent == null) {
            return true;
        }
        return this.canImportFolder(parent);
    }

    protected boolean canImportContainingFolder(HierarchicalElement element) {
        HierarchicalElement parent = element.getParent();
        if (parent == null) {
            return true;
        }
        return this.canImportFolder(parent);
    }

    protected void disableWorkflowProcessing(ResourceResolver rr) throws RepositoryException {
        if (this.inhibitWorkflow) {
            ((Session)rr.adaptTo(Session.class)).getWorkspace().getObservationManager().setUserData(CHANGED_BY_WORKFLOW);
        }
    }

    @Override
    public synchronized void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
        this.report.setRows(this.reportRows, ReportColumns.class);
        this.report.persist(rr, instance.getPath() + "/jcr:content/report");
    }

    public static enum ReportColumns {
        item,
        action,
        description,
        count,
        bytes;

    }

    public static enum AssetAction {
        skip,
        version,
        replace;

    }
}

