/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.asset;

import com.adobe.acs.commons.data.CompositeVariant;
import com.adobe.acs.commons.data.Spreadsheet;
import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.functions.CheckedConsumer;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.FileUploadComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.PasswordComponent;
import com.adobe.acs.commons.mcp.impl.processes.asset.AssetIngestor;
import com.adobe.acs.commons.mcp.impl.processes.asset.ClientProvider;
import com.adobe.acs.commons.mcp.impl.processes.asset.FileOrRendition;
import com.adobe.acs.commons.mcp.impl.processes.asset.Folder;
import com.adobe.acs.commons.mcp.impl.processes.asset.HierarchicalElement;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.api.Asset;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.mime.MimeTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlAssetImport
extends AssetIngestor {
    private static final String ACTION_SKIPPED = "Skipped";
    private static final String ACTION_UNMATCHED = "Unmatched";
    private static final String ACTION_IMPORT = "Import";
    public static final String SOURCE = "source";
    public static final String TARGET_FOLDER = "target";
    public static final String ORIGINAL_FILE_NAME = "original";
    public static final String RENDITION_NAME = "rendition";
    public static final String CONTENT_BASE = "/content";
    public static final String UNKNOWN_TARGET_FOLDER = "/content/dam/unsorted";
    private static final Logger LOG = LoggerFactory.getLogger(UrlAssetImport.class);
    private HttpClientBuilderFactory httpFactory;
    private HttpClient httpClient = null;
    @FormField(name="Import data file", description="Data file containing asset import data", component=FileUploadComponent.class)
    transient RequestParameter importFile;
    @FormField(name="Default prefix", description="Added to source if it starts with / e.g. file:/ | file:/C: | http://www.somewebsite", required=true, options={"default=file:/"})
    private String defaultPrefix = "file:/";
    @FormField(name="Connection timeout", description="HTTP Connection timeout (in milliseconds)", required=true, options={"default=30000"})
    private int timeout = 30000;
    @FormField(name="Username", description="Username for connections that require login", required=false)
    private String username = null;
    @FormField(name="Password", description="Password for connections that require login", required=false, component=PasswordComponent.class)
    private String password = null;
    transient Set<FileOrRendition> files;
    transient Map<String, Folder> folders = new TreeMap<String, Folder>((a, b) -> b.compareTo((String)a));
    private ClientProvider clientProvider = new ClientProvider();
    Spreadsheet fileData;
    EnumMap<AssetIngestor.ReportColumns, Object> importedRenditions = this.trackDetailedActivity("All Renditions", "Import", "Count of all rendition imports", 0L);
    Set<Map<String, CompositeVariant>> unmatchedRenditions = new HashSet<Map<String, CompositeVariant>>();

    public UrlAssetImport(MimeTypeService mimeTypeService, HttpClientBuilderFactory httpFactory) {
        super(mimeTypeService);
        this.httpFactory = httpFactory;
    }

    @Override
    public void init() throws RepositoryException {
        super.init();
        if (this.httpFactory != null) {
            HttpClientBuilder clientBuilder = this.httpFactory.newBuilder();
            clientBuilder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.timeout).build());
            clientBuilder.setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(this.timeout).build());
            this.httpClient = clientBuilder.build();
            this.clientProvider.setHttpClientSupplier(this::getHttpClient);
            this.clientProvider.setUsername(this.username);
            this.clientProvider.setPassword(this.password);
        }
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        try {
            this.fileData = new Spreadsheet(this.importFile, Arrays.asList(SOURCE, RENDITION_NAME, TARGET_FOLDER, ORIGINAL_FILE_NAME), new String[0]).buildSpreadsheet();
            this.files = this.extractFilesAndFolders(this.fileData.getDataRowsAsCompositeVariants());
            instance.getInfo().setDescription(String.format("Import %s (%s rows)", this.fileData.getFileName(), this.fileData.getRowCount()));
        }
        catch (IOException ex) {
            LOG.error("Unable to process import", (Throwable)ex);
            instance.getInfo().setDescription(String.format("Import %s (failed)", this.fileData.getFileName()));
            throw new RepositoryException("Unable to parse input file", (Throwable)ex);
        }
        this.trackUnmatchedRenditions();
        this.trackIgnoredFiles();
        instance.defineCriticalAction("Create Folders", rr, this::createFolders);
        instance.defineAction(String.format("Import %s Assets", this.files.size()), rr, this::importAssets);
        int countOfRenditions = this.files.stream().map(FileOrRendition::getRenditions).mapToInt(Map::size).sum();
        if (countOfRenditions > 0) {
            instance.defineAction(String.format("Import %s Renditions", countOfRenditions), rr, this::importRenditions);
        }
        instance.defineAction("Update Metadata", rr, this::updateMetadata);
    }

    private void trackIgnoredFiles() {
        this.files.stream().filter(f -> !this.canImportContainingFolder((HierarchicalElement)f)).forEach(file -> {
            this.trackDetailedActivity(file.getNodePath(this.preserveFileName), ACTION_SKIPPED, "Skipped file because its folder is also skipped", 0L);
            this.incrementCount(this.skippedFiles, 1 + file.getRenditions().size());
            file.getRenditions().forEach((renditionName, rendition) -> this.trackDetailedActivity(rendition.getNodePath(this.preserveFileName), ACTION_SKIPPED, "Skipped rendition " + renditionName + " because its parent file is skipped", 0L));
            file.getRenditions().clear();
        });
    }

    private void trackUnmatchedRenditions() {
        this.unmatchedRenditions.forEach(row -> {
            long rowNumber = this.fileData.getRowNum((Map<String, CompositeVariant>)row);
            this.trackDetailedActivity(((CompositeVariant)row.get(SOURCE)).toString(), ACTION_UNMATCHED, "Unable to track original asset for rendition, row " + rowNumber, 0L);
            this.incrementCount(this.skippedFiles, 1L);
        });
    }

    protected Set<FileOrRendition> extractFilesAndFolders(List<Map<String, CompositeVariant>> fileData) {
        Set<FileOrRendition> allFiles = fileData.stream().peek(this::extractFolder).map(this::extractFile).filter(t -> t != null).collect(Collectors.toSet());
        Set<FileOrRendition> renditions = allFiles.stream().filter(FileOrRendition::isRendition).collect(Collectors.toSet());
        allFiles.removeAll(renditions);
        renditions.forEach(r -> {
            Optional<FileOrRendition> asset = this.findOriginalRendition((Collection<FileOrRendition>)allFiles, (FileOrRendition)r);
            if (asset.isPresent()) {
                asset.get().addRendition((FileOrRendition)r);
            } else {
                this.unmatchedRenditions.add(r.getProperties());
            }
        });
        return allFiles;
    }

    protected void createFolders(ActionManager manager) throws IOException {
        manager.deferredWithResolver(r -> {
            JcrUtil.createPath((String)this.jcrBasePath, (String)"sling:Folder", (String)"sling:Folder", (Session)((Session)r.adaptTo(Session.class)), (boolean)true);
            this.folders.values().forEach(f -> manager.deferredWithResolver(Actions.retry(this.retries, this.retryPause, rr -> {
                manager.setCurrentItem(f.getSourcePath());
                this.createFolderNode((HierarchicalElement)f, (ResourceResolver)rr);
            })));
        });
    }

    protected void importAssets(ActionManager manager) throws IOException {
        manager.setCurrentItem(this.jcrBasePath);
        this.files.stream().filter(this::canImportContainingFolder).forEach(file -> manager.deferredWithResolver(rr -> {
            long lineNumber = this.fileData.getRowNum(file.getProperties());
            manager.setCurrentItem(String.format("Asset %s (line %s)", file.getItemName(), lineNumber));
            try {
                if (this.canImportFile(file.getSource())) {
                    manager.deferredWithResolver(Actions.retry(this.retries, this.retryPause, this.importAsset(file.getSource(), manager)));
                } else {
                    if (file.getSource().getLength() < 0L) {
                        this.incrementCount(this.skippedFiles, 1L);
                        throw new IOException("Unable to download " + file.getSourcePath());
                    }
                    this.incrementBytes(this.trackDetailedActivity(file.getNodePath(this.preserveFileName), ACTION_SKIPPED, "Skipped file of either file size or extension", 0L), file.getSource().getLength());
                    this.incrementCount(this.skippedFiles, 1L);
                }
            }
            finally {
                file.getSource().close();
            }
        }));
    }

    protected void importRenditions(ActionManager manager) throws IOException {
        manager.setCurrentItem(this.jcrBasePath);
        this.files.stream().filter(this::canImportContainingFolder).forEach(file -> this.importRenditions((FileOrRendition)file, manager));
    }

    private void importRenditions(FileOrRendition file, ActionManager manager) {
        file.getRenditions().forEach((rendition, renditionFile) -> manager.deferredWithResolver(Actions.retry(this.retries, this.retryPause, rr -> {
            try {
                long lineNumber = this.fileData.getRowNum(renditionFile.getProperties());
                manager.setCurrentItem(String.format("Rendition %s (line %s)", renditionFile.getItemName(), lineNumber));
                String renditionName = rendition;
                String type = this.mimetypeService.getMimeType(renditionFile.getName());
                String extension = renditionFile.getName().substring(renditionFile.getName().lastIndexOf(46) + 1).toLowerCase();
                if (renditionName.lastIndexOf(46) <= 0) {
                    renditionName = renditionName + "." + extension;
                }
                if (!this.dryRunMode) {
                    this.commitAndRefresh((ResourceResolver)rr);
                    Resource assetResource = rr.getResource(file.getNodePath(this.preserveFileName));
                    if (assetResource == null) {
                        throw new ResourceNotFoundException("Unable to find asset resource " + file.getNodePath(this.preserveFileName));
                    }
                    Asset asset = (Asset)assetResource.adaptTo(Asset.class);
                    asset.addRendition(renditionName, renditionFile.getSource().getStream(), type);
                }
                this.incrementCount(this.importedRenditions, 1L);
                this.incrementBytes(this.importedData, renditionFile.getSource().getLength());
                this.trackDetailedActivity(file.getNodePath(this.preserveFileName), "Import Rendition", "Add rendition " + renditionName, renditionFile.getSource().getLength());
            }
            finally {
                renditionFile.getSource().close();
            }
        })));
    }

    protected void updateMetadata(ActionManager manager) throws IOException {
        manager.setCurrentItem(this.jcrBasePath);
        this.files.stream().filter(this::canImportContainingFolder).forEach(file -> manager.deferredWithResolver(Actions.retry(this.retries, this.retryPause, this.updateMetadata((FileOrRendition)file))));
    }

    private CheckedConsumer<ResourceResolver> updateMetadata(FileOrRendition file) {
        return rr -> {
            if (this.dryRunMode) {
                return;
            }
            long lineNumber = this.fileData.getRowNum(file.getProperties());
            Actions.setCurrentItem(String.format("Metadata %s (line %s)", file.getItemName(), lineNumber));
            this.commitAndRefresh((ResourceResolver)rr);
            Resource metaResource = rr.getResource(file.getNodePath(this.preserveFileName) + "/jcr:content/metadata");
            if (metaResource == null) {
                throw new ResourceNotFoundException("Unable to find asset resource " + file.getNodePath(this.preserveFileName));
            }
            this.updateMetadataFromRow(file, (ModifiableValueMap)metaResource.adaptTo(ModifiableValueMap.class));
        };
    }

    public void commitAndRefresh(ResourceResolver rr) throws PersistenceException, RepositoryException {
        if (rr.hasChanges()) {
            rr.commit();
        }
        rr.refresh();
        this.disableWorkflowProcessing(rr);
    }

    public void updateMetadataFromRow(FileOrRendition file, ModifiableValueMap meta) {
        for (String prop : this.fileData.getHeaderRow()) {
            if (!prop.contains(":")) continue;
            CompositeVariant value = file.getProperty(prop);
            meta.remove((Object)prop);
            if (value == null || value.isEmpty()) continue;
            meta.put((Object)prop, value.toPropertyValue());
        }
    }

    private Folder extractFolder(Map<String, CompositeVariant> assetData) {
        String folderPath = this.getTargetFolder(assetData);
        if (!this.folders.containsKey(folderPath)) {
            String rootFolder = folderPath.replaceFirst(this.jcrBasePath, "");
            String[] parts = rootFolder.split(Pattern.quote("/"));
            Folder parent = null;
            String currentPath = this.jcrBasePath;
            for (int i = 1; i < parts.length; ++i) {
                String treePath = currentPath + "/" + parts[i];
                if (!this.folders.containsKey(treePath)) {
                    Folder folder = parent == null ? new Folder(parts[i], this.jcrBasePath, assetData.get(SOURCE).toString()) : new Folder(parts[i], parent, assetData.get(SOURCE).toString());
                    this.folders.put(treePath, folder);
                    parent = folder;
                } else {
                    parent = this.folders.get(treePath);
                }
                currentPath = treePath;
            }
        }
        return this.folders.get(folderPath);
    }

    private FileOrRendition extractFile(Map<String, CompositeVariant> assetData) {
        String source = assetData.get(SOURCE).toString();
        if (source == null) {
            return null;
        }
        if (source.startsWith("/")) {
            source = this.defaultPrefix + source;
        }
        String name = source.substring(source.lastIndexOf(47) + 1);
        Folder folder = this.extractFolder(assetData);
        FileOrRendition file = new FileOrRendition(this.clientProvider, name, source, folder, assetData);
        file.setAsRenditionOfImage(assetData.get(RENDITION_NAME) == null ? null : assetData.get(RENDITION_NAME).toString(), assetData.get(ORIGINAL_FILE_NAME) == null ? null : assetData.get(ORIGINAL_FILE_NAME).toString());
        return file;
    }

    private String getTargetFolder(Map<String, CompositeVariant> assetData) {
        String target;
        String string = target = assetData.get(TARGET_FOLDER) == null ? null : assetData.get(TARGET_FOLDER).toString();
        if (target == null || target.isEmpty()) {
            return UNKNOWN_TARGET_FOLDER;
        }
        if (!target.startsWith(CONTENT_BASE)) {
            return this.jcrBasePath + (target.startsWith("/") ? target : "/" + target);
        }
        return target;
    }

    private Optional<FileOrRendition> findOriginalRendition(Collection<FileOrRendition> allFiles, FileOrRendition rendition) {
        List filesInFolder = allFiles.stream().filter(f -> f.getParent().getNodePath(this.preserveFileName).equals(rendition.getParent().getNodePath(this.preserveFileName))).collect(Collectors.toList());
        if (filesInFolder.isEmpty()) {
            LOG.error("Unable to find any other files in directory " + rendition.getParent().getNodePath(this.preserveFileName));
            return Optional.empty();
        }
        String fileName = rendition.getOriginalAssetName() == null || rendition.getOriginalAssetName().isEmpty() ? rendition.getName().toLowerCase() : rendition.getOriginalAssetName().toLowerCase();
        filesInFolder.sort((a, b) -> this.compareName((FileOrRendition)a, (FileOrRendition)b, fileName));
        return Optional.of((FileOrRendition)filesInFolder.get(0));
    }

    private int compareName(FileOrRendition a, FileOrRendition b, String fileName) {
        int aDist = StringUtils.getLevenshteinDistance((String)a.getName().toLowerCase(), (String)fileName);
        int bDist = StringUtils.getLevenshteinDistance((String)b.getName().toLowerCase(), (String)fileName);
        return Integer.compare(aDist, bDist);
    }

    private HttpClient getHttpClient() {
        return this.httpClient;
    }
}

