/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.renovator;

import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.mcp.impl.processes.renovator.MovingException;
import com.adobe.acs.commons.mcp.impl.processes.renovator.MovingNode;
import com.adobe.acs.commons.mcp.impl.processes.renovator.ReplicatorQueue;
import com.adobe.acs.commons.mcp.impl.processes.renovator.Util;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MovingFolder
extends MovingNode {
    protected static final String DEFAULT_FOLDER_TYPE = "sling:Folder";
    private static final Logger LOG = LoggerFactory.getLogger(MovingFolder.class);

    @Override
    public boolean isCopiedBeforeMove() {
        return true;
    }

    @Override
    public boolean isSupposedToBeReferenced() {
        return false;
    }

    @Override
    public boolean isAbleToHaveChildren() {
        return true;
    }

    @Override
    public void move(ReplicatorQueue replicatorQueue, ResourceResolver rr) throws MovingException {
        try {
            Session session = (Session)rr.adaptTo(Session.class);
            session.getWorkspace().getObservationManager().setUserData("changedByWorkflowProcess");
            Resource source = rr.getResource(this.getSourcePath());
            this.createMissingTargetFolders(rr, source);
            String sourceJcrContent = this.getSourcePath() + "/" + "jcr:content";
            if (Util.resourceExists(rr, sourceJcrContent)) {
                Actions.getCurrentActionManager().deferredWithResolver(Actions.retry(5, 50L, rrr -> {
                    if (!Util.resourceExists(rrr, this.getDestinationPath() + "/" + "jcr:content")) {
                        Util.waitUntilResourceFound(rrr, this.getDestinationPath());
                        rrr.copy(sourceJcrContent, this.getDestinationPath());
                        rrr.commit();
                        rrr.refresh();
                    }
                }));
            }
            replicatorQueue.replicate(session, ReplicationActionType.DEACTIVATE, this.getSourcePath());
        }
        catch (ReplicationException | RepositoryException | PersistenceException e) {
            throw new MovingException(this.getSourcePath(), e);
        }
    }

    private void createMissingTargetFolders(ResourceResolver rr, Resource source) throws RepositoryException, PersistenceException, MovingException {
        if (!Util.resourceExists(rr, this.getDestinationPath())) {
            Actions.setCurrentItem(this.getSourcePath() + "->" + this.getDestinationPath());
            String targetParentPath = StringUtils.substringBeforeLast((String)this.getDestinationPath(), (String)"/");
            String targetName = StringUtils.substringAfterLast((String)this.getDestinationPath(), (String)"/");
            if (this.getParent() == null) {
                if (!Util.resourceExists(rr, this.getDestinationPath())) {
                    this.createFolderNode(targetParentPath, rr);
                }
            } else {
                Util.waitUntilResourceFound(rr, targetParentPath);
            }
            Resource destParent = rr.getResource(targetParentPath);
            LOG.info("Creating target for {}", (Object)this.getSourcePath());
            rr.create(destParent, targetName, this.getClonedProperties(source));
            rr.commit();
            rr.refresh();
        }
    }

    protected boolean createFolderNode(String folderPath, ResourceResolver r) throws RepositoryException, PersistenceException {
        Session s = (Session)r.adaptTo(Session.class);
        if (s.nodeExists(folderPath)) {
            return false;
        }
        String name = StringUtils.substringAfterLast((String)folderPath, (String)"/");
        String parentPath = StringUtils.substringBeforeLast((String)folderPath, (String)"/");
        this.createFolderNode(parentPath, r);
        s.getNode(parentPath).addNode(name, DEFAULT_FOLDER_TYPE);
        r.commit();
        r.refresh();
        return true;
    }
}

