/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.renovator;

import com.adobe.acs.commons.data.CompositeVariant;
import com.adobe.acs.commons.data.Spreadsheet;
import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.CheckboxComponent;
import com.adobe.acs.commons.mcp.form.FileUploadComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.PathfieldComponent;
import com.adobe.acs.commons.mcp.form.RadioComponent;
import com.adobe.acs.commons.mcp.form.TextfieldComponent;
import com.adobe.acs.commons.mcp.impl.processes.renovator.MovingAsset;
import com.adobe.acs.commons.mcp.impl.processes.renovator.MovingFolder;
import com.adobe.acs.commons.mcp.impl.processes.renovator.MovingNode;
import com.adobe.acs.commons.mcp.impl.processes.renovator.MovingPage;
import com.adobe.acs.commons.mcp.impl.processes.renovator.MovingResource;
import com.adobe.acs.commons.mcp.impl.processes.renovator.ReplicatorQueue;
import com.adobe.acs.commons.mcp.impl.processes.renovator.Util;
import com.adobe.acs.commons.mcp.model.GenericReport;
import com.adobe.acs.commons.mcp.model.ManagedProcess;
import com.adobe.acs.commons.util.visitors.TraversalException;
import com.adobe.acs.commons.util.visitors.TreeFilteringResourceVisitor;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.Replicator;
import com.day.cq.wcm.api.PageManagerFactory;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

public class Renovator
extends ProcessDefinition {
    private static final String DESTINATION_COL = "destination";
    private static final String SOURCE_COL = "source";
    private final PageManagerFactory pageManagerFactory;
    private final Replicator replicator;
    @FormField(name="Multiple moves", description="Excel spreadsheet for performing multiple moves", component=FileUploadComponent.class, required=false)
    private RequestParameter sourceFile;
    @FormField(name="Source", description="Select page/site to be moved for single move", hint="/content/my-site/en/my-page", component=PathfieldComponent.NodeSelectComponent.class, required=false, options={"base=/content"})
    private String sourceJcrPath;
    @FormField(name="Destination", description="Destination location (must include new name for source node even if same)", hint="Move: /content/new-place/my-page -OR- Rename: /content/new-place/new-name", component=PathfieldComponent.NodeSelectComponent.class, required=false, options={"base=/content"})
    private String destinationJcrPath;
    @FormField(name="Max References", description="Limit of how many page references to handle (max per page)", hint="-1 = All, 0 = None, etc.", component=TextfieldComponent.class, required=false, options={"default=-1"})
    private int maxReferences = -1;
    private String referenceSearchRoot = "/";
    @FormField(name="Publish", description="Self-managed handles publishing in-process where as Queue will add it to the system publish queue where progress is not tracked here.", component=RadioComponent.EnumerationSelector.class, options={"vertical", "default=SELF_MANAGED"})
    public PublishMethod publishMethod = PublishMethod.SELF_MANAGED;
    @FormField(name="Create versions", description="Create versions for anything being updated/replicated", component=CheckboxComponent.class, options={"checked"})
    private boolean createVerionsOnReplicate;
    @FormField(name="Update status", description="Updates status of content affected by this operation", component=CheckboxComponent.class, options={"checked"})
    private boolean updateStatus;
    @FormField(name="Extensive ACL checks", description="If checked, this evaluates ALL nodes.  If not checked, it only evaluates pages.", component=CheckboxComponent.class)
    private boolean extensiveACLChecks = false;
    @FormField(name="Dry run", description="This runs the ACL checks but doesn't do any actual work.", component=CheckboxComponent.class, options={"checked"})
    private boolean dryRun = true;
    @FormField(name="Detailed report", description="Record extra details in the report, can be rather extensive.  Not recommended for large jobs.", component=CheckboxComponent.class)
    private boolean detailedReport = false;
    private final transient String[] requiredMovePrivilegeNames = new String[]{"{http://www.jcp.org/jcr/1.0}read", "{http://www.jcp.org/jcr/1.0}write", "{http://www.jcp.org/jcr/1.0}removeChildNodes", "{http://www.jcp.org/jcr/1.0}removeNode", "{http://www.day.com/crx/1.0}replicate"};
    Privilege[] requiredMovePrivileges;
    private final transient String[] requiredPublishPrivilegeNames = new String[]{"{http://www.jcp.org/jcr/1.0}read", "{http://www.jcp.org/jcr/1.0}write", "{http://www.day.com/crx/1.0}replicate"};
    Privilege[] requiredPublishPrivileges;
    private final transient String[] requiredUpdatePrivilegeNames = new String[]{"{http://www.jcp.org/jcr/1.0}read", "{http://www.jcp.org/jcr/1.0}write"};
    Privilege[] requiredUpdatePrivileges;
    ReplicatorQueue replicatorQueue = new ReplicatorQueue();
    ReplicationOptions replicationOptions;
    private final Set<MovingNode> moves = Collections.synchronizedSet(new HashSet());
    private final Set<String> additionalTargetFolders = Collections.synchronizedSet(new TreeSet());
    final Map<String, String> movePaths = Collections.synchronizedMap(new HashMap());
    private static final String DAM_ROOT = "/content/dam";
    ManagedProcess instanceInfo;
    private final Map<String, EnumMap<Report, Object>> reportData = new LinkedHashMap<String, EnumMap<Report, Object>>();

    public Renovator(PageManagerFactory pageManagerFactory, Replicator replicator) {
        this.pageManagerFactory = pageManagerFactory;
        this.replicator = replicator;
    }

    @Override
    public void init() throws RepositoryException {
        this.replicationOptions = new ReplicationOptions();
        switch (this.publishMethod) {
            case SELF_MANAGED: {
                this.replicationOptions.setSynchronous(true);
                break;
            }
            default: {
                this.replicationOptions.setSynchronous(false);
            }
        }
        this.replicationOptions.setSuppressVersions(!this.createVerionsOnReplicate);
        this.replicationOptions.setSuppressStatusUpdate(!this.updateStatus);
        if (this.referenceSearchRoot == null || this.referenceSearchRoot.trim().isEmpty()) {
            this.referenceSearchRoot = "/";
        }
    }

    private void validateInputs(ResourceResolver res) throws RepositoryException {
        if (this.sourceFile != null && this.sourceFile.getSize() > 0L) {
            this.validateSpreadsheetInput();
        } else {
            this.validateSingleMoveInput();
        }
        for (Map.Entry<String, String> entry : this.movePaths.entrySet()) {
            String sourcePath = entry.getKey();
            String destinationPath = entry.getValue();
            this.validateMovePreconditions(res, sourcePath, destinationPath);
        }
    }

    private void validateMovePreconditions(ResourceResolver res, String sourcePath, String destinationPath) throws RepositoryException {
        if (destinationPath.contains(sourcePath + "/")) {
            throw new RepositoryException("Destination must be outside of source path");
        }
        if (!Util.resourceExists(res, sourcePath)) {
            if (!sourcePath.startsWith("/")) {
                throw new RepositoryException("Paths are not valid unless they start with a forward slash, you provided: " + sourcePath);
            }
            throw new RepositoryException("Unable to find source " + sourcePath);
        }
        if (!Util.resourceExists(res, destinationPath.substring(0, destinationPath.lastIndexOf(47)))) {
            if (!destinationPath.startsWith("/")) {
                throw new RepositoryException("Paths are not valid unless they start with a forward slash, you provided: " + destinationPath);
            }
            if (!destinationPath.startsWith(DAM_ROOT)) {
                throw new RepositoryException("Unable to find destination " + destinationPath);
            }
        }
        if (sourcePath.startsWith(DAM_ROOT) != destinationPath.startsWith(DAM_ROOT)) {
            throw new RepositoryException("Source and destination are incompatible (if one is in the DAM, then so should the other be in the DAM)");
        }
    }

    private void validateSingleMoveInput() throws RepositoryException {
        if (this.sourceJcrPath == null) {
            throw new RepositoryException("Source path should not be null if no file provided");
        }
        if (this.destinationJcrPath == null) {
            throw new RepositoryException("Destination path should not be null if no file provided");
        }
        this.movePaths.put(this.sourceJcrPath, this.destinationJcrPath);
    }

    private void validateSpreadsheetInput() throws RepositoryException {
        Spreadsheet sheet;
        try {
            sheet = new Spreadsheet(this.sourceFile, SOURCE_COL, DESTINATION_COL).buildSpreadsheet();
        }
        catch (IOException ex) {
            throw new RepositoryException("Unable to parse spreadsheet", (Throwable)ex);
        }
        if (!sheet.getHeaderRow().contains(SOURCE_COL) || !sheet.getHeaderRow().contains(DESTINATION_COL)) {
            throw new RepositoryException(MessageFormat.format("Spreadsheet should have two columns, respectively named {0} and {1}", SOURCE_COL, DESTINATION_COL));
        }
        sheet.getDataRowsAsCompositeVariants().forEach(row -> this.movePaths.put(((CompositeVariant)row.get(SOURCE_COL)).toString(), ((CompositeVariant)row.get(DESTINATION_COL)).toString()));
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        this.validateInputs(rr);
        this.instanceInfo = instance.getInfo();
        String desc = this.dryRun ? "DRY RUN: " : "";
        desc = desc + "Publish mode " + this.publishMethod.name().toLowerCase();
        instance.getInfo().setDescription(desc);
        this.requiredMovePrivileges = this.getPrivilegesFromNames(rr, this.requiredMovePrivilegeNames);
        this.requiredUpdatePrivileges = this.getPrivilegesFromNames(rr, this.requiredUpdatePrivilegeNames);
        this.requiredPublishPrivileges = this.getPrivilegesFromNames(rr, this.requiredPublishPrivilegeNames);
        instance.defineCriticalAction("Eval Struct", rr, this::identifyStructure);
        instance.defineCriticalAction("Eval Refs", rr, this::identifyReferences);
        instance.defineCriticalAction("Check ACLs", rr, this::validateAllAcls);
        if (!this.dryRun) {
            instance.defineCriticalAction("Build destination", rr, this::buildStructures);
            instance.defineCriticalAction("Move Tree", rr, this::moveTree);
            if (this.publishMethod != PublishMethod.NONE) {
                instance.defineAction("Activate Tree", rr, this::activateTreeStructure);
                instance.defineAction("Activate New", rr, this::activateNew);
                instance.defineAction("Activate References", rr, this::activateReferences);
                instance.defineAction("Deactivate Old", rr, this::deactivateOld);
            }
            instance.defineAction("Remove source", rr, this::removeSource);
        }
    }

    protected void identifyStructure(ActionManager manager) {
        manager.deferredWithResolver(rr -> {
            AtomicInteger visitedSourceNodes = new AtomicInteger();
            this.movePaths.forEach((source, dest) -> manager.deferredWithResolver(rr2 -> {
                Resource res = rr2.getResource(source);
                Optional<MovingNode> rootNode = this.buildMoveNode(res);
                if (rootNode.isPresent()) {
                    this.identifyStructureFromRoot(visitedSourceNodes, (String)source, (String)dest, (ResourceResolver)rr2, res, rootNode.get());
                }
            }));
        });
    }

    private void identifyStructureFromRoot(AtomicInteger visitedSourceNodes, String source, String dest, ResourceResolver rr, Resource res, MovingNode root) throws TraversalException {
        String destFolder;
        root.setDestinationPath(dest);
        if (root instanceof MovingAsset && !this.additionalTargetFolders.contains(destFolder = StringUtils.substringBeforeLast((String)dest, (String)"/")) && rr.getResource(destFolder) == null) {
            this.additionalTargetFolders.add(destFolder);
        }
        this.moves.add(root);
        this.note(source, Report.misc, "Root path");
        this.note(source, Report.target, dest);
        TreeFilteringResourceVisitor visitor = new TreeFilteringResourceVisitor("nt:folder", "sling:Folder", "sling:OrderedFolder", "cq:Page");
        visitor.setResourceVisitorChecked((r, level) -> this.buildMoveTree((Resource)r, (int)level, root, visitedSourceNodes));
        visitor.setLeafVisitorChecked((r, level) -> this.buildMoveTree((Resource)r, (int)level, root, visitedSourceNodes));
        visitor.accept(res);
        this.note("All scanned nodes", Report.misc, "Scanned " + visitedSourceNodes.get() + " source nodes.");
    }

    private void buildMoveTree(Resource r, int level, MovingNode root, AtomicInteger visitedSourceNodes) throws RepositoryException {
        if (level > 0) {
            Actions.setCurrentItem(r.getPath());
            Optional<MovingNode> node = this.buildMoveNode(r);
            if (node.isPresent()) {
                MovingNode childNode = node.get();
                String parentPath = StringUtils.substringBeforeLast((String)r.getPath(), (String)"/");
                MovingNode parent = root.findByPath(parentPath).orElseThrow(() -> new RepositoryException("Unable to find data structure for node " + parentPath));
                parent.addChild(childNode);
                if (this.detailedReport) {
                    this.note(childNode.getSourcePath(), Report.target, childNode.getDestinationPath());
                }
                visitedSourceNodes.addAndGet(1);
            }
        }
    }

    private Optional<MovingNode> buildMoveNode(Resource res) throws RepositoryException {
        String type = (String)res.getValueMap().get("jcr:primaryType", String.class);
        MovingNode node = null;
        switch (type) {
            case "nt:folder": 
            case "sling:Folder": 
            case "sling:OrderedFolder": {
                node = new MovingFolder();
                break;
            }
            case "cq:Page": {
                node = new MovingPage(this.pageManagerFactory);
                break;
            }
            case "dam:Asset": {
                node = new MovingAsset();
                break;
            }
            case "nt:unstructured": {
                if (res.getName().equals("jcr:content")) {
                    return Optional.empty();
                }
                node = new MovingResource();
                break;
            }
            case "cq:CommentAttachment": {
                node = new MovingResource();
                break;
            }
            case "rep:ACL": {
                node = new MovingResource();
                break;
            }
            case "cq:PageContent": {
                break;
            }
            default: {
                throw new RepositoryException("Type " + type + " is not supported at this time!");
            }
        }
        if (node == null) {
            return Optional.empty();
        }
        node.setSourcePath(res.getPath());
        return Optional.of(node);
    }

    public void findReferences(ResourceResolver rr, MovingNode node) throws IllegalAccessException {
        node.findReferences(rr, this.referenceSearchRoot, this.maxReferences);
    }

    protected void identifyReferences(ActionManager manager) {
        AtomicInteger discoveredReferences = new AtomicInteger();
        manager.deferredWithResolver(rr -> this.moves.forEach(node -> manager.deferredWithResolver(rr2 -> node.visit(childNode -> {
            if (childNode.isSupposedToBeReferenced()) {
                manager.deferredWithResolver(rr3 -> {
                    Actions.setCurrentItem("Looking for references to " + childNode.getSourcePath());
                    this.findReferences((ResourceResolver)rr3, (MovingNode)childNode);
                    discoveredReferences.addAndGet(childNode.getAllReferences().size());
                    if (this.detailedReport) {
                        this.note(childNode.getSourcePath(), Report.all_references, childNode.getAllReferences().size());
                        this.note(childNode.getSourcePath(), Report.published_references, childNode.getPublishedReferences().size());
                    }
                });
            }
        }))));
        manager.onFinish(() -> this.note("All discovered references", Report.misc, "Discovered " + discoveredReferences.get() + " references."));
    }

    protected void validateAllAcls(ActionManager manager) {
        manager.deferredWithResolver(rr -> this.moves.forEach(node -> manager.deferredWithResolver(rr2 -> node.visit(childNode -> manager.deferredWithResolver(rr3 -> this.validateAcls((MovingNode)childNode, (ResourceResolver)rr3))))));
    }

    private void validateAcls(MovingNode childNode, ResourceResolver rr3) throws RepositoryException {
        try {
            Actions.setCurrentItem("Checking ACLs on " + childNode.getSourcePath());
            this.checkNodeAcls(rr3, childNode.getSourcePath(), this.requiredMovePrivileges);
            for (String ref : childNode.getAllReferences()) {
                Actions.setCurrentItem("Checking ACLs on " + ref + " which references " + childNode.getSourcePath());
                this.validateAclsForReference(childNode, rr3, ref);
            }
            if (this.detailedReport) {
                this.note(childNode.getSourcePath(), Report.acl_check, "Passed");
            }
        }
        catch (Exception e) {
            this.note(childNode.getSourcePath(), Report.acl_check, "Failed");
            throw e;
        }
    }

    private void validateAclsForReference(MovingNode childNode, ResourceResolver rr, String ref) throws RepositoryException {
        if (this.publishMethod != PublishMethod.NONE && childNode.getPublishedReferences().contains(ref)) {
            this.checkNodeAcls(rr, childNode.getSourcePath(), this.requiredPublishPrivileges);
        } else {
            this.checkNodeAcls(rr, childNode.getSourcePath(), this.requiredUpdatePrivileges);
        }
    }

    protected void buildStructures(ActionManager manager) {
        manager.deferredWithResolver(rr -> {
            this.moves.forEach(node -> manager.deferredWithResolver(rr2 -> node.visit(childNode -> manager.deferredWithResolver(rr3 -> {
                Actions.setCurrentItem("Building structure for " + childNode.getSourcePath());
                childNode.move(this.replicatorQueue, (ResourceResolver)rr3);
            }), null, MovingNode::isCopiedBeforeMove)));
            this.additionalTargetFolders.forEach(path -> manager.deferredWithResolver(rr2 -> {
                Actions.setCurrentItem("Building structure for " + path);
                this.performNecessaryReplicationOnAncestors((ResourceResolver)rr2, (String)path);
                ResourceUtil.getOrCreateResource((ResourceResolver)rr2, (String)path, (Map)Collections.EMPTY_MAP, (String)"sling:Folder", (boolean)false);
                if (this.detailedReport) {
                    this.note((String)path, Report.misc, "Created additional destination folder");
                }
            }));
        });
    }

    protected void moveTree(ActionManager manager) {
        manager.deferredWithResolver(rr -> this.moves.forEach(node -> manager.deferredWithResolver(rr2 -> node.visit(childNode -> {
            if (!childNode.isCopiedBeforeMove() || !Util.resourceExists(rr2, childNode.getDestinationPath())) {
                manager.deferredWithResolver(rr3 -> {
                    Actions.setCurrentItem("Moving " + childNode.getSourcePath());
                    childNode.move(this.replicatorQueue, (ResourceResolver)rr3);
                });
            }
        }))));
    }

    protected void activateTreeStructure(ActionManager manager) {
        manager.deferredWithResolver(rr -> this.moves.forEach(node -> manager.deferredWithResolver(rr2 -> node.visit(childNode -> manager.deferredWithResolver(rr3 -> {
            Actions.setCurrentItem("Replicating " + childNode.getDestinationPath());
            this.performNecessaryReplication((ResourceResolver)rr3, childNode.getDestinationPath());
        }), null, MovingNode::isCopiedBeforeMove))));
    }

    protected void activateNew(ActionManager step3) {
        step3.deferredWithResolver(rr -> this.getAllActivationPaths().filter(this::isActivationPath).forEach(path -> step3.deferredWithResolver(rr2 -> {
            Actions.setCurrentItem("Replicating " + path);
            this.performNecessaryReplication((ResourceResolver)rr2, (String)path);
        })));
    }

    protected void activateReferences(ActionManager step4) {
        step4.deferredWithResolver(rr -> this.getAllReplicationPaths().filter(this::isForeignPath).forEach(path -> step4.deferredWithResolver(rr2 -> {
            Actions.setCurrentItem("Replicating references " + path);
            this.performNecessaryReplication((ResourceResolver)rr2, (String)path);
        })));
    }

    protected void deactivateOld(ActionManager step5) {
        step5.deferredWithResolver(rr -> this.getAllReplicationPaths().filter(this::isDeactivationPath).forEach(path -> step5.deferredWithResolver(rr2 -> {
            Actions.setCurrentItem("Deactivating " + path);
            this.performNecessaryReplication((ResourceResolver)rr2, (String)path);
        })));
    }

    protected boolean isDeactivationPath(String path) {
        boolean result = false;
        for (Map.Entry<String, String> mapping : this.movePaths.entrySet()) {
            String sourcePath = mapping.getKey();
            String destinationPath = mapping.getValue();
            if (path.startsWith(sourcePath)) {
                result = true;
                continue;
            }
            if (!path.startsWith(destinationPath)) continue;
            return false;
        }
        return result;
    }

    protected boolean isActivationPath(String path) {
        return !this.isDeactivationPath(path);
    }

    protected boolean isForeignPath(String path) {
        for (Map.Entry<String, String> mapping : this.movePaths.entrySet()) {
            String sourcePath = mapping.getKey();
            String destinationPath = mapping.getValue();
            if (!path.startsWith(sourcePath) && !path.startsWith(destinationPath)) continue;
            return false;
        }
        return true;
    }

    protected void removeSource(ActionManager manager) {
        manager.deferredWithResolver(rr -> {
            for (MovingNode node : this.moves) {
                rr.delete(rr.resolve(node.getSourcePath()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void note(String page, Report col, Object value) {
        Map<String, EnumMap<Report, Object>> map = this.reportData;
        synchronized (map) {
            if (!this.reportData.containsKey(page)) {
                this.reportData.put(page, new EnumMap(Report.class));
            }
            this.reportData.get(page).put(col, value);
        }
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
        GenericReport report = new GenericReport();
        report.setRows(this.reportData, SOURCE_COL, Report.class);
        report.persist(rr, instance.getPath() + "/jcr:content/report");
    }

    private Privilege[] getPrivilegesFromNames(ResourceResolver res, String[] names) throws RepositoryException {
        Session session = (Session)res.adaptTo(Session.class);
        AccessControlManager acm = session.getAccessControlManager();
        Privilege[] prvlgs = new Privilege[names.length];
        for (int i = 0; i < names.length; ++i) {
            prvlgs[i] = acm.privilegeFromName(names[i]);
        }
        return prvlgs;
    }

    public void checkNodeAcls(ResourceResolver res, String path, Privilege[] prvlgs) throws RepositoryException {
        Actions.setCurrentItem(path);
        Session session = (Session)res.adaptTo(Session.class);
        boolean report = res.getResource(path).getResourceType().equals("cq:Page");
        if (!session.getAccessControlManager().hasPrivileges(path, prvlgs)) {
            this.note(path, Report.acl_check, "FAIL");
            throw new RepositoryException("Insufficient permissions to permit move operation");
        }
        if (report) {
            this.note(path, Report.acl_check, "PASS");
        }
    }

    private String reversePathLookup(String path) {
        Iterator<Map.Entry<String, String>> iterator = this.movePaths.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, String> mapping = iterator.next();
            String sourcePath = mapping.getKey();
            String destinationPath = mapping.getValue();
            if (path.startsWith(destinationPath)) {
                return path.replaceAll(Pattern.quote(destinationPath), sourcePath);
            }
            return path;
        }
        return null;
    }

    private Stream<String> getAllActivationPaths() {
        TreeSet<String> allPaths = new TreeSet<String>();
        this.moves.forEach(n -> n.visit(node -> allPaths.addAll(node.getPublishedReferences())));
        allPaths.addAll(this.replicatorQueue.getActivateOperations().keySet());
        return allPaths.stream();
    }

    private Stream<String> getAllReplicationPaths() {
        return Stream.concat(this.replicatorQueue.getActivateOperations().keySet().stream(), this.replicatorQueue.getDeactivateOperations().keySet().stream()).distinct();
    }

    private void performNecessaryReplication(ResourceResolver rr, String path) throws ReplicationException {
        boolean isDeactivation = this.isDeactivationPath(path);
        ReplicationActionType action = isDeactivation ? ReplicationActionType.DEACTIVATE : ReplicationActionType.ACTIVATE;
        long start = System.currentTimeMillis();
        if (!this.dryRun) {
            this.replicator.replicate((Session)rr.adaptTo(Session.class), action, path);
        }
        long end = System.currentTimeMillis();
        if (isDeactivation) {
            this.note(path, Report.deactivate_time, end - start);
        } else {
            this.note(this.reversePathLookup(path), Report.activate_time, end - start);
        }
    }

    private void performNecessaryReplicationOnAncestors(ResourceResolver rr, String path) throws ReplicationException {
        String checkPath = "";
        for (String part : path.split(Pattern.quote("/"))) {
            if (part.isEmpty() || rr.getResource(checkPath = checkPath + "/" + part) != null) continue;
            this.performNecessaryReplication(rr, checkPath);
        }
    }

    static enum Report {
        misc,
        target,
        acl_check,
        all_references,
        published_references,
        move_time,
        activate_time,
        deactivate_time;

    }

    public static enum PublishMethod {
        NONE,
        SELF_MANAGED,
        QUEUE;

    }
}

