/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.renovator;

import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationContentFilter;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.replication.Replicator;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Session;

public class ReplicatorQueue
implements Replicator {
    private Map<String, ReplicationOptions> deactivateOperations = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, ReplicationOptions> activateOperations = Collections.synchronizedMap(new LinkedHashMap());

    public void replicate(Session session, ReplicationActionType actionType, String path) throws ReplicationException {
        this.replicate(session, actionType, path, null);
    }

    public void replicate(Session session, ReplicationActionType actionType, String path, ReplicationOptions replicationOptions) throws ReplicationException {
        Map<String, ReplicationOptions> queue;
        switch (actionType) {
            case ACTIVATE: {
                queue = this.getActivateOperations();
                break;
            }
            case DEACTIVATE: 
            case DELETE: {
                queue = this.getDeactivateOperations();
                break;
            }
            default: {
                queue = null;
            }
        }
        if (queue != null) {
            queue.put(path, replicationOptions);
        }
    }

    public void replicate(Session session, ReplicationActionType replicationActionType, String[] paths, ReplicationOptions replicationOptions) throws ReplicationException {
        for (String path : paths) {
            this.replicate(session, replicationActionType, path, replicationOptions);
        }
    }

    public void checkPermission(Session sn, ReplicationActionType rat, String string) throws ReplicationException {
    }

    public ReplicationStatus getReplicationStatus(Session sn, String string) {
        return null;
    }

    public Iterator<String> getActivatedPaths(Session session, String s) throws ReplicationException {
        return this.getActivateOperations().keySet().iterator();
    }

    @Deprecated
    public List<ReplicationContentFilter> createContentFilterChain(ReplicationAction action) {
        throw new UnsupportedOperationException("ReplicatorQueue.createContentFilterChain not supported and is deprecated.");
    }

    public Map<String, ReplicationOptions> getDeactivateOperations() {
        return this.deactivateOperations;
    }

    public Map<String, ReplicationOptions> getActivateOperations() {
        return this.activateOperations;
    }
}

