/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.model;

import com.adobe.acs.commons.mcp.model.ValueFormat;
import com.adobe.acs.commons.mcp.util.StringUtil;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={Resource.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@ProviderType
public class GenericReport {
    public static final String GENERIC_REPORT_RESOURCE_TYPE = "acs-commons/components/utilities/process-instance/process-generic-report";
    @Inject
    private List<String> columns;
    @Inject
    private List<ValueMap> rows;
    @Inject
    private String name = "report";

    public String getResourceType() {
        return GENERIC_REPORT_RESOURCE_TYPE;
    }

    public void persist(ResourceResolver rr, String path) throws PersistenceException, RepositoryException {
        ModifiableValueMap jcrContent = (ModifiableValueMap)ResourceUtil.getOrCreateResource((ResourceResolver)rr, (String)path, (String)this.getResourceType(), null, (boolean)false).adaptTo(ModifiableValueMap.class);
        jcrContent.put((Object)"jcr:primaryType", (Object)"nt:unstructured");
        jcrContent.put((Object)"columns", (Object)this.getColumns().toArray(new String[0]));
        jcrContent.put((Object)"name", (Object)this.name);
        rr.commit();
        rr.refresh();
        JcrUtil.createPath((String)(path + "/rows"), (String)"nt:unstructured", (Session)((Session)rr.adaptTo(Session.class)));
        int rowCounter = 0;
        for (Map map : this.rows) {
            Map<String, Object> properties = map.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            ResourceUtil.getOrCreateResource((ResourceResolver)rr, (String)(path + "/rows/row-" + ++rowCounter), properties, null, (boolean)true);
        }
        rr.commit();
        rr.refresh();
    }

    public <E extends Enum<E>, V> void setRows(Map<String, EnumMap<E, V>> reportData, String keyName, Class<E> enumClass) throws PersistenceException, RepositoryException {
        this.getColumns().clear();
        this.getColumns().add(keyName);
        Stream.of(new Object[0]).map(Object::toString).collect(Collectors.toCollection(this::getColumns));
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            this.getColumns().add(e.toString());
            ValueFormat format = ValueFormat.forField(e);
            if (format.columnCount <= 1) continue;
            this.getColumns().add(e.toString() + format.suffix);
        }
        this.getRows().clear();
        reportData.forEach((path, row) -> {
            LinkedHashMap<String, Object> rowData = new LinkedHashMap<String, Object>();
            rowData.put(keyName, path);
            for (Enum c : (Enum[])enumClass.getEnumConstants()) {
                if (!row.containsKey(c)) continue;
                ValueFormat format = ValueFormat.forField(c);
                rowData.put(c.toString(), row.get(c));
                if (format.columnCount <= 1) continue;
                rowData.put(c.toString() + format.suffix, format.getAlternateValue(row.get(c)));
            }
            this.getRows().add((ValueMap)new ValueMapDecorator(rowData));
        });
    }

    public <E extends Enum<E>, V> void setRows(List<EnumMap<E, V>> reportData, Class<E> enumClass) throws PersistenceException, RepositoryException {
        this.getColumns().clear();
        Stream.of(new Object[0]).map(Object::toString).collect(Collectors.toCollection(this::getColumns));
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            this.getColumns().add(e.toString());
            ValueFormat format = ValueFormat.forField(e);
            if (format.columnCount <= 1) continue;
            this.getColumns().add(e.toString() + format.suffix);
        }
        this.getRows().clear();
        reportData.forEach(row -> {
            LinkedHashMap<String, Object> rowData = new LinkedHashMap<String, Object>();
            for (Enum c : (Enum[])enumClass.getEnumConstants()) {
                if (!row.containsKey(c)) continue;
                ValueFormat format = ValueFormat.forField(c);
                rowData.put(c.toString(), row.get(c));
                if (format.columnCount <= 1) continue;
                rowData.put(c.toString() + format.suffix, format.getAlternateValue(row.get(c)));
            }
            this.getRows().add((ValueMap)new ValueMapDecorator(rowData));
        });
    }

    public List<String> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<String>();
        }
        return this.columns;
    }

    public List<ValueMap> getRows() {
        if (this.rows == null) {
            this.rows = new ArrayList<ValueMap>();
        }
        return this.rows;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getColumnNames() {
        return this.columns.stream().map(StringUtil::getFriendlyName).collect(Collectors.toList());
    }
}

