/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.util;

import acscommons.com.google.common.base.Joiner;
import acscommons.com.google.common.collect.Lists;
import com.adobe.acs.commons.mcp.util.FrozenRendition;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.Revision;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrozenAsset
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FrozenAsset.class);
    private static final Joiner pathJoiner = Joiner.on('/').skipNulls();
    private static final String RENDITIONS_PATH = pathJoiner.join("jcr:content", "renditions", new Object[0]);
    private static final String METADATA_PATH = pathJoiner.join("jcr:content", "metadata", new Object[0]);
    private final Asset head;
    private final Resource frozenResource;

    private FrozenAsset(Asset head, Revision revision) throws RepositoryException {
        Node frozenNode = revision.getVersion().getFrozenNode();
        this.head = head;
        this.frozenResource = ((Resource)head.adaptTo(Resource.class)).getResourceResolver().getResource(frozenNode.getPath());
    }

    private FrozenAsset(ResourceResolver resourceResolver, String path) throws RepositoryException {
        this.head = null;
        this.frozenResource = resourceResolver.getResource(path);
    }

    public static Asset createFrozenAsset(Asset asset, Revision revision) throws RepositoryException {
        FrozenAsset handler = new FrozenAsset(asset, revision);
        return (Asset)Proxy.newProxyInstance(FrozenAsset.class.getClassLoader(), new Class[]{Asset.class}, (InvocationHandler)handler);
    }

    private static Asset createFrozenAsset(ResourceResolver resourceResolver, String path) throws RepositoryException {
        FrozenAsset handler = new FrozenAsset(resourceResolver, path);
        return (Asset)Proxy.newProxyInstance(FrozenAsset.class.getClassLoader(), new Class[]{Asset.class}, (InvocationHandler)handler);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Asset asset = (Asset)proxy;
        switch (methodName) {
            case "adaptTo": {
                return this.adaptTo((Class)args[0]);
            }
            case "getMetadataValue": {
                return this.getMetadataValue((String)args[0]);
            }
            case "isSubAsset": {
                return this.isSubAsset();
            }
            case "getRenditions": {
                return this.getRenditions(asset);
            }
            case "getSubAssets": {
                return this.getSubAssets();
            }
        }
        LOG.error("FROZEN ASSET >> NO IMPLEMENTATION FOR " + methodName);
        throw new UnsupportedOperationException();
    }

    public Object adaptTo(Class<?> type) {
        if (type.equals(Resource.class)) {
            return this.frozenResource;
        }
        return null;
    }

    public String getMetadataValue(String name) {
        Resource meta = this.frozenResource.getChild(METADATA_PATH);
        if (meta == null) {
            return null;
        }
        return (String)meta.getValueMap().get(name, String.class);
    }

    public Rendition getRendition(Asset asset, String name) {
        Resource r = this.frozenResource.getChild(pathJoiner.join(RENDITIONS_PATH, name, new Object[0]));
        if (r == null) {
            return null;
        }
        return FrozenRendition.createFrozenRendition(asset, r);
    }

    public boolean isSubAsset() {
        return this.head == null;
    }

    public Map<String, Object> getMetadata() {
        Resource meta = this.frozenResource.getChild(METADATA_PATH);
        if (meta == null) {
            return null;
        }
        return meta.getValueMap();
    }

    public List<Rendition> getRenditions(Asset asset) {
        Resource renditions = this.frozenResource.getChild(RENDITIONS_PATH);
        if (renditions == null) {
            return Lists.newArrayList();
        }
        ArrayList<Rendition> rv = Lists.newArrayList();
        for (Resource r : renditions.getChildren()) {
            rv.add(this.getRendition(asset, r.getName()));
        }
        return rv;
    }

    public Collection<Asset> getSubAssets() {
        if (this.head == null) {
            throw new UnsupportedOperationException();
        }
        Resource subassets = this.frozenResource.getChild("subassets");
        if (subassets != null) {
            Stream<Resource> subs = StreamSupport.stream(subassets.getChildren().spliterator(), false);
            return subs.map(r -> {
                try {
                    return FrozenAsset.createFrozenAsset(this.frozenResource.getResourceResolver(), r.getPath());
                }
                catch (RepositoryException ex) {
                    LOG.error("Error retrieving subasset from " + r.getPath(), (Throwable)ex);
                    return null;
                }
            }).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }
}

