/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.models.injectors.impl;

import com.adobe.acs.commons.models.injectors.annotation.JsonValueMapValue;
import com.adobe.acs.commons.models.injectors.impl.InjectorUtils;
import com.adobe.acs.commons.util.impl.ReflectionUtil;
import com.google.gson.Gson;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.osgi.service.component.annotations.Component;

@Component(property={"service.ranking=5501"}, service={Injector.class})
public class JsonValueMapValueInjector
implements Injector {
    private static final Gson GSON = new Gson();

    public String getName() {
        return "json-valuemap-value";
    }

    public Object getValue(Object adaptable, String name, Type declaredType, AnnotatedElement element, DisposalCallbackRegistry callbackRegistry) {
        if (element.isAnnotationPresent(JsonValueMapValue.class)) {
            Resource resource = InjectorUtils.getResource(adaptable);
            JsonValueMapValue annotation = element.getAnnotation(JsonValueMapValue.class);
            String key = (String)StringUtils.defaultIfEmpty((CharSequence)annotation.name(), (CharSequence)name);
            String[] jsonStringArray = (String[])resource.getValueMap().get(key, String[].class);
            return this.parseValue(declaredType, jsonStringArray, key, resource);
        }
        return null;
    }

    private Object parseValue(Type declaredType, String[] jsonStringArray, String key, Resource resource) {
        if (ReflectionUtil.isSetType(declaredType) && ArrayUtils.isNotEmpty((Object[])jsonStringArray)) {
            return this.createSet(jsonStringArray, ReflectionUtil.getGenericParameter(declaredType));
        }
        if ((ReflectionUtil.isListType(declaredType) || ReflectionUtil.isCollectionType(declaredType)) && ArrayUtils.isNotEmpty((Object[])jsonStringArray)) {
            return this.createList(jsonStringArray, ReflectionUtil.getGenericParameter(declaredType));
        }
        if (ReflectionUtil.isArray(declaredType) && ArrayUtils.isNotEmpty((Object[])jsonStringArray)) {
            return this.createArray(jsonStringArray, ReflectionUtil.getGenericParameter(declaredType));
        }
        if (resource.getValueMap().containsKey((Object)key)) {
            String jsonString = (String)resource.getValueMap().get(key, String.class);
            return GSON.fromJson(jsonString, ReflectionUtil.getClassOrGenericParam(declaredType));
        }
        return null;
    }

    private <T> T[] createArray(String[] jsonStringList, Class<T> targetClass) {
        return ReflectionUtil.toArray(this.createList(jsonStringList, targetClass));
    }

    private <T> Set<T> createSet(String[] jsonStringArray, Class<T> targetClass) {
        return new HashSet<T>(this.createList(jsonStringArray, targetClass));
    }

    private <T> List<T> createList(String[] jsonStringArray, Class<T> targetClass) {
        if (ArrayUtils.isEmpty((Object[])jsonStringArray)) {
            return Collections.emptyList();
        }
        List<String> jsonStringList = Arrays.asList(jsonStringArray);
        return jsonStringList.stream().map(json -> GSON.fromJson(json, targetClass)).collect(Collectors.toList());
    }
}

