/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.oak.impl;

import com.adobe.acs.commons.oak.EnsureOakIndexManager;
import java.io.IOException;
import javax.servlet.Servlet;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Properties(value={@Property(name="felix.webconsole.title", value={"Ensure Oak Index"}), @Property(name="felix.webconsole.label", value={"ensure-oak-index"}), @Property(name="felix.webconsole.category", value={"Sling"})})
@Service(value={Servlet.class})
public class EnsureOakIndexServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(EnsureOakIndexServlet.class);
    private static final String PARAM_FORCE = "force";
    private static final String PARAM_PATH = "path";
    @Reference
    private EnsureOakIndexManager ensureOakIndexManager;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        try {
            response.setStatus(405);
            response.getWriter().println("<pre>");
            response.getWriter().println();
            response.getWriter().println();
            response.getWriter().println("HTTP method GET is not supported by this URL");
            response.getWriter().println("Use HTTP POST to access this end-point");
            response.getWriter().println("--------------------------------------------");
            response.getWriter().println("HTTP POST /system/console/ensure-oak-index");
            response.getWriter().println(" Parameters");
            response.getWriter().println("   * force = true | false (optional; when blank defaults to false)");
            response.getWriter().println("   * path = /abs/path/to/ensure/definition (optional; when blank indicates all)");
            response.getWriter().println();
            response.getWriter().println();
            response.getWriter().println("Example: curl --user admin:admin --data \"force=true\" https://localhost:4502/system/console/ensure-oak-index");
            response.getWriter().println("</pre>");
        }
        catch (IOException e) {
            log.warn("Caught IOException while handling doGet() in the Ensure Oak Index Servlet.", (Throwable)e);
            response.setStatus(500);
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String forceParam = StringUtils.defaultIfEmpty((String)request.getParameter(PARAM_FORCE), (String)"false");
        boolean force = Boolean.parseBoolean(forceParam);
        String path = StringUtils.stripToNull((String)request.getParameter(PARAM_PATH));
        try {
            int count = 0;
            count = StringUtils.isBlank((String)path) ? this.ensureOakIndexManager.ensureAll(force) : this.ensureOakIndexManager.ensure(force, path);
            response.setContentType("text/plain; charset=utf-8");
            response.getWriter().println("Initiated the ensuring of " + count + " oak indexes");
            response.setStatus(200);
        }
        catch (IOException e) {
            log.warn("Caught IOException while handling doPost() in the Ensure Oak Index Servlet", (Throwable)e);
            response.setStatus(500);
        }
    }

    protected void bindEnsureOakIndexManager(EnsureOakIndexManager ensureOakIndexManager) {
        this.ensureOakIndexManager = ensureOakIndexManager;
    }

    protected void unbindEnsureOakIndexManager(EnsureOakIndexManager ensureOakIndexManager) {
        if (this.ensureOakIndexManager == ensureOakIndexManager) {
            this.ensureOakIndexManager = null;
        }
    }
}

