/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.packaging.util;

import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.Filter;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetPackageUtil {
    protected static final Logger log = LoggerFactory.getLogger(AssetPackageUtil.class);
    private static final String PN_PAGE_PATH = "pagePath";
    private static final String PN_EXCLUDE_PAGES = "excludePages";
    private static final String PN_ASSET_PREFIX = "assetPrefix";
    private static final String PN_PAGE_EXCLUSIONS = "pageExclusions";
    private static final String PN_ASSET_EXCLUSIONS = "assetExclusions";
    private String customPrefix;
    private List<Pattern> pageExclusionPatterns;
    private List<Pattern> assetExclusionPatterns;
    private final Set<String> excludedPages;
    private final ValueMap properties;
    private final ResourceResolver resourceResolver;

    public AssetPackageUtil(ValueMap properties, ResourceResolver resourceResolver) {
        this.properties = properties;
        this.resourceResolver = resourceResolver;
        this.customPrefix = (String)properties.get(PN_ASSET_PREFIX, String.class);
        this.pageExclusionPatterns = this.generatePatterns((String[])properties.get(PN_PAGE_EXCLUSIONS, (Object)new String[0]));
        this.assetExclusionPatterns = this.generatePatterns((String[])properties.get(PN_ASSET_EXCLUSIONS, (Object)new String[0]));
        this.excludedPages = new LinkedHashSet<String>();
    }

    public List<PathFilterSet> getPackageFilterPaths() {
        String pagePath = (String)this.properties.get(PN_PAGE_PATH, String.class);
        Set<PathFilterSet> packageFilterPathSet = StringUtils.isBlank((CharSequence)pagePath) ? Collections.emptySet() : this.findAssetPaths(this.resourceResolver, pagePath);
        this.addPagePath(packageFilterPathSet, pagePath, (Boolean)this.properties.get(PN_EXCLUDE_PAGES, (Object)false));
        ArrayList<PathFilterSet> packageFilterPaths = new ArrayList<PathFilterSet>(packageFilterPathSet);
        Collections.reverse(packageFilterPaths);
        return packageFilterPaths;
    }

    private List<Pattern> generatePatterns(String[] input) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String item : input) {
            try {
                if (StringUtils.isBlank((CharSequence)item)) continue;
                patterns.add(Pattern.compile(item));
            }
            catch (PatternSyntaxException e) {
                log.error("Pattern invalid, skipping. Pattern value: " + item);
            }
        }
        return patterns;
    }

    private Set<PathFilterSet> findAssetPaths(ResourceResolver resourceResolver, String pagePath) {
        LinkedHashSet<PathFilterSet> filters = new LinkedHashSet<PathFilterSet>();
        Resource parentResource = resourceResolver.resolve(pagePath);
        if (this.isExcluded(this.pageExclusionPatterns, pagePath)) {
            if (pagePath.endsWith("/jcr:content")) {
                return filters;
            }
            PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
            Page page = pageManager.getContainingPage(parentResource);
            if (page != null) {
                this.excludedPages.add(page.getPath());
            } else {
                this.excludedPages.add(parentResource.getPath());
            }
            return filters;
        }
        ValueMap parentResourceProperties = parentResource.getValueMap();
        for (String key : parentResourceProperties.keySet()) {
            String[] arrayValue;
            Object value = parentResourceProperties.get((Object)key);
            if (value instanceof String) {
                this.addFilter(filters, (String)value, resourceResolver);
                continue;
            }
            if (!(value instanceof String[])) continue;
            for (String stringValue : arrayValue = (String[])value) {
                this.addFilter(filters, stringValue, resourceResolver);
            }
        }
        Iterator children = parentResource.listChildren();
        while (children.hasNext()) {
            Resource child = (Resource)children.next();
            filters.addAll(this.findAssetPaths(resourceResolver, child.getPath()));
        }
        return filters;
    }

    private void addPagePath(Set<PathFilterSet> currentPaths, String pagePath, boolean excludePages) {
        if (!excludePages && currentPaths.size() > 0) {
            PathFilterSet pageFilter = new PathFilterSet(pagePath);
            if (this.excludedPages.size() > 0) {
                for (String excludedPath : this.excludedPages) {
                    pageFilter.addExclude((Filter)new DefaultPathFilter(excludedPath));
                }
            }
            currentPaths.add(pageFilter);
        }
    }

    private void addFilter(Set<PathFilterSet> filters, String value, ResourceResolver resourceResolver) {
        if (StringUtils.isNotBlank((CharSequence)value) && DamUtil.isAsset((Resource)resourceResolver.getResource(value)) && this.fitsAssetPattern(value)) {
            filters.add(new PathFilterSet(value));
        }
    }

    private boolean fitsAssetPattern(String assetPath) {
        boolean startsWith = this.customPrefix != null ? assetPath.startsWith(this.customPrefix) : assetPath.startsWith("/content/dam");
        boolean notExcluded = !this.isExcluded(this.assetExclusionPatterns, assetPath);
        return startsWith && notExcluded;
    }

    private boolean isExcluded(List<Pattern> patterns, String path) {
        for (Pattern pattern : patterns) {
            if (pattern.matcher(path).matches()) {
                return true;
            }
            String literalPattern = pattern.toString();
            literalPattern = literalPattern.endsWith("/") ? literalPattern : literalPattern + "/";
            if (!path.startsWith(literalPattern)) continue;
            return true;
        }
        return false;
    }
}

