/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.quickly.results.impl.serializers;

import com.adobe.acs.commons.quickly.results.Action;
import com.adobe.acs.commons.quickly.results.Result;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public abstract class AbstractResultSerializer {
    public JsonObject toJSON(Result result) {
        JsonObject json = new JsonObject();
        json.addProperty("title", result.getTitle());
        json.addProperty("type", result.getResultType());
        json.addProperty("description", result.getDescription());
        json.addProperty("path", result.getPath());
        json.add("action", (JsonElement)this.toJSON(result.getAction()));
        json.add("secondaryAction", (JsonElement)this.toJSON(result.getSecondaryAction()));
        return json;
    }

    public JsonObject toJSON(Action action) {
        JsonObject json = new JsonObject();
        if (action != null) {
            Gson gson = new Gson();
            json.addProperty("uri", action.getUri());
            json.addProperty("method", action.getMethod().name());
            json.addProperty("target", action.getTarget().name());
            json.addProperty("xhr", Boolean.valueOf(false));
            json.addProperty("script", action.getScript());
            json.add("params", gson.toJsonTree(action.getParams()));
        }
        return json;
    }
}

