/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirectmaps.models;

import com.adobe.acs.commons.redirectmaps.impl.FakeSlingHttpServletRequest;
import com.adobe.acs.commons.redirectmaps.models.MapEntry;
import com.adobe.acs.commons.redirectmaps.models.RedirectConfigModel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.Source;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
@ProviderType
public class RedirectMapModel {
    private static final Logger log = LoggerFactory.getLogger(RedirectMapModel.class);
    private static final String NO_TARGET_MSG = "No target found in entry %s";
    private static final String SOURCE_WHITESPACE_MSG = "Source path %s for content %s contains whitespace";
    private static final String WHITESPACE_MSG = "Extra whitespace found in entry %s";
    public static final String MAP_FILE_NODE = "redirectMap.txt";
    @Inject
    @Optional
    @Named(value="redirectMap.txt")
    private Resource redirectMap;
    @Inject
    @Optional
    private List<RedirectConfigModel> redirects;
    @Inject
    @Source(value="sling-object")
    private ResourceResolver resourceResolver;

    private List<MapEntry> addItems(RedirectConfigModel config, Iterator<Resource> items, String suffix) {
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>();
        while (items.hasNext()) {
            Resource item = items.next();
            String path = item.getPath();
            ValueMapDecorator properties = new ValueMapDecorator(new HashMap());
            Resource child = item.getChild("jcr:content");
            if (child != null) {
                properties = child.getValueMap();
            }
            FakeSlingHttpServletRequest mockRequest = new FakeSlingHttpServletRequest(this.resourceResolver, config.getProtocol(), config.getDomain(), config.getProtocol().equals("https") ? 443 : 80);
            String pageUrl = config.getProtocol() + "://" + config.getDomain() + this.resourceResolver.map((HttpServletRequest)mockRequest, item.getPath() + suffix);
            String[] sources = (String[])properties.get(config.getProperty(), String[].class);
            int i = 0;
            for (String source : sources) {
                MapEntry entry = new MapEntry(i++, source, pageUrl, item.getPath());
                if (source.matches(".*\\s+.*")) {
                    String msg = String.format(SOURCE_WHITESPACE_MSG, entry.getSource(), path);
                    log.warn(msg);
                    entry.setStatus(msg);
                    entry.setValid(false);
                }
                entries.add(entry);
            }
        }
        return entries;
    }

    private List<MapEntry> gatherEntries(RedirectConfigModel config) {
        log.trace("gatherEntries");
        log.debug("Getting all of the entries for {}", (Object)config.getResource());
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>();
        String pageQuery = "SELECT * FROM [cq:Page] WHERE [jcr:content/" + config.getProperty() + "] IS NOT NULL AND (ISDESCENDANTNODE([" + config.getPath() + "]) OR [jcr:path]='" + config.getPath() + "')";
        log.debug("Finding pages with redirects with query: {}", (Object)pageQuery);
        entries.addAll(this.addItems(config, this.resourceResolver.findResources(pageQuery, "JCR-SQL2"), ".html"));
        String assetQuery = "SELECT * FROM [dam:Asset] WHERE [jcr:content/" + config.getProperty() + "] IS NOT NULL AND (ISDESCENDANTNODE([" + config.getPath() + "]) OR [jcr:path]='" + config.getPath() + "')";
        log.debug("Finding assets with redirects with query: {}", (Object)assetQuery);
        entries.addAll(this.addItems(config, this.resourceResolver.findResources(assetQuery, "JCR-SQL2"), ""));
        return entries;
    }

    public List<MapEntry> getEntries() throws IOException {
        InputStream is;
        log.trace("getEntries");
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>();
        if (this.redirectMap != null && (is = (InputStream)this.redirectMap.adaptTo(InputStream.class)) != null) {
            int i = 0;
            for (String line : IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8)) {
                MapEntry entry;
                if ((entry = this.toEntry(i++, line)) == null) continue;
                entries.add(entry);
            }
        }
        if (this.redirects != null) {
            this.redirects.forEach(r -> entries.addAll(this.gatherEntries((RedirectConfigModel)r)));
        } else {
            log.debug("No redirect configurations specified");
        }
        HashMap<String, Integer> sources = new HashMap<String, Integer>();
        for (MapEntry entry : entries) {
            if (!sources.containsKey(entry.getSource())) {
                sources.put(entry.getSource(), 1);
                continue;
            }
            log.trace("Found duplicate entry for {}", (Object)entry.getSource());
            sources.put(entry.getSource(), (Integer)sources.get(entry.getSource()) + 1);
        }
        sources.entrySet().removeIf(e -> (Integer)e.getValue() <= 1);
        log.debug("Found {} duplicate entries", (Object)sources.keySet().size());
        entries.stream().filter(e -> sources.containsKey(e.getSource())).forEach(e -> {
            e.setValid(false);
            e.setStatus("Duplicate entry for " + e.getSource() + ", found redirect to " + e.getTarget());
        });
        return entries;
    }

    public List<MapEntry> getInvalidEntries() throws IOException {
        log.trace("getInvalidEntries");
        ArrayList<MapEntry> invalidEntries = new ArrayList<MapEntry>();
        if (this.redirects != null) {
            List<MapEntry> entries = this.getEntries();
            invalidEntries.addAll(entries.stream().filter(e -> !e.isValid()).collect(Collectors.toList()));
            log.debug("Found {} invalid entries", (Object)invalidEntries.size());
        }
        return invalidEntries;
    }

    public String getRedirectMap() throws IOException {
        log.debug("Retrieving redirect map from {}", (Object)this.redirectMap);
        StringBuilder sb = new StringBuilder();
        if (this.redirectMap != null) {
            log.debug("Loading RedirectMap file from {}", (Object)this.redirectMap);
            InputStream is = (InputStream)this.redirectMap.adaptTo(InputStream.class);
            if (is != null) {
                sb.append("# Redirect Map File\n");
                sb.append(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
            } else {
                log.debug("Unable to get input stream from redirect file: {}", (Object)this.redirectMap);
            }
        } else {
            log.debug("No redirect map specified");
        }
        if (this.redirects != null) {
            for (RedirectConfigModel config : this.redirects) {
                this.writeEntries(config, sb);
            }
        } else {
            log.debug("No redirect configurations specified");
        }
        return sb.toString();
    }

    private MapEntry toEntry(int id, String l) {
        String[] seg = l.split("\\s+");
        MapEntry entry = null;
        if (!StringUtils.isBlank((CharSequence)l) && !l.startsWith("#")) {
            if (seg.length == 2) {
                entry = new MapEntry(id, seg[0], seg[1], "File");
            } else if (seg.length > 2) {
                entry = new MapEntry(id, seg[0], seg[1], "File");
                entry.setValid(false);
                entry.setStatus(String.format(WHITESPACE_MSG, l));
            } else {
                entry = new MapEntry(id, seg[0], "", "File");
                entry.setValid(false);
                entry.setStatus(String.format(NO_TARGET_MSG, l));
            }
        }
        return entry;
    }

    private void writeEntries(RedirectConfigModel config, StringBuilder sb) {
        log.trace("writeEntries");
        List<MapEntry> entries = this.gatherEntries(config);
        sb.append("\n# Dynamic entries for " + config.getResource().getPath() + "\n");
        for (MapEntry entry : entries) {
            if (!entry.isValid()) continue;
            sb.append(entry.getSource() + " " + entry.getTarget() + "\n");
        }
    }
}

