/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.dispatcher.impl;

import com.adobe.acs.commons.replication.dispatcher.DispatcherFlusher;
import com.adobe.acs.commons.replication.dispatcher.impl.DispatcherFlushRulesImpl;
import com.day.cq.replication.Agent;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationResult;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"acs-commons/components/utilities/dispatcher-flush/configuration"}, selectors={"flush"}, methods={"POST"})
public class DispatcherFlusherServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(DispatcherFlusherServlet.class);
    @Reference
    private DispatcherFlusher dispatcherFlusher;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private static final boolean DEFAULT_FLUSH_WITH_ADMIN_RESOURCE_RESOLVER = true;
    private boolean flushWithAdminResourceResolver = true;
    @Property(label="Flush with Admin Resource Resolver", description="This allows the user of any Dispatcher Flush UI Web UI to invalidate/delete the cache of any content tree. Note; this is only pertains to the dispatcher cache and does not effect the users JCR permissions. [ Default: true ]", boolValue={true})
    public static final String PROP_FLUSH_WITH_ADMIN_RESOURCE_RESOLVER = "flush-with-admin-resource-resolver";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Resource resource = request.getResource();
        ResourceResolver resourceResolver = request.getResourceResolver();
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        Page currentPage = pageManager.getContainingPage(resource);
        ValueMap properties = resource.getValueMap();
        String[] paths = (String[])properties.get("paths", (Object)new String[0]);
        ReplicationActionType replicationActionType = ReplicationActionType.valueOf((String)((String)properties.get("replicationActionType", (Object)ReplicationActionType.ACTIVATE.name())));
        ArrayList<FlushResult> overallResults = new ArrayList<FlushResult>();
        boolean caughtException = false;
        ResourceResolver flushingResourceResolver = null;
        try {
            if (paths.length > 0) {
                flushingResourceResolver = this.flushWithAdminResourceResolver ? this.resourceResolverFactory.getServiceResourceResolver(DispatcherFlushRulesImpl.AUTH_INFO) : resourceResolver;
                Map<Agent, ReplicationResult> results = this.dispatcherFlusher.flush(flushingResourceResolver, replicationActionType, true, paths);
                for (Map.Entry<Agent, ReplicationResult> entry : results.entrySet()) {
                    Agent agent = entry.getKey();
                    ReplicationResult result = entry.getValue();
                    overallResults.add(new FlushResult(agent, result));
                }
            }
        }
        catch (ReplicationException e) {
            log.error("Replication exception occurred during Dispatcher Flush request.", (Throwable)e);
            caughtException = true;
        }
        catch (LoginException e) {
            log.error("Could not obtain an Admin Resource Resolver during Dispatcher Flush request.", (Throwable)e);
            caughtException = true;
        }
        finally {
            if (this.flushWithAdminResourceResolver && flushingResourceResolver != null) {
                flushingResourceResolver.close();
            }
        }
        if (request.getRequestPathInfo().getExtension().equals("json")) {
            response.setContentType("application/json");
            Gson gson = new Gson();
            LinkedHashMap<String, Boolean> resultMap = new LinkedHashMap<String, Boolean>();
            for (FlushResult result : overallResults) {
                resultMap.put(result.agentId, result.success);
            }
            gson.toJson(resultMap, (Appendable)response.getWriter());
        } else {
            String suffix = caughtException ? "replication-error" : StringUtils.join(overallResults, (char)'/');
            response.sendRedirect(request.getContextPath() + currentPage.getPath() + ".html/" + suffix);
        }
    }

    @Activate
    protected final void activate(Map<String, String> config) {
        this.flushWithAdminResourceResolver = PropertiesUtil.toBoolean((Object)config.get(PROP_FLUSH_WITH_ADMIN_RESOURCE_RESOLVER), (boolean)true);
    }

    protected void bindDispatcherFlusher(DispatcherFlusher dispatcherFlusher) {
        this.dispatcherFlusher = dispatcherFlusher;
    }

    protected void unbindDispatcherFlusher(DispatcherFlusher dispatcherFlusher) {
        if (this.dispatcherFlusher == dispatcherFlusher) {
            this.dispatcherFlusher = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    private static final class FlushResult {
        private final String agentId;
        private final boolean success;

        private FlushResult(Agent agent, ReplicationResult result) {
            this.agentId = agent.getId();
            this.success = result.isSuccess() && result.getCode() == 200;
        }

        public String toString() {
            return this.agentId + "/" + this.success;
        }
    }
}

