/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.impl;

import com.adobe.acs.commons.replication.ReplicateVersion;
import com.adobe.acs.commons.replication.ReplicationResult;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.ServletException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"acs-commons/components/utilities/version-replicator"}, selectors={"replicateversion"}, extensions={"json"}, methods={"POST"}, generateComponent=true)
public class ReplicateVersionServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(ReplicateVersionServlet.class);
    private static final String KEY_ERROR = "error";
    private static final String KEY_RESULT = "result";
    private static final String KEY_STATUS = "status";
    private static final String KEY_PATH = "path";
    private static final String KEY_VERSION = "version";
    @Reference
    private ReplicateVersion replicateVersion;

    public final void doPost(SlingHttpServletRequest req, SlingHttpServletResponse res) throws ServletException, IOException {
        log.debug("Entering ReplicatePageVersionServlet.doPost(..)");
        String[] rootPaths = req.getParameterValues("rootPaths");
        Date date = this.getDate(req.getParameter("datetimecal"));
        String[] agents = req.getParameterValues("cmbAgent");
        JsonObject obj = this.validate(rootPaths, agents, date);
        if (!obj.has(KEY_ERROR)) {
            log.debug("Initiating version replication");
            List<ReplicationResult> response = this.replicateVersion.replicate(req.getResourceResolver(), rootPaths, agents, date);
            if (log.isDebugEnabled()) {
                for (ReplicationResult replicationResult : response) {
                    log.debug("Replication result: {} -- {}", (Object)replicationResult.getPath(), (Object)replicationResult.getStatus());
                }
            }
            JsonArray arr = this.convertResponseToJson(response);
            obj = new JsonObject();
            obj.add(KEY_RESULT, (JsonElement)arr);
        } else {
            log.debug("Did not attempt to replicate version due to issue with input params");
            res.setStatus(500);
            obj.addProperty(KEY_STATUS, KEY_ERROR);
        }
        res.setContentType("application/json");
        res.getWriter().print(obj.toString());
    }

    private JsonArray convertResponseToJson(List<ReplicationResult> list) {
        JsonArray arr = new JsonArray();
        for (ReplicationResult result : list) {
            JsonObject resultObject = new JsonObject();
            resultObject.addProperty(KEY_PATH, result.getPath());
            resultObject.addProperty(KEY_STATUS, result.getStatus().name());
            resultObject.addProperty(KEY_VERSION, result.getVersion());
            arr.add((JsonElement)resultObject);
        }
        return arr;
    }

    private JsonObject validate(String[] rootPaths, String[] agents, Date date) {
        JsonObject obj = new JsonObject();
        if (ArrayUtils.isEmpty((Object[])rootPaths)) {
            obj.addProperty(KEY_ERROR, "Select at least 1 root path.");
            log.debug("Error validating root paths (they're empty)");
            return obj;
        }
        for (String rootPath : rootPaths) {
            if (!StringUtils.isBlank((String)rootPath)) continue;
            obj.addProperty(KEY_ERROR, "Root paths cannot be empty.");
            log.debug("Error validating a root path");
            return obj;
        }
        if (date == null) {
            obj.addProperty(KEY_ERROR, "Specify the date and time to select the appropriate resource versions for replication.");
            log.debug("Error validating date");
            return obj;
        }
        if (ArrayUtils.isEmpty((Object[])agents)) {
            obj.addProperty(KEY_ERROR, "Select at least 1 replication agent.");
            log.debug("Error validating agents");
            return obj;
        }
        log.debug("Validated all version replication inputs successfully");
        return obj;
    }

    private Date getDate(String datetime) {
        Date date = null;
        try {
            String modifiedDate = datetime.substring(0, datetime.indexOf(43));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            date = sdf.parse(modifiedDate);
        }
        catch (Exception e) {
            log.error("exception occurred", (Throwable)e);
        }
        return date;
    }

    protected void bindReplicateVersion(ReplicateVersion replicateVersion) {
        this.replicateVersion = replicateVersion;
    }

    protected void unbindReplicateVersion(ReplicateVersion replicateVersion) {
        if (this.replicateVersion == replicateVersion) {
            this.replicateVersion = null;
        }
    }
}

