/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.packages.automatic.impl;

import com.adobe.acs.commons.replication.packages.automatic.impl.ConfigurationUpdateListener;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.Replicator;
import java.io.IOException;
import java.util.Collections;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackagingService;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomaticPackageReplicatorJob
implements Runnable,
EventHandler {
    private static final Logger log = LoggerFactory.getLogger(AutomaticPackageReplicatorJob.class);
    public static final String SERVICE_USER_NAME = "acs-commons-automatic-package-replication-service";
    public static final String OSGI_EVENT_REPLICATED_TOPIC = "com/adobe/acs/commons/automatic_page_replicator/REPLICATED";
    public static final String OSGI_EVENT_FAILED_TOPIC = "com/adobe/acs/commons/automatic_page_replicator/REPLICATION_FAILED";
    public static final String OSGI_EVENT_PACKAGE_PATH_PARAM = "packagePath";
    private final Replicator replicator;
    private final String packagePath;
    private final ResourceResolverFactory resolverFactory;
    private final EventAdmin eventAdmin;

    public AutomaticPackageReplicatorJob(ResourceResolverFactory resolverFactory, Replicator replicator, EventAdmin eventAdmin, String packagePath) {
        this.replicator = replicator;
        this.packagePath = packagePath;
        this.resolverFactory = resolverFactory;
        this.eventAdmin = eventAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excute() throws RepositoryException, PackageException, IOException, ReplicationException {
        boolean succeeded = false;
        try (ResourceResolver resolver = ConfigurationUpdateListener.getResourceResolver(this.resolverFactory);){
            Session session = (Session)resolver.adaptTo(Session.class);
            JcrPackageManager pkgMgr = PackagingService.getPackageManager((Session)session);
            PackageId packageId = new PackageId(this.packagePath);
            JcrPackage jcrPackage = pkgMgr.open(packageId);
            if (jcrPackage == null || jcrPackage.getNode() == null) {
                log.warn("Package at path " + this.packagePath + " does not exist");
                throw new IllegalArgumentException("Package at path " + this.packagePath + " does not exist");
            }
            log.debug("Assembling package {}", (Object)this.packagePath);
            pkgMgr.assemble(jcrPackage, null);
            log.debug("Replicating package {}", (Object)this.packagePath);
            this.replicator.replicate(session, ReplicationActionType.ACTIVATE, jcrPackage.getNode().getPath());
            log.debug("Package {} replicated successfully!", (Object)this.packagePath);
            this.fireEvent(OSGI_EVENT_REPLICATED_TOPIC);
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                this.fireEvent(OSGI_EVENT_FAILED_TOPIC);
            }
        }
    }

    private void fireEvent(String topic) {
        Event event = new Event(topic, Collections.singletonMap(OSGI_EVENT_PACKAGE_PATH_PARAM, this.packagePath));
        this.eventAdmin.postEvent(event);
    }

    @Override
    public void run() {
        log.trace("run");
        try {
            this.excute();
        }
        catch (Exception e) {
            log.error("Excepting running Automatic Package Replication task", (Throwable)e);
        }
    }

    public void handleEvent(Event event) {
        this.run();
    }
}

