/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.synth.children;

import com.adobe.acs.commons.json.JsonObjectUtil;
import com.adobe.acs.commons.synth.children.InvalidDataFormatException;
import com.adobe.acs.commons.synth.children.SyntheticChildAsPropertyResource;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.IteratorUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildrenAsPropertyResource
extends ResourceWrapper {
    private static final Logger log = LoggerFactory.getLogger(ChildrenAsPropertyResource.class);
    private static final String EMPTY_JSON = "{}";
    private static final String DEFAULT_PROPERTY_NAME = "children";
    private final Resource resource;
    private final String propertyName;
    private Map<String, Resource> lookupCache = null;
    private Set<Resource> orderedCache = null;
    private Comparator<Resource> comparator = null;
    public static final Comparator<Resource> RESOURCE_NAME_COMPARATOR = new ResourceNameComparator();

    public ChildrenAsPropertyResource(Resource resource) throws InvalidDataFormatException {
        this(resource, DEFAULT_PROPERTY_NAME, null);
    }

    public ChildrenAsPropertyResource(Resource resource, String propertyName) throws InvalidDataFormatException {
        this(resource, propertyName, null);
    }

    public ChildrenAsPropertyResource(Resource resource, String propertyName, Comparator<Resource> comparator) throws InvalidDataFormatException {
        super(resource);
        this.resource = resource;
        this.propertyName = propertyName;
        this.comparator = comparator;
        this.orderedCache = this.comparator == null ? new LinkedHashSet<Resource>() : new TreeSet<Resource>(this.comparator);
        this.lookupCache = new HashMap<String, Resource>();
        for (SyntheticChildAsPropertyResource r : this.deserialize()) {
            this.orderedCache.add((Resource)r);
            this.lookupCache.put(r.getName(), (Resource)r);
        }
    }

    public final Iterator<Resource> listChildren() {
        return IteratorUtils.getIterator(this.orderedCache);
    }

    public final Iterable<Resource> getChildren() {
        return this.orderedCache;
    }

    public final Resource getChild(String name) {
        return this.lookupCache.get(name);
    }

    public final Resource getParent() {
        return this.resource;
    }

    public final Resource create(String name, String primaryType) throws RepositoryException {
        return this.create(name, primaryType, null);
    }

    public final Resource create(String name, String primaryType, Map<String, Object> data) throws RepositoryException {
        SyntheticChildAsPropertyResource child;
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        if (data.containsKey("jcr:primaryType") && primaryType != null) {
            data.put("jcr:primaryType", primaryType);
        }
        if (this.lookupCache.containsKey((child = new SyntheticChildAsPropertyResource(this.resource, name, data)).getName())) {
            log.info("Existing synthetic child [ {} ] overwritten", (Object)name);
        }
        this.lookupCache.put(child.getName(), (Resource)child);
        this.orderedCache.add((Resource)child);
        return child;
    }

    public final void delete(String name) throws RepositoryException {
        if (this.lookupCache.containsKey(name)) {
            Resource tmp = this.lookupCache.get(name);
            this.orderedCache.remove(tmp);
            this.lookupCache.remove(name);
        }
    }

    public final void deleteAll() throws InvalidDataFormatException {
        this.orderedCache = this.comparator == null ? new LinkedHashSet<Resource>() : new TreeSet<Resource>(this.comparator);
        this.lookupCache = new HashMap<String, Resource>();
    }

    public final void persist() throws RepositoryException {
        this.serialize();
    }

    private void serialize() throws InvalidDataFormatException {
        long start = System.currentTimeMillis();
        ModifiableValueMap modifiableValueMap = (ModifiableValueMap)this.resource.adaptTo(ModifiableValueMap.class);
        JsonObject childrenJSON = new JsonObject();
        try {
            for (Resource childResource : this.orderedCache) {
                childrenJSON.add(childResource.getName(), (JsonElement)this.serializeToJSON(childResource));
            }
            if (childrenJSON.entrySet().size() > 0) {
                modifiableValueMap.put((Object)this.propertyName, (Object)childrenJSON.toString());
            } else {
                modifiableValueMap.remove((Object)this.propertyName);
            }
            log.debug("Persist operation for [ {} ] in [ {} ms ]", (Object)(this.resource.getPath() + "/" + this.propertyName), (Object)(System.currentTimeMillis() - start));
        }
        catch (NoSuchMethodException e) {
            throw new InvalidDataFormatException(this.resource, this.propertyName, childrenJSON.toString());
        }
        catch (IllegalAccessException e) {
            throw new InvalidDataFormatException(this.resource, this.propertyName, childrenJSON.toString());
        }
        catch (InvocationTargetException e) {
            throw new InvalidDataFormatException(this.resource, this.propertyName, childrenJSON.toString());
        }
    }

    private List<SyntheticChildAsPropertyResource> deserialize() throws InvalidDataFormatException {
        long start = System.currentTimeMillis();
        String propertyData = (String)this.resource.getValueMap().get(this.propertyName, (Object)EMPTY_JSON);
        List<SyntheticChildAsPropertyResource> resources = this.deserializeToSyntheticChildResources(JsonObjectUtil.toJsonObject(propertyData));
        if (this.comparator != null) {
            Collections.sort(resources, this.comparator);
        }
        log.debug("Get operation for [ {} ] in [ {} ms ]", (Object)(this.resource.getPath() + "/" + this.propertyName), (Object)(System.currentTimeMillis() - start));
        return resources;
    }

    protected final JsonObject serializeToJSON(Resource resourceToSerialize) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        DateTimeFormatter dtf = ISODateTimeFormat.dateTime();
        HashMap<String, String> serializedData = new HashMap<String, String>();
        for (Map.Entry entry : resourceToSerialize.getValueMap().entrySet()) {
            if (entry.getValue() instanceof Calendar) {
                Calendar cal = (Calendar)entry.getValue();
                serializedData.put((String)entry.getKey(), dtf.print(cal.getTimeInMillis()));
                continue;
            }
            if (entry.getValue() instanceof Date) {
                Date date = (Date)entry.getValue();
                serializedData.put((String)entry.getKey(), dtf.print(date.getTime()));
                continue;
            }
            serializedData.put((String)entry.getKey(), (String)entry.getValue());
        }
        Gson gson = new Gson();
        return gson.toJsonTree(serializedData).getAsJsonObject();
    }

    protected final List<SyntheticChildAsPropertyResource> deserializeToSyntheticChildResources(JsonObject jsonObject) {
        ArrayList<SyntheticChildAsPropertyResource> resources = new ArrayList<SyntheticChildAsPropertyResource>();
        for (Map.Entry elem : jsonObject.entrySet()) {
            String nodeName = (String)elem.getKey();
            JsonObject entryJSON = ((JsonElement)elem.getValue()).getAsJsonObject();
            if (entryJSON == null) continue;
            ValueMapDecorator properties = new ValueMapDecorator(new HashMap());
            for (Map.Entry prop : entryJSON.entrySet()) {
                String propName = (String)prop.getKey();
                properties.put((Object)propName, (Object)((JsonElement)prop.getValue()).getAsString());
            }
            resources.add(new SyntheticChildAsPropertyResource(this.getParent(), nodeName, (Map<String, Object>)properties));
        }
        return resources;
    }

    private static final class ResourceNameComparator
    implements Comparator<Resource>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private ResourceNameComparator() {
        }

        @Override
        public int compare(Resource o1, Resource o2) {
            return o1.getName().compareTo(o2.getName().toString());
        }
    }
}

