/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.comparisons.impl;

import com.adobe.acs.commons.wcm.comparisons.PageCompareData;
import com.adobe.acs.commons.wcm.comparisons.PageCompareDataLine;
import com.adobe.acs.commons.wcm.comparisons.VersionSelection;
import com.adobe.acs.commons.wcm.comparisons.impl.PageCompareDataLineImpl;
import com.adobe.acs.commons.wcm.comparisons.impl.Properties;
import com.adobe.acs.commons.wcm.comparisons.impl.VersionSelectionImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PageCompareDataImpl
implements PageCompareData {
    private static final Logger log = LoggerFactory.getLogger(PageCompareDataImpl.class);
    private final Resource resource;
    private final String versionName;
    private Date versionDate;
    private final List<PageCompareDataLine> lines = new ArrayList<PageCompareDataLine>();
    private final List<VersionSelection> versionSelection = new ArrayList<VersionSelection>();

    PageCompareDataImpl(Resource resource, String versionName) throws RepositoryException {
        this.resource = resource.isResourceType("cq:Page") ? resource.getChild("jcr:content") : resource;
        this.versionName = versionName;
        this.initialize();
    }

    private void initialize() throws RepositoryException {
        if (this.versionName.equals("latest")) {
            this.populate(this.resource, this.resource.getPath(), 0);
            this.versionDate = Properties.lastModified(this.resource);
        }
        VersionManager versionManager = ((Session)this.resource.getResourceResolver().adaptTo(Session.class)).getWorkspace().getVersionManager();
        try {
            VersionHistory history = versionManager.getVersionHistory(this.resource.getPath());
            VersionIterator versionIterator = history.getAllVersions();
            while (versionIterator.hasNext()) {
                Version next = versionIterator.nextVersion();
                this.versionSelection.add(new VersionSelectionImpl(next.getName(), next.getCreated().getTime()));
                if (!next.getName().equalsIgnoreCase(this.versionName)) continue;
                String versionPath = next.getFrozenNode().getPath();
                Resource versionResource = this.resource.getResourceResolver().resolve(versionPath);
                this.populate(versionResource, versionPath, 0);
                this.versionDate = next.getCreated().getTime();
            }
        }
        catch (UnsupportedRepositoryOperationException e) {
            log.debug(String.format("node %s not versionable", this.resource.getPath()));
        }
        this.versionSelection.add(new VersionSelectionImpl("latest", Properties.lastModified(this.resource)));
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public String getVersion() {
        return this.versionName;
    }

    @Override
    public Date getVersionDate() {
        return this.versionDate;
    }

    @Override
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    public List<VersionSelection> getVersions() {
        return this.versionSelection;
    }

    @Override
    public List<PageCompareDataLine> getLines() {
        return this.lines;
    }

    private void populate(Resource resource, String basePath, int depth) throws RepositoryException {
        ValueMap map = resource.getValueMap();
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            Property property = ((Node)resource.adaptTo(Node.class)).getProperty(key);
            this.lines.add(new PageCompareDataLineImpl(property, basePath, depth + 1));
        }
        for (Resource child : resource.getChildren()) {
            this.lines.add(new PageCompareDataLineImpl(child, basePath, depth + 1));
            this.populate(child, basePath, depth + 1);
        }
    }
}

