/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.notifications.impl;

import com.adobe.acs.commons.http.injectors.AbstractHtmlRequestInjector;
import com.adobe.acs.commons.util.CookieUtil;
import com.adobe.acs.commons.wcm.notifications.SystemNotifications;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.AbstractResourceVisitor;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={SystemNotifications.class})
public class SystemNotificationsImpl
extends AbstractHtmlRequestInjector
implements SystemNotifications,
ResourceChangeListener,
ExternalResourceChangeListener {
    private static final Logger log = LoggerFactory.getLogger(SystemNotificationsImpl.class);
    public static final String COOKIE_NAME = "acs-commons-system-notifications";
    private static final String PATH_NOTIFICATIONS = "/etc/acs-commons/notifications";
    private static final String PN_ON_TIME = "onTime";
    private static final String PN_OFF_TIME = "offTime";
    private static final String PN_ENABLED = "enabled";
    private static final String INJECT_TEXT = "<script>if(window === top) {   window.jQuery || document.write('<script src=\"%s\"><\\/script>');   document.write('<script src=\"%s\"><\\/script>');}</script>";
    private static final String SERVICE_NAME = "system-notifications";
    private static final Map<String, Object> AUTH_INFO = Collections.singletonMap("sling.service.subservice", "system-notifications");
    private AtomicBoolean isFilter = new AtomicBoolean(false);
    private ComponentContext osgiComponentContext;
    private ServiceRegistration<ResourceChangeListener> eventHandlerRegistration;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private SlingSettingsService slingSettings;

    @Override
    protected void inject(HttpServletRequest servletRequest, HttpServletResponse servletResponse, PrintWriter printWriter) {
        String jquerySrc = servletRequest.getContextPath() + "/etc/clientlibs/granite/jquery.js";
        String notificationsSrc = servletRequest.getContextPath() + "/apps/acs-commons/components/utilities/system-notifications/notification/clientlibs.js";
        printWriter.println(String.format(INJECT_TEXT, jquerySrc, notificationsSrc));
    }

    @Override
    protected boolean accepts(ServletRequest servletRequest, ServletResponse servletResponse) {
        if (!(servletRequest instanceof SlingHttpServletRequest) || !(servletResponse instanceof SlingHttpServletResponse)) {
            return false;
        }
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)servletRequest;
        if (StringUtils.startsWith((String)slingRequest.getResource().getPath(), (String)PATH_NOTIFICATIONS)) {
            return false;
        }
        Resource notificationsFolder = slingRequest.getResourceResolver().getResource(PATH_NOTIFICATIONS);
        if (notificationsFolder == null || this.getNotifications(slingRequest, notificationsFolder).size() < 1) {
            return false;
        }
        return super.accepts(servletRequest, servletResponse);
    }

    @Override
    protected int getInjectIndex(String originalContents) {
        return StringUtils.indexOf((String)originalContents, (String)"</body>");
    }

    @Override
    public List<Resource> getNotifications(SlingHttpServletRequest request, Resource notificationsFolder) {
        ActiveNotificationsResourceVisitor visitor = new ActiveNotificationsResourceVisitor(request);
        visitor.accept(notificationsFolder);
        return visitor.getNotifications();
    }

    @Override
    public String getNotificationId(Page notificationPage) {
        String path = notificationPage.getPath();
        String lastModified = String.valueOf(notificationPage.getLastModified().getTimeInMillis());
        return "uid-" + DigestUtils.sha1Hex((String)(path + lastModified));
    }

    @Override
    public String getMessage(String message, String onTime, String offTime) {
        if (StringUtils.isBlank((String)message)) {
            return message;
        }
        message = StringUtils.trimToEmpty((String)message);
        boolean allowHTML = false;
        if (StringUtils.startsWith((String)message, (String)"html:")) {
            allowHTML = true;
            message = StringUtils.removeStart((String)message, (String)"html:");
        }
        if (onTime != null) {
            message = StringUtils.replace((String)message, (String)"{{ onTime }}", (String)onTime);
        }
        if (offTime != null) {
            message = StringUtils.replace((String)message, (String)"{{ offTime }}", (String)offTime);
        }
        if (!allowHTML) {
            message = message.replaceAll("(\r\n|\n)", "<br />");
        }
        return message;
    }

    private boolean hasNotifications() {
        boolean bl;
        block8: {
            ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH_INFO);
            try {
                Resource notificationsFolder = resourceResolver.getResource(PATH_NOTIFICATIONS);
                NotificationsResourceVisitor visitor = new NotificationsResourceVisitor();
                visitor.accept(notificationsFolder);
                bl = visitor.hasNotifications();
                if (resourceResolver == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceResolver != null) {
                        try {
                            resourceResolver.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LoginException e) {
                    log.error("Could not get an service ResourceResolver", (Throwable)e);
                    return false;
                }
            }
            resourceResolver.close();
        }
        return bl;
    }

    private void registerAsFilter() {
        super.registerAsSlingFilter(this.osgiComponentContext, 0, ".*");
        log.debug("Registered System Notifications as Sling Filter");
    }

    private void registerAsEventHandler() {
        Hashtable<String, String[]> filterProps = new Hashtable<String, String[]>();
        filterProps.put("resource.change.types", new String[]{ResourceChange.ChangeType.ADDED.name(), ResourceChange.ChangeType.REMOVED.name()});
        filterProps.put("resource.paths", new String[]{PATH_NOTIFICATIONS});
        this.eventHandlerRegistration = this.osgiComponentContext.getBundleContext().registerService(ResourceChangeListener.class, (Object)this, filterProps);
        log.debug("Registered System Notifications as Resource Change Listener");
    }

    public void onChange(List<ResourceChange> changes) {
        long start = System.currentTimeMillis();
        if (!this.isAuthor()) {
            log.warn("This change listener should ONLY run on AEM Author.");
            return;
        }
        if (this.hasNotifications()) {
            if (!this.isFilter.getAndSet(true)) {
                this.registerAsFilter();
            }
        } else if (this.isFilter.getAndSet(false)) {
            this.unregisterFilter();
            log.debug("Unregistered System Notifications Sling Filter");
        }
        if (System.currentTimeMillis() - start > 2500L) {
            log.warn("Change handling for System notifications took [ {} ] ms.", (Object)(System.currentTimeMillis() - start));
        }
    }

    @Activate
    protected void activate(ComponentContext ctx) {
        this.osgiComponentContext = ctx;
        if (this.isAuthor()) {
            this.registerAsEventHandler();
            if (this.hasNotifications()) {
                this.isFilter.set(true);
                this.registerAsFilter();
            }
        }
    }

    @Override
    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        super.deactivate(ctx);
        if (this.eventHandlerRegistration != null) {
            this.eventHandlerRegistration.unregister();
            this.eventHandlerRegistration = null;
        }
        this.osgiComponentContext = null;
    }

    private boolean isAuthor() {
        return this.slingSettings.getRunModes().contains("author");
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindSlingSettings(SlingSettingsService slingSettingsService) {
        this.slingSettings = slingSettingsService;
    }

    protected void unbindSlingSettings(SlingSettingsService slingSettingsService) {
        if (this.slingSettings == slingSettingsService) {
            this.slingSettings = null;
        }
    }

    private class ActiveNotificationsResourceVisitor
    extends NotificationsResourceVisitor {
        private final List<Resource> notifications;
        private SlingHttpServletRequest request;

        public ActiveNotificationsResourceVisitor(SlingHttpServletRequest request) {
            this.notifications = new ArrayList<Resource>();
            this.request = request;
        }

        public List<Resource> getNotifications() {
            return this.notifications;
        }

        @Override
        protected void visit(Resource resource) {
            if (this.isActiveNotification(this.request, resource)) {
                this.notifications.add(resource);
            }
        }

        private boolean isActiveNotification(SlingHttpServletRequest request, Resource resource) {
            if (!this.isNotification(resource)) {
                return false;
            }
            PageManager pageManager = (PageManager)request.getResourceResolver().adaptTo(PageManager.class);
            Page notificationPage = pageManager.getContainingPage(resource);
            if (notificationPage == null) {
                log.warn("Trying to get a invalid System Notification page at [ {} ]", (Object)resource.getPath());
                return false;
            }
            if (this.isDismissed(request, notificationPage)) {
                return false;
            }
            ValueMap properties = notificationPage.getProperties();
            boolean enabled = (Boolean)properties.get(SystemNotificationsImpl.PN_ENABLED, (Object)false);
            if (!enabled) {
                return false;
            }
            Calendar onTime = (Calendar)properties.get(SystemNotificationsImpl.PN_ON_TIME, Calendar.class);
            Calendar offTime = (Calendar)properties.get(SystemNotificationsImpl.PN_OFF_TIME, Calendar.class);
            if (onTime == null && offTime == null) {
                return true;
            }
            Calendar now = Calendar.getInstance();
            if (onTime != null && now.before(onTime)) {
                return false;
            }
            return offTime == null || !now.after(offTime);
        }

        private boolean isDismissed(SlingHttpServletRequest request, Page notificationPage) {
            Cookie cookie = CookieUtil.getCookie((HttpServletRequest)request, SystemNotificationsImpl.COOKIE_NAME);
            if (cookie != null) {
                return StringUtils.contains((String)cookie.getValue(), (String)SystemNotificationsImpl.this.getNotificationId(notificationPage));
            }
            return false;
        }
    }

    private class NotificationsResourceVisitor
    extends AbstractResourceVisitor {
        boolean hasNotifications;

        private NotificationsResourceVisitor() {
        }

        public boolean hasNotifications() {
            return this.hasNotifications;
        }

        protected void visit(Resource resource) {
            this.hasNotifications = this.hasNotifications || this.isNotification(resource);
        }

        protected boolean isNotification(Resource resource) {
            return !SystemNotificationsImpl.PATH_NOTIFICATIONS.equals(resource.getPath()) && "cq:Page".equals(resource.getValueMap().get((Object)"jcr:primaryType"));
        }
    }
}

