/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.impl.runners;

import com.adobe.acs.commons.workflow.bulk.execution.impl.runners.AbstractWorkflowRunner;
import com.adobe.acs.commons.workflow.bulk.execution.model.Payload;
import com.adobe.acs.commons.workflow.bulk.execution.model.PayloadGroup;
import com.adobe.acs.commons.workflow.bulk.execution.model.Workspace;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAEMWorkflowRunner
extends AbstractWorkflowRunner {
    private static final Logger log = LoggerFactory.getLogger(AbstractAEMWorkflowRunner.class);

    protected Payload onboardNextPayload(Workspace workspace) {
        long start = System.currentTimeMillis();
        for (PayloadGroup payloadGroup : workspace.getActivePayloadGroups()) {
            Payload payload = payloadGroup.getNextPayload();
            if (payload == null || payload.isOnboarded()) continue;
            workspace.addActivePayload(payload);
            if (log.isTraceEnabled()) {
                log.trace("Took {} ms to onboard next payload", (Object)(System.currentTimeMillis() - start));
            }
            return payload;
        }
        PayloadGroup nextPayloadGroup = null;
        for (PayloadGroup payloadGroup : workspace.getActivePayloadGroups()) {
            Payload payload;
            nextPayloadGroup = this.onboardNextPayloadGroup(workspace, payloadGroup);
            if (nextPayloadGroup == null || (payload = nextPayloadGroup.getNextPayload()) == null) continue;
            workspace.addActivePayload(payload);
            if (log.isTraceEnabled()) {
                log.trace("Onboarded [ {} ] in {} ms", (Object)payload.getPayloadPath(), (Object)(System.currentTimeMillis() - start));
            }
            return payload;
        }
        return null;
    }

    protected void cleanupActivePayloadGroups(Workspace workspace) {
        for (PayloadGroup payloadGroup : workspace.getActivePayloadGroups()) {
            boolean removeActivePayloadGroup = true;
            for (Payload payload : workspace.getActivePayloads()) {
                if (!StringUtils.startsWith((String)payload.getPath(), (String)(payloadGroup.getPath() + "/"))) continue;
                removeActivePayloadGroup = false;
                break;
            }
            if (!removeActivePayloadGroup) continue;
            workspace.removeActivePayloadGroup(payloadGroup);
        }
    }

    protected PayloadGroup onboardNextPayloadGroup(Workspace workspace, PayloadGroup payloadGroup) {
        if (payloadGroup == null) {
            return null;
        }
        PayloadGroup candidatePayloadGroup = payloadGroup.getNextPayloadGroup();
        if (candidatePayloadGroup == null) {
            return null;
        }
        if (workspace.isActive(candidatePayloadGroup) || candidatePayloadGroup.getNextPayload() == null) {
            return this.onboardNextPayloadGroup(workspace, candidatePayloadGroup);
        }
        workspace.addActivePayloadGroup(payloadGroup);
        return candidatePayloadGroup;
    }

    protected void unscheduleJob(Scheduler scheduler, String jobName, Resource configResource, Workspace workspace) {
        try {
            if (configResource != null) {
                scheduler.unschedule(jobName);
            } else {
                scheduler.unschedule(jobName);
                this.stopWithError(workspace);
                log.error("Removed scheduled job [ {} ] due to errors content resource could not be found.", (Object)jobName);
            }
        }
        catch (Exception e1) {
            if (scheduler != null) {
                scheduler.unschedule(jobName);
                log.error("Removed scheduled job [ {} ] due to errors and could not stop normally.", (Object)jobName, (Object)e1);
            }
            log.error("Scheduler is null. Could not un-schedule Job: [ {} ] ", (Object)jobName);
        }
    }
}

