/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.impl.servlets;

import com.adobe.acs.commons.json.JsonObjectUtil;
import com.adobe.acs.commons.workflow.bulk.execution.BulkWorkflowEngine;
import com.adobe.acs.commons.workflow.bulk.execution.impl.TransientWorkflowUtil;
import com.adobe.acs.commons.workflow.bulk.execution.impl.runners.AEMTransientWorkflowRunnerImpl;
import com.adobe.acs.commons.workflow.bulk.execution.impl.runners.AEMWorkflowRunnerImpl;
import com.adobe.acs.commons.workflow.bulk.execution.impl.runners.FastActionManagerRunnerImpl;
import com.adobe.acs.commons.workflow.bulk.execution.impl.servlets.JSONErrorUtil;
import com.adobe.acs.commons.workflow.bulk.execution.model.Config;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"POST"}, resourceTypes={"acs-commons/components/utilities/bulk-workflow-manager"}, selectors={"start"}, extensions={"json"})
public class StartServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(StartServlet.class);
    @Reference
    private BulkWorkflowEngine bulkWorkflowEngine;

    protected final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try {
            JsonObject params = new JsonParser().parse(request.getParameter("params")).getAsJsonObject();
            ModifiableValueMap properties = (ModifiableValueMap)request.getResource().adaptTo(ModifiableValueMap.class);
            properties.put((Object)"runnerType", (Object)JsonObjectUtil.getString(params, "runnerType"));
            properties.put((Object)"queryType", (Object)JsonObjectUtil.getString(params, "queryType"));
            properties.put((Object)"queryStatement", (Object)JsonObjectUtil.getString(params, "queryStatement"));
            properties.put((Object)"relativePath", (Object)StringUtils.removeStart((String)JsonObjectUtil.getString(params, "relativePath", ""), (String)"/"));
            properties.put((Object)"workflowModel", (Object)JsonObjectUtil.getString(params, "workflowModelId"));
            properties.put((Object)"interval", (Object)JsonObjectUtil.getInteger(params, "interval", 10));
            properties.put((Object)"timeout", (Object)JsonObjectUtil.getInteger(params, "timeout", 30));
            properties.put((Object)"throttle", (Object)JsonObjectUtil.getInteger(params, "throttle", 10));
            properties.put((Object)"retryCount", (Object)JsonObjectUtil.getInteger(params, "retryCount", 0));
            properties.put((Object)"batchSize", (Object)JsonObjectUtil.getInteger(params, "batchSize", 10));
            String userEventData = JsonObjectUtil.getString(params, "userEventData");
            if (userEventData != null && !userEventData.isEmpty()) {
                properties.put((Object)"userEventData", (Object)userEventData);
            }
            properties.put((Object)"purgeWorkflow", (Object)JsonObjectUtil.getBoolean(params, "purgeWorkflow", false));
            properties.put((Object)"autoThrottle", (Object)JsonObjectUtil.getBoolean(params, "autoThrottle", true));
            if (AEMWorkflowRunnerImpl.class.getName().equals(properties.get("runnerType", String.class)) && TransientWorkflowUtil.isTransient(request.getResourceResolver(), (String)properties.get("workflowModel", String.class))) {
                properties.put((Object)"runnerType", (Object)AEMTransientWorkflowRunnerImpl.class.getName());
            }
            if (FastActionManagerRunnerImpl.class.getName().equals(properties.get("runnerType", (Object)"")) && (Integer)properties.get("retryCount", (Object)0) > 0) {
                properties.put((Object)"batchSize", (Object)1);
            }
            request.getResourceResolver().commit();
            Config config = (Config)request.getResource().adaptTo(Config.class);
            this.bulkWorkflowEngine.initialize(config);
            this.bulkWorkflowEngine.start(config);
            response.sendRedirect(request.getResourceResolver().map((HttpServletRequest)request, request.getResource().getPath()) + ".status.json");
        }
        catch (RepositoryException e) {
            log.error("Could not initialize Bulk Workflow: {}", (Throwable)e);
            JSONErrorUtil.sendJSONError(response, 500, "Could not initialize Bulk Workflow.", e.getMessage());
        }
        catch (IllegalArgumentException e) {
            log.warn("Could not initialize Bulk Workflow due to invalid arguments: {}", (Throwable)e);
            JSONErrorUtil.sendJSONError(response, 500, "Could not initialize Bulk Workflow due to invalid arguments.", e.getMessage());
        }
        catch (Exception e) {
            log.error("Could not initialize Bulk Workflow due to unexpected error: {}", (Throwable)e);
            JSONErrorUtil.sendJSONError(response, 500, "Could not start Bulk Workflow.", e.getMessage());
        }
    }

    protected void bindBulkWorkflowEngine(BulkWorkflowEngine bulkWorkflowEngine) {
        this.bulkWorkflowEngine = bulkWorkflowEngine;
    }

    protected void unbindBulkWorkflowEngine(BulkWorkflowEngine bulkWorkflowEngine) {
        if (this.bulkWorkflowEngine == bulkWorkflowEngine) {
            this.bulkWorkflowEngine = null;
        }
    }
}

