/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.synthetic.impl;

import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowModel;
import com.adobe.acs.commons.workflow.synthetic.impl.cq.exceptions.SyntheticWorkflowModelException;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.model.WorkflowModel;
import com.day.cq.workflow.model.WorkflowNode;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntheticWorkflowModelImpl
implements SyntheticWorkflowModel {
    private static final Logger log = LoggerFactory.getLogger(SyntheticWorkflowModelImpl.class);
    private static final String[] WORKFLOW_MODEL_PATH_PREFIXES = new String[]{"", "/etc/workflow/models"};
    private static final String WORKFLOW_MODEL_PATH_SUFFIX = "/jcr:content/model";
    private Map<String, Map<String, Object>> syntheticWorkflowModel = new LinkedHashMap<String, Map<String, Object>>();

    public SyntheticWorkflowModelImpl(WorkflowSession workflowSession, String modelId, boolean ignoredIncompatibleTypes) throws WorkflowException {
        try {
            modelId = this.findWorkflowModel(workflowSession, modelId);
        }
        catch (RepositoryException ex) {
            log.error("Unable to locate workflow with id " + modelId, (Throwable)ex);
            throw new WorkflowException(ex.getMessage(), (Throwable)ex);
        }
        WorkflowModel model = workflowSession.getModel(modelId);
        if (model == null) {
            log.error("Unable to locate workflow starting node for " + modelId);
            throw new WorkflowException("Unable to locate workflow starting node for " + modelId);
        }
        log.debug("Located Workflow Model [ {} ] with modelId [ {} ]", (Object)model.getTitle(), (Object)modelId);
        List nodes = model.getNodes();
        for (WorkflowNode node : nodes) {
            String processName;
            if (!ignoredIncompatibleTypes && !this.isValidType(node)) {
                throw new SyntheticWorkflowModelException(node.getId() + " is of incompatible type " + node.getType());
            }
            if (node.getTransitions().size() > 1) {
                throw new SyntheticWorkflowModelException(node.getId() + " has unsupported decision based execution (more than 1 transitions is not allowed)");
            }
            log.debug("Workflow node title [ {} ]", (Object)node.getTitle());
            if (!this.isProcessType(node) || !StringUtils.isNotBlank((String)(processName = (String)node.getMetaDataMap().get("PROCESS", (Object)"")))) continue;
            log.debug("Adding Workflow Process [ {} ] to Synthetic Workflow", (Object)processName);
            this.syntheticWorkflowModel.put(processName, (Map<String, Object>)node.getMetaDataMap());
        }
    }

    @Override
    public final String[] getWorkflowProcessNames() {
        return this.syntheticWorkflowModel.keySet().toArray(new String[this.syntheticWorkflowModel.keySet().size()]);
    }

    @Override
    public final Map<String, Map<String, Object>> getSyntheticWorkflowModelData() {
        return this.syntheticWorkflowModel;
    }

    private boolean isValidType(WorkflowNode node) {
        return "START".equals(node.getType()) || "PROCESS".equals(node.getType());
    }

    private boolean isProcessType(WorkflowNode node) {
        return "PROCESS".equals(node.getType());
    }

    private String findWorkflowModel(WorkflowSession workflowSession, String modelId) throws RepositoryException {
        String separator = modelId.startsWith("/") ? "" : "/";
        for (String prefix : WORKFLOW_MODEL_PATH_PREFIXES) {
            String testPath = prefix + separator + modelId;
            String olderWorkflowStyle = testPath + WORKFLOW_MODEL_PATH_SUFFIX;
            if (workflowSession.getSession().nodeExists(olderWorkflowStyle)) {
                return olderWorkflowStyle;
            }
            if (!workflowSession.getSession().nodeExists(testPath)) continue;
            return testPath;
        }
        throw new RepositoryException("Unable to locate workflow model with id " + modelId);
    }
}

