/*
 * Decompiled with CFR 0.152.
 */
package design.aem.components;

import com.adobe.granite.ui.components.AttrBuilder;
import design.aem.components.ComponentField;
import design.aem.utils.components.ComponentsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentProperties
extends ValueMapDecorator {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ComponentProperties.class);
    public AttrBuilder attr;
    public ArrayList<ComponentField> expressionFields;

    public ComponentProperties() {
        super(new HashMap());
    }

    public ComponentProperties(Map<String, Object> base) {
        super(base);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        return Objects.deepEquals((Object)this, obj);
    }

    public int hashCode() {
        int result = 31 * this.expressionFields.hashCode();
        result = 31 * result + this.attr.hashCode();
        return result;
    }

    public void putAll(Map<? extends String, ?> map) {
        if (map != null) {
            super.putAll(map);
        }
    }

    public void putAll(Map<? extends String, ?> map, Boolean update) {
        if (map != null) {
            if (update == null || !update.booleanValue()) {
                super.putAll(map);
                return;
            }
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                if (super.containsKey((Object)entry.getKey())) {
                    Object currentValue = super.get((Object)entry.getKey());
                    Object newValue = entry.getValue();
                    if (currentValue != null && newValue != null) {
                        if (newValue.getClass().isArray()) {
                            if (ArrayUtils.getLength(newValue) == 0) continue;
                            if (currentValue.getClass().isArray() && ArrayUtils.getLength((Object)currentValue) != 0) {
                                LOGGER.warn("skip: {} current value it not empty array", (Object)entry.getKey());
                                continue;
                            }
                        } else if (StringUtils.isEmpty((CharSequence)newValue.toString())) continue;
                    }
                }
                super.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public void evaluateExpressionFields() {
        JexlEngine jexl = new JexlBuilder().create();
        JxltEngine jxlt = jexl.createJxltEngine();
        MapContext jc = new MapContext((Map<String, Object>)((Object)this));
        if (this.expressionFields != null) {
            for (ComponentField field : this.expressionFields) {
                String defaultValueExpression = "";
                Object fieldDefaultValue = field.getDefaultValue();
                if (fieldDefaultValue instanceof String) {
                    defaultValueExpression = fieldDefaultValue.toString();
                }
                try {
                    if (field.getValue() == null) continue;
                    if (!field.getValue().getClass().isArray()) {
                        Object expressonResult;
                        Object fieldValue = this.get(field.getFieldName(), null);
                        String valueExpression = defaultValueExpression;
                        if (ComponentsUtil.isStringRegex((String)fieldValue)) {
                            valueExpression = (String)fieldValue;
                        }
                        if ((expressonResult = ComponentsUtil.evaluateExpressionWithValue(jxlt, jc, valueExpression, fieldValue)) == null) continue;
                        this.put(field.getFieldName(), expressonResult);
                        this.attr.set(field.getDataAttributeName(), (String)expressonResult);
                        continue;
                    }
                    Object[] values = (String[])field.getValue();
                    if (!ArrayUtils.isEmpty((Object[])values)) {
                        for (int i = 0; i < values.length; ++i) {
                            Object valueExpression = defaultValueExpression;
                            if (ComponentsUtil.isStringRegex((String)values[i])) {
                                valueExpression = values[i];
                            }
                            values[i] = (String)ComponentsUtil.evaluateExpressionWithValue(jxlt, jc, (String)valueExpression, values[i]);
                        }
                    } else {
                        values = (String[])ArrayUtils.add((Object[])values, (Object)((String)ComponentsUtil.evaluateExpressionWithValue(jxlt, jc, defaultValueExpression, null)));
                    }
                    this.put(field.getFieldName(), values);
                    if (!StringUtils.isNotEmpty((CharSequence)field.getDataAttributeName())) continue;
                    if (field.getDataAttributeName().equals(" ")) {
                        for (Object value : values) {
                            if (!((String)value).contains("=")) {
                                this.attr.add((String)value, "true");
                                continue;
                            }
                            String[] items = ((String)value).split("=");
                            this.attr.add(items[0], StringUtils.substringBetween((String)items[1], (String)"\"", (String)"\""));
                        }
                        continue;
                    }
                    this.attr.add(field.getDataAttributeName(), StringUtils.join((Object[])((String[])field.getValue()), (String)","));
                }
                catch (JexlException jex) {
                    LOGGER.error("evaluateExpressionFields: field={},JexlException={}", (Object)field, (Object)jex);
                }
                catch (Exception ex) {
                    LOGGER.error("evaluateExpressionFields: field={},Exception={}", (Object)field, (Object)ex);
                }
            }
        }
    }
}

