/*
 * Decompiled with CFR 0.152.
 */
package design.aem.impl.services;

import design.aem.services.ContentAccess;
import java.util.Collections;
import java.util.Map;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class ContentAccessImpl
implements ContentAccess {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ContentAccessImpl.class);
    private static final String SERVICE_NAME = "content-services";
    private static final Map<String, Object> AUTH_INFO = Collections.singletonMap("sling.service.subservice", "content-services");
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    @Activate
    protected void activate() {
        LOGGER.info("activate: resourceResolverFactory={}", (Object)this.resourceResolverFactory);
    }

    @Deactivate
    protected void deactivate() {
        LOGGER.info("deactivate: resourceResolverFactory={}", (Object)this.resourceResolverFactory);
    }

    @Override
    public ResourceResolver getAdminResourceResolver() {
        try {
            return this.resourceResolverFactory.getServiceResourceResolver(AUTH_INFO);
        }
        catch (LoginException ex) {
            LOGGER.error("openAdminResourceResolver: Login Exception when getting admin resource resolver, ex={0}", (Throwable)ex);
        }
        catch (Exception ex) {
            LOGGER.error("openAdminResourceResolver: could not get elevated resource resolver, returning non elevated resource resolver. ex={0}", (Throwable)ex);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getSubServiceUser() {
        Map<String, String> authInfo = Collections.singletonMap("sling.service.subservice", SERVICE_NAME);
        try (ResourceResolver serviceResolver = this.resourceResolverFactory.getServiceResourceResolver(authInfo);){
            String string = serviceResolver.getUserID();
            return string;
        }
        catch (LoginException ex) {
            LOGGER.error("getSubServiceUser: Login Exception when obtaining a User for the Bundle Service: {}, ex={}", (Object)SERVICE_NAME, (Object)ex);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getBundleServiceUser() {
        try (ResourceResolver serviceResolver = this.resourceResolverFactory.getServiceResourceResolver(null);){
            String string = serviceResolver.getUserID();
            return string;
        }
        catch (LoginException ex) {
            LOGGER.error("getBundleServiceUser: Login Exception when obtaining a User for the Bundle Service ex={0}", (Throwable)ex);
            return "";
        }
    }
}

